<?php
/*------------------------------------------------------------------------
# room.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class OsCalendarRoom{
	/**
	 * Osproperty default
	 *
	 * @param unknown_type $option
	 */
	function display($option,$task){
		global $mainframe,$configClass;
		require_once(JPATH_ROOT.DS."components".DS."com_osproperty".DS."helpers".DS."common.php");
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS."tables".DS."order.php");
		$document = JFactory::getDocument();
		$pid = $mainframe->input->getInt('pid',0);
		$cid = $mainframe->input->get('cid',array(),'array');
		$id  = $mainframe->input->getInt('id',0);
		
		if((!HelperOspropertyCommon::isAgent()) and (!HelperOspropertyCommon::isCompanyAdmin())){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JUri::root());
		}
		
		if((HelperOspropertyCommon::isCompanyAdmin()) and ($configClass['company_admin_add_properties'] == 0)){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JUri::root());
		}
		
		if((!HelperOspropertyCommon::isOwner($pid)) and (!HelperOspropertyCommon::isCompanyOwner($pid))){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JUri::root());
		}
		
		switch ($task){
			case "room_manage":
				OsCalendarRoom::manageRooms($pid);
			break;
			case "room_addnew":
					OsCalendarRoom::room_edit($pid,0);
			break;
			case "room_edit":
				OsCalendarRoom::room_edit($pid,$cid[0]);
			break;
			case "room_save":
				OsCalendarRoom::room_save($pid,1);
			break;
			case "room_apply":
				OsCalendarRoom::room_save($pid,0);
			break;
			case "room_cancel":
				$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid));
			break;
			case "room_publish":
				OsCalendarRoom::changeState($option,$pid,$cid,1);
			break;
			case "room_unpublish":
				OsCalendarRoom::changeState($option,$pid,$cid,0);
			break;
			case "room_remove":
				OsCalendarRoom::removeRooms($pid,$cid);
			break;
			case "room_saveorder":
				OsCalendarRoom::saveorder($option,$pid);
			break;
			case "room_orderup":
				OsCalendarRoom::orderup($pid);
			break;
			case "room_orderdown":
				OsCalendarRoom::orderdown($pid);
			break;
		}
	}
	
	/**
	 * Manage Rooms
	 *
	 * @param unknown_type $pid
	 */
	function manageRooms($pid){
		global $mainframe,$configClass,$cClass,$lang_suffix;
		$db = JFactory::getDbo();
		$db->setQuery("Select id,ref,pro_name from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();

        if($cClass['allow_room'] == 0){
            $db->setQuery("Select count(id) from #__oscalendar_rooms where pid = '$pid'");
            $count = $db->loadResult();
            if($count == 0){
                //create new room
                $row = &JTable::getInstance('Room','OsCalendarTable');
                $row->id = 0;
                $row->pid = $pid;
                $row->room_number = 1;
                $row->max_adult = 4;
                $row->max_child = 2;
                $row->published = 1;
                $row->store();
            }
        }
		
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
		$pathway	= $mainframe->getPathway();
		$pathway->addItem($title,JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
        if($cClass['allow_room'] == 1) {
            $pathway->addItem(JText::_('OS_MANAGE_ROOMS'), '');
            $title = $title . " > " . JText::_('OS_MANAGE_ROOMS');
        }
		OSPHelper::generateHeading(1,$title);
		
		$limit = $mainframe->input->getInt('limit',20);
		$limitstart = $mainframe->input->getInt('limitstart',0);
		$filter_order 	 	= $mainframe->input->getString('filter_order','ordering');
		$filter_order_Dir 	= $mainframe->input->getString('filter_order_Dir','');
		$lists['order'] 	= $filter_order;
		$lists['order_Dir'] = $filter_order_Dir;
		$db->setQuery("Select count(id) from #__oscalendar_rooms where pid = '$pid'");
		$count = $db->loadResult();
		include_once(JPATH_ROOT.'/components/com_osproperty/helpers/pagination.php');
		$pageNav = new OSPJPagination($count,$limitstart,$limit);
		$db->setQuery("Select * from #__oscalendar_rooms where pid = '$pid' order by $filter_order $filter_order_Dir",$pageNav->limitstart,$pageNav->limit);
		$rows = $db->loadObjectList();
		HTML_OsCalendarRoom::listRooms($property,$rows,$pageNav,$lists);
	}
	
	/**
	 * Add/edit room
	 *
	 * @param unknown_type $id
	 */
	function room_edit($pid,$id){
		global $mainframe,$configClass,$cClass,$languages;
		$document = JFactory::getDocument();
		$document->addScript(JURI::root()."components/com_oscalendar/js/lib.js");
		$db = JFactory::getDBO();
		$row = &JTable::getInstance('Room','OsCalendarTable');
		if($id > 0){
			$row->load((int)$id);
			$func = JText::_('OS_EDIT');
		}else{
			$row->published = 1;
			$func = JText::_('OS_ADDNEW');
		}
		
		//$lists['state'] = JHTML::_('select.booleanlist', 'published', '', $row->published);
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option',1,JText::_('OS_YES'));
		$optionArr[] = JHTML::_('select.option',0,JText::_('OS_NO'));
		$lists['state']   = JHTML::_('select.genericlist',$optionArr,'published','class="input-mini"','value','text',$row->published);
		$db->setQuery("Select id,ref,pro_name from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
		$pathway	= $mainframe->getPathway();
		$pathway->addItem($title,JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
        if($cClass['allow_room'] == 1) {
            $pathway->addItem(JText::_('OS_MANAGE_ROOMS'), JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid=' . $pid . '&Itemid=' . $mainframe->input->getInt('Itemid', 0)));
        }
		if($row->id > 0){
			$pathway->addItem($row->room_name,'');
		}
		$pathway->addItem($func,'');
        if($cClass['allow_room'] == 1) {
            $title = $title . " > " . $row->room_name . " > " . $func;
        }else{
            $title = $title . " > " . $func;
        }
		OSPHelper::generateHeading(1,$title);
		
		HTML_OsCalendarRoom::editRoom($property,$row,$lists,$translatable);
	}
	
	/**
	 * Save room information
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $save
	 */
	function room_save($pid, $save){
		global $mainframe,$configClass,$languages;
		$db = JFactory::getDBO();
		jimport('joomla.filesystem.file');
		$remove_photo = $mainframe->input->getInt('remove_photo',0);
		
		$row = &JTable::getInstance('Room','OsCalendarTable');
		$post = $mainframe->input->post->getArray();
		if(is_uploaded_file($_FILES['photo']['tmp_name'])){
			if(!HelperOspropertyCommon::checkIsPhotoFileUploaded('photo')){
				//return to previous page
				?>
				<script language="javascript">
				window.history(-1);
				</script>
				<?php
			}else{
				$filename = time()."_".$_FILES['photo']['name'];
				$dest     = JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms".DS.$filename;
				$thumb	  = JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms".DS."thumb".DS.$filename;
				JFile::upload($_FILES['photo']['tmp_name'],$dest);
				//resize
				@copy($dest,$thumb);
				include_once(JPATH_ADMINISTRATOR.'/components/com_osproperty/helpers/classimage.php');
				OSPHelper::resizePhoto($thumb,100,100);
				$row->room_image = $filename;
			}
		}elseif($remove_photo == 1){
			$row->room_image = "";
		}
		$row->bind($post);
		$room_description = $_POST['room_desc'];
		$row->room_desc = $room_description;
		$id = $mainframe->input->getInt('id',0);
		if($id == 0){
			//get the ordering
			$db->setQuery("Select ordering from #__oscalendar_rooms where pid = '$pid' order by ordering desc limit 1");
			$ordering = $db->loadResult();
			$row->ordering = $ordering + 1;
		}
		$row->store();
		//print_r($row);
		if($id == 0){
			$id = $db->insertID();
		}
		$translatable = JLanguageMultilang::isEnabled() && count($languages);
		if($translatable){
			foreach ($languages as $language){	
				$sef = $language->sef;
				$room_name_language = $mainframe->input->getString('room_name_'.$sef,'');
				$room_description_language = $_POST['room_desc_'.$sef];
				if($room_name_language == ""){
					$room_name_language = $row->room_name;
				}
				if($room_name_language != ""){
					$room = &JTable::getInstance('Room','OscalendarTable');
					$room->id = $id;
					$room->{'room_name_'.$sef} = $room_name_language;
					$room->store();
				}
				if($room_description_language == ""){
					$room_description_language = $row->room_desc;
				}
				if($room_description_language != ""){
					$room = &JTable::getInstance('Room','OscalendarTable');
					$room->id = $id;
					$room->{'room_desc_'.$sef} = $room_description_language;
					$room->store();
				}
			}
		}
		$msg = JText::_('OS_ITEM_HAS_BEEN_SAVED');
		$mainframe->enqueueMessage($msg);
		if($save == 1){
			$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
		}else{
			$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_edit&cid[]=$id&pid=$pid"));
		}
	}
	
	/**
	 * Change status of the field group(s)
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 * @param unknown_type $state
	 */
	function changeState($option,$pid,$cid,$state){
		global $mainframe;
		$db = JFactory::getDBO();
		if($cid){
			$cids = implode(",",$cid);
			$db->setQuery("Update #__oscalendar_rooms set published = '$state' where id in ($cids)");
			$db->execute();
		}
		$msg = JText::_("OS_ITEM_STATUS_HAS_BEEN_CHANGED");
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
	}
	
	
	/**
	 * Save order
	 *
	 * @param unknown_type $option
	 */
	function saveorder($option,$pid){
		global $mainframe;
		$db = JFactory::getDBO();
		$msg = JText::_( 'New ordering saved' );
		$cid 	= $mainframe->input->get( 'cid', array(), 'array' );
		JArrayHelper::toInteger($cid);
		$row = &JTable::getInstance('Room','OsCalendarTable');
		$groupings	= array();
		$order		= $mainframe->input->get( 'order', array(),  'array' );
		JArrayHelper::toInteger($order);

		// update ordering values
		for( $i=0; $i < count($cid); $i++ ) {
			$row->load( $cid[$i] );
			// track parents
			$groupings[] = $row->pid;
			if ($row->ordering != $order[$i]) {
				$row->ordering = $order[$i];
				if (!$row->store()) {
					$this->setError($row->getError());
					return false;
				}
			} // if
		} // for

		// execute updateOrder for each parent group
		$groupings = array_unique( $groupings );
		foreach ($groupings as $group){
			$row->reorder(' pid = '.(int) $group.' AND published = 1');
		}
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
	}
	
	
	
	/**
	 * Order up
	 *
	 * @return unknown
	 */
	function orderup($pid){
		global $mainframe,$_jversion;

		$cid	= $mainframe->input->get( 'cid', array(),  'array' );
		JArrayHelper::toInteger($cid);

		if (isset($cid[0]) && $cid[0]) {
			$id = $cid[0];
		} else {
			$this->setRedirect(
				'index.php?option=com_oscalendar&task=room_manage',
				JText::_('OS_NO_ITEM_SELECTED')
			);
			return false;
		}
		if (OsCalendarRoom::orderItem($id, -1)) {
			$msg = JText::_( 'OS_MENU_ITEM_MOVED_UP' );
		}
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
	}
	
	/**
	 * Order down
	 *
	 * @param unknown_type $option
	 */
	function orderdown($pid){
		global $mainframe,$_jversion;

		$cid	= $mainframe->input->get( 'cid', array(), 'array' );
		JArrayHelper::toInteger($cid);

		if (isset($cid[0]) && $cid[0]) {
			$id = $cid[0];
		} else {
			$this->setRedirect(
				'index.php?option=com_oscalendar&task=room_manage',
				JText::_('OS_NO_ITEM_SELECTED')
			);
			return false;
		}
		if (OsCalendarRoom::orderItem($id, 1)) {
			$msg = JText::_( 'OS_MENU_ITEM_MOVED_DOWN' );
		}
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
	}
	
	/**
	 * Remove field groups
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 */
	function removeRooms($pid,$cid){
		global $mainframe;
		$db = JFactory::getDBO();
		if($cid){
			for($i=0;$i<count($cid);$i++){
				$id = $cid[$i];
				$db->setQuery("Select room_image from #__oscalendar_rooms where id = '$id'");
				$category_image = $db->loadResult();
				$imagelink = JPATH_ROOT.DS."components".DS."com_oscalendar".DS."rooms";
				unlink($imagelink.DS.$category_image);
				unlink($imagelink.DS."thumb".DS.$category_image);
			}
			$cids = implode(",",$cid);
			$db->setQuery("Delete from #__oscalendar_rooms where id in ($cids)");
			$db->execute();
			$db->setQuery("Delete from #__oscalendar_room_prices where rid in ($cids)");
			$db->execute();
		}
		$msg = JText::_('OS_ITEM_HAS_BEEN_DELETED');
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
	}
}
?>