<?php
/*------------------------------------------------------------------------
# default.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2018 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class HTML_OsCalendarDefault{
	static function showOrderDetailsForm($row,$property,$room,$fields){
		global $mainframe,$configClass,$cClass;
		?>
		<div class="row-fluid">
			<div class="span12">
				<div style="border-bottom:1px dotted #CCC;">
					<h2>
						<?php echo JText::_('OS_CALENDAR_ORDER')?>: #<?php echo $row->id;?>
					</h2>
				</div>
				<div class="clearfix"></div>
				<table width="100%">
					<td width="50%" valign="top" style="padding-top:10px;text-align:left;">
						<strong>
							<u><?php echo JText::_('OS_BOOKING_DETAILS');?></u>
						</strong>
						<BR /><BR />
						<?php echo JText::_('OS_BOOKING_DATE');?>: <?php echo date($cClass['date_time_format'],strtotime($row->order_date));?>
						<BR />
						<?php echo JText::_('OS_BOOKING_NAME');?>: <?php echo $row->name?>
						<BR />
						<?php echo JText::_('OS_BOOKING_EMAIL');?>: <?php echo $row->email?>
						<BR />
						<?php echo JText::_('OS_BOOKING_PHONE');?>: <?php echo $row->phone?>
						<BR />
						<?php echo JText::_('OS_BOOKING_NOTES');?>:<br /> 
						<?php echo $row->notes?>
						<BR />
						<?php echo JText::_('OS_CALENDAR_ORDER_STATUS');?>:
						<?php 
						switch ($row->order_status){
							case "P":
								?>
								<span class="label label-warning"><?php echo JText::_('OS_CALENDAR_PENDDING');?></span>
								<?php
							break;
							case "C":
								?>
								<span class="label label-important"><?php echo JText::_('OS_CALENDAR_CANCEL');?></span>
								<?php
							break;
							case "S":
								?>
								<span class="label label-success"><?php echo JText::_('OS_CALENDAR_COMPLETE');?></span>
								<?php
							break;
						}
						?>
					</td>
					<td width="50%" valign="top" style="padding-top:10px;text-align:left;">
						<strong>
							<u><?php echo JText::_('OS_STAY_DETAILS');?></u>
						</strong>
						<BR /><BR />
						<?php echo JText::_('OS_PROPERTY');?>: <?php if ($property->ref != "") echo $property->ref.", "; ?><?php echo OSPHelper::getLanguageFieldValue($property,'pro_name');?>
                        <?php
                        if($cClass['allow_room'] == 1){
                        ?>
                            <BR />
                            <?php echo JText::_('OS_ROOM');?>: <?php echo OSPHelper::getLanguageFieldValue($room,'room_name');?>
                            <BR />
                            <?php echo JText::_('OS_NROOM');?>: <?php echo $row->nroom;?>
                            <?php } ?>
						<?php if($row->nAdults > 0){ ?>
						<BR />
						<?php echo JText::_('OS_ADULT');?>: <?php echo $row->nAdults;?>
						<?php } ?>
						<?php if($row->nChilds > 0){ ?>
						<BR />
						<?php echo JText::_('OS_CHILD');?>: <?php echo $row->nChilds;?>
						<?php } ?>
						<BR />
						<?php echo JText::_('OS_CALENDAR_CHECK_IN');?>: <?php echo OSCHelper::showDateFormat($row->book_from,0);?>&nbsp;&nbsp;
						<?php echo JText::_('OS_CALENDAR_CHECK_OUT');?>: <?php echo OSCHelper::showDateFormat($row->book_to,0);?> 
					</td>
				</table>
				<BR />
				<?php
				$total1 = 0;
				$total2 = 0;
				$total3 = 0;
				?>
				<table width="100%">
					<tr>
						<td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid white !important;border-right:1px solid white !important;" width="60%">
							<?php echo JText::_('OS_PRICE_BREAKDOWN');?>
						</td>
						<td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid white !important;border-right:1px solid white !important;" width="10%">
							<?php echo JText::_('OS_RATE');?>
						</td>
						<td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid white !important;border-right:1px solid white !important;" width="10%">
							<?php echo JText::_('OS_CALENDAR_TAX');?>
						</td>
						<td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid white !important;" width="10%">
							<?php echo JText::_('OS_INCL_TAX');?>
						</td>
					</tr>
					<tr>
						<td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;border-right:1px solid white !important;" width="60%">
							
						</td>
						<td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;border-right:1px solid white !important;" width="10%">
							<?php echo OSCHelper::showCurrency($row->curr);?>
						</td>
						<td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;border-right:1px solid white !important;" width="10%">
							<?php echo OSCHelper::showCurrency($row->curr);?>
						</td>
						<td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;" width="10%">
							<?php echo OSCHelper::showCurrency($row->curr);?>
						</td>
					</tr>
					<tr>
						<td style="color:white;background-color:#ABABAB;pading:7px;text-align:left;font-weight:bold;" width="100%" colspan="4">
							<?php echo JText::_('OS_BOOKING_REFERENCE_NO')?>: #<?php echo $row->id;?>
						</td>
					</tr>
					<tr>
						<td style="color:gray;background-color:#fff;pading:7px;text-align:left;border-right:1px solid white !important;" width="60%">
							<?php echo JText::_('OS_ROOM_FEE');?>
						</td>
						<td style="color:gray;background-color:#fff;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
							<?php echo OSCHelper::showMoneyWithoutCurrency($row->room_fee);
							$total1 += $row->room_fee;
							?>
						</td>
						<td style="color:gray;background-color:#fff;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
							<?php echo OSCHelper::showMoneyWithoutCurrency(round(($row->room_fee*$cClass['tax_payment'])/100,2));
							$total2 += round(($row->room_fee*$cClass['tax_payment'])/100,2);
							?>
						</td>
						<td style="color:gray;background-color:#fff;pading:7px;text-align:left;" width="10%">
							<?php echo OSCHelper::showMoneyWithoutCurrency(round($row->room_fee + round(($row->room_fee*$cClass['tax_payment'])/100,2),2));
							$total3 += round($row->room_fee + round(($row->room_fee*$cClass['tax_payment'])/100,2),2);
							?>
						</td>
					</tr>
					<?php
					$db = JFactory::getDbo();
					if(count($fields) > 0){
						$k = 0;
						for($i=0;$i<count($fields);$i++){
							$field = $fields[$i];
							switch ($field->field_type){
								case "0":
								case "1":
									$db->setQuery("Select * from #__oscalendar_order_field_values where order_id = '$row->id' and field_id = '$field->id'");
									$values = $db->loadObjectList();
									if(count($values) > 0){
										if($k % 2 == 0){
											$bgcolor = "#efefef";
										}else{
											$bgcolor = "#ffffff";
										}
										$k++;
										$value = $values[0]->field_value;
										?>
										<tr>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="60%">
												<?php echo $field->field_label;?>: <?php echo $value;?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
												<?php echo OSCHelper::showMoneyWithoutCurrency(0);?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
												<?php echo OSCHelper::showMoneyWithoutCurrency(0);?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;" width="10%">
												<?php echo OSCHelper::showMoneyWithoutCurrency(0);?>
											</td>
										</tr>
										<?php
									}
								break;
								case "2":
									$query = "Select a.*,b.option_price,c.price_for_order from #__oscalendar_field_options as a inner join #__oscalendar_order_field_options as b on a.id = b.option_id inner join #__oscalendar_fields as c on a.field_id = c.id where b.order_id = '$row->id' and b.field_id = '$field->id'";
									$db->setQuery($query);
									$values = $db->loadObjectList();
									if(count($values) > 0){
										if($k % 2 == 0){
											$bgcolor = "#efefef";
										}else{
											$bgcolor = "#ffffff";
										}
										$k++;
										$value = $values[0];
										?>
										<tr>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="60%">
												<?php echo OSPHelper::getLanguageFieldValue($field,'field_label');?>: 
												<?php echo OSPHelper::getLanguageFieldValue($value,'field_option');?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
												<?php
												if($value->price_for_order == 0){
													$temp_price = $value->option_price;
												}else{
													$temp_price = $row->nroom*$value->option_price;
												}
												echo OSCHelper::showMoneyWithoutCurrency($temp_price);
												$total1 += $temp_price;
												?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
												<?php 
												echo OSCHelper::showMoneyWithoutCurrency(round(($temp_price*$cClass['tax_payment'])/100,2));
												$total2 += round(($temp_price*$cClass['tax_payment'])/100,2);
												?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;" width="10%">
												<?php 
												echo OSCHelper::showMoneyWithoutCurrency(round($temp_price + round(($temp_price*$cClass['tax_payment'])/100,2),2));
												$total3 += round($temp_price + round(($temp_price*$cClass['tax_payment'])/100,2),2);
												?>
											</td>
										</tr>
										<?php
									}
								break;
								case "3":
									//$query = "Select a.*,b.option_price from #__oscalendar_field_options as a inner join #__oscalendar_order_field_options as b on a.id = b.option_id where b.order_id = '$row->id' and b.field_id = '$field->id'";
									
									$query = "Select a.*,b.option_price,c.price_for_order from #__oscalendar_field_options as a inner join #__oscalendar_order_field_options as b on a.id = b.option_id inner join #__oscalendar_fields as c on a.field_id = c.id where b.order_id = '$row->id' and b.field_id = '$field->id'";
									$db->setQuery($query);
									$values = $db->loadObjectList();
									if(count($values) > 0){
										if($k % 2 == 0){
											$bgcolor = "#efefef";
										}else{
											$bgcolor = "#ffffff";
										}
										$k++;
										$temp = array();
										$total = 0;
										for($j=0;$j<count($values);$j++){
											$value = $values[$j];
											$temp[] = OSPHelper::getLanguageFieldValue($value,'field_option');
											if($value->price_for_order == 0){
												$total += $value->option_price;
											}else{
												$total += $row->nroom*$value->option_price;
											}
										}
										?>
										<tr>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="60%">
												<?php echo $field->field_label;?>: 
												<?php echo implode(" + ",$temp);?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
												<?php echo OSCHelper::showMoneyWithoutCurrency(round($total,2));
												$total1 += $total;
												?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid white !important;" width="10%">
												<?php echo OSCHelper::showMoneyWithoutCurrency(round(($total*$cClass['tax_payment'])/100,2));
												$total2 += round(($total*$cClass['tax_payment'])/100,2);
												?>
											</td>
											<td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;" width="10%">
												<?php echo OSCHelper::showMoneyWithoutCurrency(round($total + round(($total*$cClass['tax_payment'])/100,2),2));
												$total3 += round($total + round(($total*$cClass['tax_payment'])/100,2),2);
												?>
											</td>
										</tr>
										<?php
									}
								break;
							}
						}
					}
					?>
					<tr>
						<td style="color:white;background-color:#ABABAB;pading:7px;text-align:left;border-right:1px solid white !important;font-weight:bold;" width="100%" colspan="4">
							<?php echo JText::_('TOTAL');?>
						</td>
					</tr>
					<tr>
						<td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid white !important;font-weight:bold;" width="60%">
							<?php echo JText::_('OS_TOTAL_PRICE');?>
						</td>
						<td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid white !important;font-weight:bold;" width="10%">
							<?php echo OSCHelper::showMoneyWithoutCurrency($total1);?>
						</td>
						<td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid white !important;font-weight:bold;" width="10%">
							<?php echo OSCHelper::showMoneyWithoutCurrency($total2);?>
						</td>
						<td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid white !important;font-weight:bold;" width="10%">
							<?php echo OSCHelper::showMoneyWithoutCurrency($total3);?>
						</td>
					</tr>
				</table>
			</div>
		</div>
		<?php
		$print = $mainframe->input->getInt('print',0);
		if($print == 1){
			?>
			<script language="javascript">
			window.print();
			</script>
			<?php
		}
	}
	/**
	 * Calendar manage
	 *
	 * @param unknown_type $property
	 */
	static function calendarManage($property,$room){
        global $cClass, $mainframe;
		$mainframe = JFactory::getApplication();
		$db = JFactory::getDbo();
		?>
		<style>
		.header_calendar{
			font-weight:bold;
			text-align:center;
			padding:5px;
			font-size:14px;
		}
		.td_calendar_date{
			font-size:13px;
			text-align:center;
			vertical-align:middle;
			border:1px dotted #CCC !important;
			padding:5px;
			font-weight:bold;
		}
		</style>
		<?php
		$title  = OSPHelper::getLanguageFieldValue($property,'pro_name');
        if($cClass['allow_room'] == 1) {
            $title .= " > ";
            $title .= OSPHelper::getLanguageFieldValue($room, 'room_name');
        }
		$title .= " > ";
		$title .= JText::_('OS_PROPERTY_AVAILABILITY_CALENDAR_MANAGE');
		OSPHelper::generateHeading(2,$title);
		?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=default_calendarmanage&pid='.$property->id.'&rid='.$room->id.'&Itemid='.$mainframe->input->getInt('Itemid',0));?>" name="adminForm" id="adminform">
		<div class="row-fluid">
			<div class="span12">
				<div class="btn-group pull-right">
					<span class="btn btn-info">
						<i class="osicon-publish"></i> <?php echo JText::_('OS_PROPERTY_AVAILABILITY_CALENDAR_MANAGE')?>
					</span>
					<a href="<?php echo JRoute::_('index.php?option=com_oscalendar&task=default_availability&pid='.$property->id.'&rid='.$room->id.'&Itemid='.$mainframe->input->getInt('Itemid',0));?>" title="<?php echo JText::_('OS_AVAILABILITY') ?>" class="btn">
						<i class="osicon-calendar"></i> <?php echo JText::_('OS_AVAILABILITY')?>
					</a>
					<button type="button" class="btn hasTooltip" title="<?php echo JText::_('OS_MANAGE_ROOMS');?>" onclick="javascript:location.href='<?php echo JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$property->id.'&Itemid='.$mainframe->input->getInt('Itemid',0))?>'">
	                    <i class="osicon-calendar"></i> 
	                    <?php echo JText::_('OS_MANAGE_ROOMS');?>
	                </button>
				</div>
			</div>
		</div>
		
		<div class="row-fluid">
			<div class="span12">
				<div class="btn-toolbar">
	            	<div class="btn-group">
	            		<span class="btn btn-info">
							<?php
							if ($property->ref != "") echo $property->ref.", ";
							echo OSPHelper::getLanguageFieldValue($property,'pro_name');
							echo " > ";
							echo OSPHelper::getLanguageFieldValue($room,'room_name');
							?>
						</span>
						<a href="javascript:submitftForm('default_available');" title="<?php echo JText::_('OS_CALENDAR_AVAILABLE')?>" class="btn">
							<i class="osicon-publish"></i>
							<?php echo JText::_('OS_CALENDAR_AVAILABLE')?>
						</a>
						<a href="javascript:submitftForm('default_unavailable');" title="<?php echo JText::_('OS_CALENDAR_UNAVAILABLE')?>" class="btn">
							<i class="osicon-unpublish"></i>
							<?php echo JText::_('OS_CALENDAR_UNAVAILABLE')?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span12">
				<?php
				$year = $mainframe->input->getInt('year',date("Y",OSCHelper::getRealTime()));
				$month =  $mainframe->input->getInt('month',date("m",OSCHelper::getRealTime()));
				HelperOsCalendarCalendar::initCalendarInBackend($property->id,$room->id,$year,$month);
				?>
			</div>
		</div>
		<input type="hidden" name="year"  id="year" value="<?php echo $year;?>" />
		<input type="hidden" name="month"  id="month" value="<?php echo $month;?>" />
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="default_calendarmanage" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id?>" />
		<script language="javascript">
		function calendarMoving(pid,rid){
			var ossmh = document.getElementById('ossm');
			var ossyh  = document.getElementById('ossy');
			sm     = ossmh.value;
			sy      = ossyh.value;
			document.getElementById('month').value = sm;
			document.getElementById('year').value = sy;
			document.adminForm.submit();
		}
		function next(pid,rid){
			var month = document.getElementById('month');
			var year  = document.getElementById('year');
			month 	  = month.value;
			year	  = year.value;
			if(month < 12){
				month = parseInt(month) + 1;
			}else{
				year  = parseInt(year) + 1;
				month = 1;
			}
			document.getElementById('month').value = month;
			document.getElementById('year').value = year;
			
			document.adminForm.submit();
		}
		function prev(pid,rid){
			var month = document.getElementById('month');
			var year  = document.getElementById('year');
			month 	  = month.value;
			year	  = year.value;
			if(month > 1){
				month = parseInt(month) - 1;
			}else{
				year  = parseInt(year) - 1;
				month = 12;
			}
			document.getElementById('month').value = month;
			document.getElementById('year').value = year;
			document.adminForm.submit();
		}
		
		function submitftForm(task){
			var form = document.adminForm;
				form.task.value = task;
				form.submit();
		}
		</script>
		</form>
		<?php
	}
	/**
	 * Manage price list
	 *
	 * @param unknown_type $rows
	 * @param unknown_type $property
	 */
	static function managePriceList($rows,$property){
		global $mainframe;
		?>
		<form method="POST" action="<?php echo JURI::root()?>index.php" name="adminForm" id="adminForm"">
		<table  width="100%" style="border-collapse:separate;border:0px !important;">
		<tr>
			<td width="70%" valign="top" align="left" style="padding-top:10px;border:0px;">
				<h2>
					<?php
					echo JText::_('OS_CALENDAR_MANAGE_SPECIAL_PRICE');
					echo " [";
					if ($property->ref != "") echo $property->ref.", ";
					echo $property->pro_name."]";
					?>
				</h2>
			</td>
			<td width="30%" valign="top" align="right" style="padding-top:10px;border:0px;">
				<div id="toolbar-box">
					<div class="m">
						<div class="toolbar-list" id="toolbar">
							<ul>
								<li class="button" id="toolbar-new">
									<a href="javascript:submitftForm('default_addprice');" title="<?php echo JText::_('OS_CALENDAR_ADD_NEW')?>" class="toolbar">
										<span class="osicon-32-new"></span>
										<?php echo JText::_('OS_CALENDAR_ADD_NEW')?>
									</a>
								</li>
								<li class="button" id="toolbar-edit">
									<a href="javascript:submitftForm('default_editprice');" title="<?php echo JText::_('OS_CALENDAR_EDIT')?>" class="toolbar">
										<span class="osicon-32-edit"></span>
										<?php echo JText::_('OS_CALENDAR_EDIT')?>
									</a>
								</li>
								<li class="button" id="toolbar-delete">
									<a href="javascript:submitftForm('default_removeprice');" title="<?php echo JText::_('OS_CALENDAR_DELETE')?>" class="toolbar">
										<span class="osicon-32-delete"></span>
										<?php echo JText::_('OS_CALENDAR_DELETE')?>
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</td>
		</tr>
		<tr>
			<td width="100%" colspan="2" style="padding-top:20px;padding-bottom:20px;">
				<b>
					<a href="index.php?option=com_oscalendar&task=default_editPropertyConfig&pid=<?php echo $property->id?>" title="<?php echo JText::_('OS_MANAGE_SPECIAL_RENTAL_PRICE_FOR_THIS_PROPERTY') ?>">
						<?php echo JText::_('OS_CALENDAR_PROPERTY_RENTAL_CONFIGURATION')?>
					</a>
				</b>
				&nbsp;|&nbsp;
				<b>
					
						<?php echo JText::_('OS_CALENDAR_PROPERTY_PRICE_MANAGE')?>
					
				</b>
				&nbsp;|&nbsp;
				<b>
					<a href="index.php?option=com_oscalendar&task=default_calendarmanage&pid=<?php echo $property->id?>" title="<?php echo JText::_('OS_CALENDAR_MANAGE_AVAILABILITY_CALENDAR_FOR_THIS_PROPERTY') ?>">
						<?php echo JText::_('OS_CALENDAR_PROPERTY_AVAILABILITY_CALENDAR_MANAGE')?>
					</a>
				</b>
			</td>
		</tr>
		<tr>
			<td width="100%" colspan="2">
				<table width="100%" class="adminlist">
					<thead>
						<tr>
							<th width="5%">
							</th>
							<th width="25%">
								<?php echo JText::_('OS_CALENDAR_DATE_FROM')?>
							</th>
							<th width="25%">
								<?php echo JText::_('OS_CALENDAR_DATE_TO')?>
							</th>
							<th width="30%">
								<?php echo JText::_('OS_CALENDAR_PRICE')?>
							</th>
						</tr>
					</thead>
					<tbody>
						<?php
						$k = 0;
						for ($i=0, $n=count($rows); $i < $n; $i++) {
							$row = $rows[$i];
							$checked = JHtml::_('grid.id', $i, $row->id);
							$link = "index.php?option=com_oscalendar&task=default_editpriceX&id=$row->id&pid=".$property->id;
							?>
							<tr class="<?php echo "row$k"; ?>">
								<td align="center"><?php echo $checked; ?></td>
								<td align="left" style="padding-left:20px;">
									<a href="<?php echo $link?>" title="Edit price">
										<?php echo date("D, jS F Y",strtotime($row->start_time));?>
									</a>
								</td>
								<td align="left" style="padding-left:20px;">
									<a href="<?php echo $link?>" title="Edit price">
										<?php echo date("D, jS F Y",strtotime($row->end_time));?>
									</a>
								</td>
								<td align="center">
									<?php echo HelperOspropertyCommon::loadCurrency($property->curr);?> <?php echo HelperOspropertyCommon::showPrice($row->price);?>
								</td>
							</tr>
							<?php
							$k = 1 - $k;	
						}
						?>
					</tbody>
				</table>
			</td>
		</tr>
		</table>
		<input type="hidden" name="option" value="com_oscalendar">
		<input type="hidden" name="task" value="">
		<input type="hidden" name="pid" value="<?php echo $property->id?>">
		<input type="hidden" name="countitem" id="countitem" value="<?php echo count($rows)?>">
		</form>
		<script language="javascript">
		function submitftForm(task){
			var form = document.adminForm;
			if(task == "default_addprice"){
				location.href = "<?php echo JURI::root()?>index.php?option=com_oscalendar&task=default_addprice&pid=<?php echo $property->id?>&Itemid=<?php echo $mainframe->input->getInt('Itemid')?>";
			}else if(task == "default_editprice"){
				if(validateCheckbox() == 0){
					alert("<?php echo JText::_('OS_CALENDAR_PLEASE_AT_LEAST_ONE_TIME') ?>");
				}else{
					form.task.value = task;
					form.submit();
				}
			}else if(task == "default_removeprice"){
				if(validateCheckbox() == 0){
					alert("<?php echo JText::_('OS_CALENDAR_PLEASE_AT_LEAST_ONE_TIME') ?>");
				}else{
					var answer = confirm("<?php echo JText::_('OS_CALENDAR_DO_YOU_WANT_TO_REMOVE_THE_PRICE') ?>");
					if(answer == 1){
						form.task.value = task;
						form.submit();
					}
				}
			}else{
				form.task.value = task;
				form.submit();
			}
			
		}
		
		function validateCheckbox(){
			var countitem = document.getElementById('countitem');
			countitem = countitem.value;
			countitem = parseInt(countitem);
			var returnvalue = 0;
			var eitem = 0;
			for(i=0;i<countitem.value;i++){
				eitem = document.getElementById('cb' + i);
				if(eitem.checked == true){
					returnvalue = 1;
				}
			}
			return returnvalue;
		}
		</script>
		<?php
	}
	
	/**
	 * Show the calendar form
	 *
	 * @param unknown_type $property
	 * @param unknown_type $rooms
	 * @param unknown_type $month
	 * @param unknown_type $year
	 */
	static function calendarForm($property,$rooms,$month,$year,$lists,$price_type){
		global $mainframe,$cClass,$bootstrapHelper;
		$cClass = OSCHelper::getConfiguration();
		//JHtml::_('behavior.calendar');
		if(OSPHelper::isJoomla4())
		{
			OSPHelperJquery::colorbox('osmodal');
		}
		else
		{
			JHTML::_('behavior.modal','a.osmodal');
		}
		$needs = array();
		$needs[] = "property_details";
		$needs[] = $property->id;
		$itemid = OSPRoute::getItemid($needs);
		$rowFluidClass  = $bootstrapHelper->getClassMapping('row-fluid');
		$span12Class	= $bootstrapHelper->getClassMapping('span12');
		$span6Class		= $bootstrapHelper->getClassMapping('span6');
		$span3Class		= $bootstrapHelper->getClassMapping('span3');
		$span9Class		= $bootstrapHelper->getClassMapping('span9');
		$span1Class		= $bootstrapHelper->getClassMapping('span1');
		$span2Class		= $bootstrapHelper->getClassMapping('span2');
		$span4Class		= $bootstrapHelper->getClassMapping('span4');
		$span7Class		= $bootstrapHelper->getClassMapping('span7');
		$span9Class		= $bootstrapHelper->getClassMapping('span9');
		if(($cClass['use_calendar'] == 1) and ($price_type == 1)){
		?>
		<script src="//code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
		<script language="javascript">
		jQuery(function() {
			jQuery( "#book_from" ).datepicker({
				dateFormat: 'yy-mm-dd',
			 	showOn: "button",
			 	buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
			 	buttonImageOnly: true
			 });
		});
		jQuery(function() {
			jQuery( "#book_to" ).datepicker({
				dateFormat: 'yy-mm-dd',
				showOn: "button",
				buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
				buttonImageOnly: true
			});
		});
		jQuery(function() {
			jQuery( "#book_from" ).change(function() {
				var stime = jQuery( "#book_from" ).val();
				jQuery( "#book_to" ).val(stime);
			});
		});
		</script>
		<?php } ?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_osproperty&task=property_details&id='.$property->id.'&Itemid='.$itemid);?>#oscalendardiv" name="appform" id="appform">
		<div class="<?php echo $rowFluidClass; ?>" id="oscalendardiv">
			<div class="<?php echo $span12Class; ?>">
				<div class="tabbable">
					<!--
					<ul class="nav nav-tabs">
						<?php
						if($cClass['enable_reservation'] == 1){
						?>
						<li class="active"><a href="#bookingformtab" data-toggle="tab"><?php echo JText::_('OS_BOOK_THIS_PROPERTY');?></a></li>
						<?php 
							$liactivate = "";
						} else{
							$liactivate = "actve";							
						}?>
						<li class="<?php echo $liactivate;?>"><a href="#availabilitytab" data-toggle="tab"><?php echo JText::_('OS_RATE_AVAILABILITY');?></a></li>
					</ul>
					-->
					<div class="tab-content">
						<?php echo JHtml::_('bootstrap.startTabSet', 'oscalendar', array('active' => 'bookingformtab')); ?>
						<?php
						if($cClass['enable_reservation'] == 1)
						{
							$liactivate = "";
						?>
						<?php echo JHtml::_('bootstrap.addTab', 'oscalendar', 'bookingformtab', JText::_('OS_BOOK_THIS_PROPERTY')); ?>
							<div class="<?php echo $rowFluidClass?>">
								<div class="<?php echo $span12Class;?>">
									<span class="headertextbookingform">
										<?php 
										echo JText::_('OS_CHOOSE_DATE_OF_YOUR_STAY_IN')." ".OSPHelper::getLanguageFieldValue($property,'pro_name');
										?>
									</span>
									<?php
									if($cClass['enable_reservation'] == 1 && count($rooms) > 0)
									{
										//select date form
										?>
										<BR /><BR />
										<div class="<?php echo $rowFluidClass?>">
											<?php 
											if($price_type == 1){
											?>
												<div class="<?php echo $span3Class;?> noleftmargin" style="position:relative;" id="check-in-div-booking_form">
													<?php echo JText::_('OS_FROM')?>:
													<BR />
													<?php
													echo OSCHelper::loadCalendarTag('book_from',$lists['book_from'],'input-small inlinesmall','',JText::_('OS_CHECKIN'),'javascript:updateCalendar();');
													?>
												</div>
												<div class="<?php echo $span3Class;?> noleftmargin" style="position:relative;" id="check-out-div-booking_form">
													<?php echo JText::_('OS_TO')?>:
													<BR />
													<?php
													echo OSCHelper::loadCalendarTag('book_to',$lists['book_to'],'input-small inlinesmall','',JText::_('OS_CHECKOUT'),'');
													?>
												</div>
												<?php } else { //price type = 0: Holiday
												?>
												<div class="<?php echo $span6Class;?> noleftmargin" style="position:relative;">
													<?php echo JText::_('OS_SELECT_PLAN')?>:
													<BR />
													<?php echo $lists['price_list_available'];?>
													<input type="hidden" name="book_from" id="book_from" value="<?php echo $lists['book_from'];?>" />
													<input type="hidden" name="book_to" id="book_to" value="<?php echo $lists['book_to'];?>" />
												</div>
												<?php 
												}?>
												<div class="<?php echo $span1Class;?>">
													<?php echo JText::_('OS_ADULT')?>:
													<BR />
													<?php
														echo $lists['adult'];
													?>
												</div>
												<div class="<?php echo $span1Class;?>">
													<?php echo JText::_('OS_CHILD')?>:
													<BR />
													<?php
														echo $lists['child'];
													?>
												</div>
												<div class="<?php echo $span4Class;?> noleftmargin" style="text-align:center;padding-top:20px;">
													<input type="submit" class="btn btn-info" value="<?php echo JText::_('OS_SEARCH');?>" />
													<input type="reset" class="btn btn-warning" value="<?php echo JText::_('OS_RESET');?>" /> 
												</div>
											</div>
											<?php
											if($lists['err'] == 1){
												?>
												<div class="<?php echo $rowFluidClass?>">
													<div class="<?php echo $span12Class;?>">
														<span class="errmsg">
															<?php echo $lists['msg'];?>
														</span>
													</div>
												</div>
												<?php
											}
											?>
											<div class="<?php echo $rowFluidClass?>">
												<div class="<?php echo $span12Class;?> nomarginleft notification_div" style="float:right;" id="notification_div">
												</div>
											</div>
										<?php 
										}
										?>
										<HR />
									<?php
									for($i=0;$i<count($rooms);$i++)
									{
										$room = $rooms[$i];
										if($price_type == 0)
										{
											$extra_css = "border-bottom:1px solid #CCC;";
										}
										else
										{
											$extra_css = "";
										}
										?>
										<div class="<?php echo $rowFluidClass?>" style="padding-bottom:10px;padding-top:10px;<?php echo $extra_css;?>">
											<?php
											if($cClass['allow_room'] == 1){
											?>
												<div class="<?php echo $span2Class;?>">
													<?php
													if(($room->room_image != "") and (file_exists(JPATH_ROOT.'/images/oscalendar/rooms/thumb/'.$room->room_image))){
														?>
														<a href="<?php echo JUri::root()?>images/oscalendar/rooms/<?php echo $room->room_image?>" class="osmodal">
															<img src="<?php echo JUri::root()?>images/oscalendar/rooms/thumb/<?php echo $room->room_image?>" class="img-polaroid" />
														</a>
														<?php
													}else{
														?>
														<img src="<?php echo JUri::root()?>components/com_osproperty/images/assets/nopropertyphoto.png" class="img-polaroid" width="100"/>
														<?php
													}
													?>
												</div>
											<?php }
											if($cClass['allow_room'] == 1){?>
												<div class="<?php echo $span7Class;?>">
											<?php 
											}else {
											?>
												<div class="<?php echo $span9Class;?>">
											<?php
											}
											?>
											<?php
											if($cClass['allow_room'] == 1) {
												?>
												<span class="room_name"><?php echo OSPHelper::getLanguageFieldValue($room, 'room_name')?>
													&nbsp;&nbsp;<?php echo OSCHelper::generateAdultIcon($room->max_adult);?>
												</span>
												<?php
												if (OSPHelper::getLanguageFieldValue($room, 'room_desc') != "") {
													?>
													<BR/>
													<?php
													echo OSPHelper::getLanguageFieldValue($room, 'room_desc');
													echo "<BR />";
												}
											}else{ 
											?>
												<span class="room_name"><?php echo OSCHelper::generateAdultIcon($room->max_adult);?></span>
												<?php
											}
											if(($price_type == 0) and (count($room->priceplans) >0)){
												$priceplans = $room->priceplans;
												?>
												<BR />
												<strong><?php echo JText::_('OS_AVAILABLE_PRICE_PLANS')?>:</strong>
												<BR />
												<?php
												for($j=0;$j<count($priceplans);$j++){
													$plan = $priceplans[$j];
													$broom =  OSCHelper::maxRoomBookedTypeHoliday($room->id,$plan->price_from,$plan->price_to);
													if($broom < $room->room_number){
													?>
														<?php echo $plan->title?>. <?php echo JText::_('OS_FROM')?> <?php echo date($cClass['date_format'],strtotime($plan->price_from)) ;?> <?php echo JText::_('OS_TO')?> <?php echo date($cClass['date_format'],strtotime($plan->price_to)) ;?>. <?php echo OSPHelper::generatePrice($plan->curr,$plan->price);?>
														<BR />
													<?php
													}
												}
											}
											?>
											</div>
											<div class="<?php echo $span3Class;?>" style="text-align:center;">
												<?php
												if($room->allow_to_book == "0"){
													echo JText::_('OS_PLEASECONTACT');
												}elseif($room->allow_to_book == "1"){
													echo $room->available_list;
												}elseif($room->allow_to_book == ""){
												?>
													<a href="<?php echo JUri::root()?>index.php?option=com_oscalendar&task=ajax_showRoomPrice&pid=<?php echo $property->id?>&tmpl=component&m=<?php echo intval(date("m",time()))?>&y=<?php echo intval(date("Y",time()))?>&rid=<?php echo $room->id?>" title="<?php echo JText::_('OS_CLICK_HERE_TO_SEE_PRICE_OF_THIS_ROOM');?>" class="osmodal" rel="{handler: 'iframe', size: {x: 800, y:550}}">
														<span class="showpricetitle"><?php echo JText::_('OS_SHOW_PRICES');?></span>
													</a>
												<?php
												}
												?>
											</div>
										</div>
										<?php
										if($price_type == 1){
										?>
											<div class="<?php echo $rowFluidClass?>">
												<div class="<?php echo $span12Class;?>" style="padding-bottom:10px;padding-top:10px;border-bottom:1px solid #CCC;">
													<?php
														echo $room->price_table;
													?>
												</div>
											</div>
										<?php
										}
									}
									?>
									<?php
									if(($cClass['enable_reservation'] == 1) and (count($rooms) > 0)){
									//select date form
									?>
										<div class="clearfix"></div>
										<div class="<?php echo $rowFluidClass?>">
											<div class="<?php echo $span9Class;?>" id="summarydiv">
												<input type="hidden" name="rid" id="rid" value="" />
												<input type="hidden" name="price_plan_id" id="price_plan_id" value="" />
												<input type="hidden" name="nroom" id="nroom" value="" />
											</div>
											<div class="<?php echo $span3Class;?> noleftmargin" style="text-align:center;padding:10px;">
												<a href="javascript:addtocart();" class="btn btn-danger a_book_now" id="book_now_button" style="display:none;"><?php echo JText::_('OS_BOOK_NOW')?> !</a>
											</div>
										</div>
									<?php
									}
									?>
								</div>
							</div>
						<?php echo JHtml::_('bootstrap.endTab') ?>
				        <?php }else{
						$liactivate = " active";
						}?>
						<?php echo JHtml::_('bootstrap.addTab', 'oscalendar', 'availabilitytab', JText::_('OS_RATE_AVAILABILITY')); ?>
							<div class="tab-pane<?php echo $liactivate;?>" id="availabilitytab">
								<div class="<?php echo $rowFluidClass?>">
									<div class="<?php echo $span12Class;?>">
										<div class="<?php echo $rowFluidClass?>">
											<div class="<?php echo $span3Class;?> nomarginleft">
												<table>
													<tr>
														<td width="30%" style="background-color:#2D9B35;width:50px;">

														</td>
														<td width="70%" style="padding-left:5px;">
															<?php echo JText::_('OS_FULL_AVAILABLE');?>
														</td>
													</tr>
												</table>
											</div>
											<div class="<?php echo $span3Class;?> nomarginleft">
												<table>
													<tr>
														<td width="30%" style="background-color:#7CC2EA;width:50px;">

														</td>
														<td width="70%" style="padding-left:5px;">
															<?php echo JText::_('OS_AVAILABLE');?>
														</td>
													</tr>
												</table>
											</div>
											<div class="<?php echo $span3Class;?> nomarginleft">
												<table>
													<tr>
														<td width="30%" style="background-color:#C28D25;width:50px;">

														</td>
														<td width="70%" style="padding-left:5px;">
															<?php echo JText::_('OS_UNAVAILABLE');?>
														</td>
													</tr>
												</table>
											</div>
											<div class="<?php echo $span3Class;?> nomarginleft">
												<table>
													<tr>
														<td width="30%" style="background-color:#FF0000;width:50px;">

														</td>
														<td width="70%" style="padding-left:5px;">
															<?php echo JText::_('OS_BOOKED');?>
														</td>
													</tr>
												</table>
											</div>
										</div>
									</div>
									<div class="clearfix"></div>

									<?php
									for($r=0;$r<count($rooms);$r++){
										$room = $rooms[$r];
										?>
										<div class="<?php echo $rowFluidClass;?>" style="padding-bottom:10px;padding-top:10px;border-top:1px solid #CCC;">
											<?php if($cClass['allow_room'] == 1){ ?>
											<div class="<?php echo $span2Class;?>">
												<?php
												if(($room->room_image != "") and (file_exists(JPATH_ROOT.'/images/oscalendar/rooms/thumb/'.$room->room_image))){
													?>
													<a href="<?php echo JUri::root()?>images/oscalendar/rooms/<?php echo $room->room_image?>" class="osmodal">
														<img src="<?php echo JUri::root()?>images/oscalendar/rooms/thumb/<?php echo $room->room_image?>" class="img-polaroid" />
													</a>
													<?php
												}else{
													?>
													<img src="<?php echo JUri::root()?>components/com_osproperty/images/assets/nopropertyphoto.png" class="img-polaroid" width="100"/>
													<?php
												}
												?>
											</div>
											<div class="<?php echo $span9Class;?> noleftmargin">
												<span class="room_name"><?php echo OSPHelper::getLanguageFieldValue($rooms[$r],'room_name');?></span>
												<?php
												if(OSPHelper::getLanguageFieldValue($rooms[$r],'room_desc') != ""){
													?>
													<BR />
													<?php
													echo OSPHelper::getLanguageFieldValue($rooms[$r],'room_desc');
												}
												?>
											</div>
											<?php } ?>
										</div>
										<div class="<?php echo $rowFluidClass;?>">
											<div class="<?php echo $span12Class;?>" id="availability_calendar_div_<?php echo $rooms[$r]->id;?>" style="margin-left:0px;">
												<div class="<?php echo $rowFluidClass;?>">
													<?php
													$k = 0;
													$m = intval($month);
													$y = intval($year);
													for($i=0;$i<4;$i++){
														$k++;
														$m = $month + $i;
														if($m > 12){
															$m = $m - 12;
															$y = $year + 1;
														}
														?>
														<div class="<?php echo $span6Class;?>" style="margin-left:0px;padding-right:10px;padding-bottom:20px;">
															<?php HelperOsCalendarCalendar::initAvailabilityCalendar($property->id,$rooms[$r]->id,$y,$m,'');?>
														</div>
														<?php
														if($k == 2)	{
															?>
															</div><div class="<?php echo $rowFluidClass;?>">
															<?php
															$k = 0;
														}
													}
													?>
												</div>
											</div>
										</div>
									<?php
									}
									?>
								</div>
							</div>
							<?php echo JHtml::_('bootstrap.endTab') ?>
						<?php echo JHtml::_('bootstrap.endTabSet'); ?>
					</div>
				</div>
			</div>
		</div>
		<input type="hidden" name="option" value="com_osproperty" />
		<input type="hidden" name="current_div" id="current_div" value=""  />
		<input type="hidden" name="task" value="property_details" />
		<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::root()?>" />
		<input type="hidden" name="current_date" id="current_date" value="" />
		<input type="hidden" name="use_captcha" id="use_captcha" value="<?php echo $configClass['value_sch_include_captcha'];?>" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id?>" />
		<input type="hidden" name="id" id="id" value="<?php echo $property->id?>" />
		<input type="hidden" name="go" id="go" value="search" />
		<input type="hidden" name="room_id" id="room_id" value="" />
		</form>
		<script type="text/javascript">
		function updateCalendar(){
			var book_from = document.getElementById('book_from');
			var book_to = document.getElementById('book_to');
			if(book_from.value != ""){
				//var live_site = "<?php echo JUri::root();?>";
				//updateCalendarAjax(live_site, book_from.value);
				book_to.value = book_from.value;
			}
		}
		function updateSummary(rid){
			var temp = document.getElementById('room_' + rid);
            document.getElementById('book_now_button').style.display = "block";
			updateSummaryAjax(<?php echo $property->id;?>,rid,temp.value,"<?php echo JURI::root()?>");
		}


		function addtocart(){
			var rid = document.getElementById('rid');
			if(rid.value == ""){
				document.getElementById('notification_div').innerHTML = "<?php echo JText::_('OS_PLEASE_SELECT_ROOM')?>";
				location.hash = "#notification_div";
			}else{
				price_plan_id = document.getElementById('price_plan_id');
				price_plan_id = price_plan_id.value;
				book_from = document.getElementById('book_from');
				book_from = book_from.value;
				book_to = document.getElementById('book_to');
				book_to = book_to.value;
				nroom = document.getElementById('nroom');
				nroom = nroom.value;			
				addtocartAjax("<?php echo $property->id?>",rid.value,nroom,price_plan_id,book_from,book_to,'<?php echo $lists['adults']?>','<?php echo $lists['childs']?>','<?php echo JURI::root()?>');
			}
		}
		
		function loadAvailabilityCalendar(pid,rid,year,month){
			var room_id = document.getElementById('room_id');
			room_id.value = rid;
			ajaxLoadAvailabilityCalendar("<?php echo JURI::root()?>",pid,rid,year,month);
		}

		jQuery("#selected_price").change(function() {
		     var value = jQuery(this).val();
		     var valueArr = value.split("|");
		     var book_from  = valueArr[0];
		     var book_to = valueArr[1];
		     jQuery("#book_from").val(book_from);
		     jQuery("#book_to").val(book_to);
		});
		</script>
		<?php
	}
	
	/**
	 * Booking list
	 *
	 * @param unknown_type $rows
	 */
	static function bookingList($rows,$pageNav,$lists,$book_from,$book_to){
		global $configClass,$cClass,$mainframe;
		$db = JFactory::getDbo();
	if (OSPHelper::isJoomla4()) {
        OSPHelperJquery::colorbox('osmodal');
        JHtml::_('bootstrap.tooltip', '.hasTip');
    } else {
        JHTML::_('behavior.modal', 'a.osmodal');
        JHTML::_('behavior.tooltip');
    }
		if($cClass['use_calendar'] == 1){
		?>
		<script src="//code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
		<script language="javascript">
		jQuery(function() {
			jQuery( "#book_from" ).datepicker({
				dateFormat: 'yy-mm-dd',
			 	showOn: "button",
			 	buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
			 	buttonImageOnly: true
			 });
		});
		jQuery(function() {
			jQuery( "#book_to" ).datepicker({
				dateFormat: 'yy-mm-dd',
				showOn: "button",
				buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
				buttonImageOnly: true
			});
		});
		</script>
		<?php } ?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=default_bookinglist&Itemid='.$mainframe->input->getInt('Itemid',0)); ?>" name="adminForm" id="adminForm">
		<div class="row-fluid">
			<div class="span12">
				<div class="span6">
					<h2>
						<?php
						echo JText::_('OS_CALENDAR_MANAGE_ORDERS');
						?>
					</h2>
				</div>
				<div class="span6">
					<div class="btn-group pull-right" style="padding-top:10px;">
						<a class="btn btn-danger" onclick="if (document.adminForm.boxchecked.value==0){alert('<?php echo JText::_('OS_CALENDAR_SELECT_FIRST');?>');}else{if (confirm('<?php echo JText::_('OS_CALENDAR_REMOVE_ITEM_CONFIRM');?>')){Joomla.submitbutton('default_removebooking');}}" href="#">
							<i class="osicon-remove"></i>
							<?php echo JText::_('OS_CALENDAR_DELETE');?></a>
						<a href="javascript:submitadminForm('default_gotoindex');" title="<?php echo JText::_('OS_CALENDAR_CANCEL')?>" class="btn">
							<i class="osicon-cancel"></i>
							<?php echo JText::_('OS_CALENDAR_CANCEL')?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span12" id="date-list-customer-order">
				<div class="span3 noleftmargin">
				<?php echo JText::_('OS_CALENDAR_PROPERTY_NAME')?>: 
				<BR />
				<?php echo $lists['properties'];?>
				</div>
				
				<div class="span3 noleftmargin">
				<?php echo JText::_('OS_CALENDAR_BOOKING_FROM')?> :
				<BR />
				<?php
            	echo OSCHelper::loadCalendarTag('book_from',$lists['book_from'],'input-small','','','');
            	?>
            	</div>
            	<div class="span3 noleftmargin">
				<?php echo JText::_('OS_CALENDAR_BOOKING_TO')?> : 
				<BR />
				<?php
            	echo OSCHelper::loadCalendarTag('book_to',$lists['book_to'],'input-small','','','');
            	?>
            	</div>
				<div class="span3 noleftmargin">
				<?php echo JText::_('OS_CALENDAR_ORDER_STATUS')?> :
				<BR />
				<?php echo $lists['order_status'] ?>
				</div>
				<div class="clearfix"></div>
				
				<input type="button" value="<?php echo JText::_('OS_RESET');?>" class="btn btn-info"  onclick="javascript:cleartext();" />
				<input type="submit" value="<?php echo JText::_('OS_FILTER');?>" class="btn btn-warning" />
				<BR />
				<span id="result">
					<?php echo JText::_('OS_CALENDAR_RESULT'), '&nbsp;',count($rows);?>
				</span>
			</div>
		</div>
		
		<script type="text/javascript">
			function cleartext(){
				document.getElementById('book_from').value='';
				document.getElementById('book_to').value='';
				document.getElementById('pid').value='0';
			}
			function submitadminForm(task){
				var form = document.adminForm;
				form.task.value = task;
				form.submit();
			}
		</script>	
		<table width="100%">
			<tr>
				<th width="5%" class="td_header">
					<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
				</th>
				<td  class="td_header" width="15%"><?php echo JText::_('OS_CALENDAR_PROPERTY')?>/ <?php echo JText::_('OS_ROOM')?></td>
				<td  class="td_header" width="10%"><?php echo JText::_('OS_CALENDAR_ORDER_DATE')?></td>
				<td  class="td_header" width="20%"><?php echo JText::_('OS_CUSTOMER')?></td>
				<td  class="td_header" width="10%"><?php echo JText::_('OS_CALENDAR_CHECK_IN')?></td>
				<td  class="td_header" width="10%"><?php echo JText::_('OS_CALENDAR_CHECK_OUT')?></td>
				<td  class="td_header" width="5%"><?php echo JText::_('OS_CALENDAR_ORDER_STATUS')?></td>
			</tr>
			<tfoot>
				<tr>
					<td width="100%" colspan="8" style="text-align:center;">
						<?php
							echo $pageNav->getListFooter();
						?>
					</td>
				</tr>
			</tfoot>
			<?php
			$k = 0;
			for($i=0;$i<count($rows);$i++){
				$row = $rows[$i];
				$checked = JHtml::_('grid.id', $i, $row->os_id);
				$link = JURI::root().'index.php?option=com_oscalendar&tmpl=component&task=default_orderDetailsForm&order_id='.$row->os_id;
				
				$db->setQuery("Select image from #__osrs_photos where pro_id = '$row->pid' order by ordering");
				$photo = $db->loadResult();								
				if($photo == ""){
					$row->photo = JURI::root()."components/com_osproperty/images/assets/nopropertyphoto.png";
				}else{
					if(file_exists(JPATH_ROOT."/images/osproperty/properties/".$row->pid."/medium/".$photo)){
						$row->photo = JURI::root()."images/osproperty/properties/".$row->pid."/medium/".$photo;
					}else{
						$row->photo = JURI::root()."components/com_osproperty/images/assets/nopropertyphoto.png";
					}
				}
				if($row->room_image == ""){
					$row->room_image = JURI::root()."components/com_osproperty/images/assets/nopropertyphoto.png";
				}else{
					if(file_exists(JPATH_ROOT."/images/oscalendar/rooms/thumb/".$row->room_image)){
						$row->room_image = JURI::root()."images/oscalendar/rooms/thumb/".$row->room_image;
					}else{
						$row->room_image = JURI::root()."components/com_osproperty/images/assets/nopropertyphoto.png";
					}
				}
				?>
				<tr class="<?php echo "row$k"; ?>">
					<td align="center" class="td_data" style="text-align:center;">
						<?php echo $checked; ?>
					</td>
					<td class="td_data">
						<span class="hasTip" title="&lt;img src=&quot;<?php echo $row->photo;?>&quot; alt=&quot;<?php echo str_replace("'","",$row->pro_name);?>&quot; width=&quot;100&quot; /&gt;"><i class="osicon-camera"></i></span> |
						<a href="<?php echo $link?>" class="osmodal"  rel="{size: {x: 700, y: 500}, handler:'iframe'}">
							<?php if ($row->ref != "") echo $row->ref.", "; ?>
							<?php echo $row->pro_name?>
						</a>
                        <?php if($cClass['allow_room'] == 1){ ?>
						<BR />
						<span class="hasTip" title="&lt;img src=&quot;<?php echo $row->room_image;?>&quot; alt=&quot;<?php echo str_replace("'","",$row->room_name);?>&quot; width=&quot;100&quot; /&gt;"><i class="osicon-camera"></i></span> |
						<a href="<?php echo $link?>" class="osmodal"  rel="{size: {x: 700, y: 500}, handler:'iframe'}">
							<?php echo $row->room_name?>
						</a>
                        <?php } ?>
					</td>
					<td class="td_data">
						<?php echo date($cClass['date_time_format'],strtotime($row->order_date));?>
					</td>
					<td class="td_data">
						<span class="hasTip" title="<?php echo OSCHelper::generateOrderDetailsTip($row->os_id);?>">
							<font style="font-size:11px;">
								<?php echo $row->name ;?>
								<br />
								<?php echo $row->email;?>
								<br />
								<?php echo $row->phone;?>
							</font>
						</span>
					</td>
					<td class="td_data">
						<span class="hasTip" title="<?php echo OSCHelper::generateOrderDetailsTip($row->os_id);?>">
							<?php echo date($cClass['date_format'],strtotime($row->book_from));?>
						</span>
					</td>
					<td class="td_data">
						<span class="hasTip" title="<?php echo OSCHelper::generateOrderDetailsTip($row->os_id);?>">
							<?php echo date($cClass['date_format'],strtotime($row->book_to));?>
						</span>
					</td>
					<td class="td_data"  style="text-align: center;">
						<?php
							
							switch ($row->order_status){
								case "P":
									echo '<span class="label label-warning">'.JText::_('OS_CALENDAR_PENDDING').'</span>';
								break;
								case "C":
									echo '<span class="label label-important">'.JText::_('OS_CALENDAR_CANCEL').'</span>';
								break;
								case "S":
									echo '<span class="label label-success">'.JText::_('OS_CALENDAR_COMPLETED').'</span>';
								break;
							}
						?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;	
			}
			?>
		</table>
		<input type="hidden" name="option" value="com_oscalendar" /> 
		<input type="hidden" name="task" value="default_bookinglist" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="Itemid" value="<?php echo $mainframe->input->getInt('Itemid',0)?>" />
		</form>
		<?php
	}
	
		/**
	 * Edit Extra field
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	static function editHTML($option,$row,$lists,$property){
		?>
		<form method="POST" action="index.php" name="ftForm" id="adminForm">
			<table  width="100%" style="border-collapse:separate;border:0px !important;">
			<tr>
				<td width="70%" valign="top" align="left" style="padding-top:10px;border:0px;">
					<h2>
						<?php
						echo JText::_('OS_CALENDAR_ORDER_DETAILS').": #$row->id";
						?>
					</h2>
				</td>
				<td width="30%" valign="top" align="right" style="padding-top:10px;border:0px;">
					<div id="toolbar" class="toolbar-list" style="float: right; width: 160px;">
						<ul>
							<li id="toolbar-save">
								<a class="toolbar" href="javascript:submitftForm(1);"><span class="osicon-32-save"></span><?php echo JText::_('OS_CALENDAR_SAVE')?></a>
							</li>
							<li id="toolbar-save">
								<a class="toolbar"  href="javascript:submitftForm(0);"><span class="osicon-32-apply"></span><?php echo JText::_('OS_CALENDAR_APPLY')?></a>
							</li>
							<li>
							<a class="toolbar" href="<?php echo JRoute::_('index.php?option=com_oscalendar&task=default_bookinglist')?>"><span class="osicon-32-cancel"></span><?php echo JText::_('OS_CALENDAR_CANCEL')?></a>
							</li>
						</ul>
					</div>
				</td>
			</tr>
			</table>
			<br/>
			<table  width="100%" id="edit_form">
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_PROPERTY_NAME')?> : </td>
					<td><?php if ($property->ref != "") echo $property->ref.", "; ?><?php echo $property->pro_name?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_BOOKING_FROM')?> : </td>
					<td><?php 
						echo date("h:i A, D, jS F Y",strtotime($row->book_from." ".$row->hour_from.":00:00"));
					?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_BOOKING_TO')?> : </td>
					<td><?php 
						echo date("h:i A, D, jS F Y",strtotime($row->book_to." ".$row->hour_to.":00:00"));
					?></td>
				</tr>
				<?php
				if($config->disable_payment == 0){
					?>
					<tr>
						<td class="title_form"><?php echo JText::_('OS_CALENDAR_PAYMENT_METHOD')?> : </td>
							<td>
						<?php
						$payment_name = $row->payment_method;
						if(file_exists(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php")){
							require_once(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php");
							$payment = new $payment_name();
							
						}
						?>
							<?php echo $payment->_name;  ?></td>
						</tr>
				
					
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_AMOUNT')?> : </td>
					<td><?php echo HelperOspropertyCommon::loadCurrency($property->curr);?> <?php echo $row->amount?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_DEPOSIT')?> : </td>
					<td> <?php echo HelperOspropertyCommon::loadCurrency($property->curr);?> <?php echo $row->deposit?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_TAX')?> : </td>
					<td> <?php echo HelperOspropertyCommon::loadCurrency($property->curr);?> <?php echo $row->tax?></td>
				</tr>
				<?php
				}
				?>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_NAME')?> : </td>
					<td><?php echo $row->name?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_EMAIL_ADDRESS')?> : </td>
					<td><?php echo $row->email?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_PHONE')?> : </td>
					<td><?php echo $row->phone?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_ADULTS')?> : </td>
					<td><?php echo $row->nAdults?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_CHILDRENS')?> : </td>
					<td><?php echo $row->nChilds?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_NOTES')?> : </td>
					<td><?php echo $row->notes?></td>
				</tr>
				<tr>
					<td class="title_form"><?php echo JText::_('OS_CALENDAR_ORDER_STATUS')?> : </td>
					<td>
						<?php echo $lists['order_status']?>
					</td>
				</tr>
			</table>	
			<input type="hidden" name="option" value="com_oscalendar">
			<input type="hidden" name="task" value="">
			<input type="hidden" name="id" value="<?php echo $row->id?>">
			<input type="hidden" name="Itemid" value="<?php echo $mainframe->input->getInt('Itemid')?>">
			<?php echo JHTML::_( 'form.token' ); ?>
			<script language="javascript">
				function submitftForm(save) {
					var form = document.ftForm;
					var task = form.task;
					if(save == 1){
						task.value = "default_savebooking";
					}else if(save == 0){
						task.value = "default_applybooking";
					}
					form.submit();
				}
			</script>
		</form>
		<?php 
	}
	
	/**
	 * Show price information table
	 *
	 * @param unknown_type $rows
	 */
	static function showPriceInformationTable($rows){
		global $mainframe,$configClass,$cClass;
		if(count($rows) > 0){
		?>
		<table class="table table-striped">
			<thead>
				<tr>
					<th width="25%" align="center">
						<?php echo JText::_('OS_START_DATE');?>
					</th>
					<th width="25%" align="center">
						<?php echo JText::_('OS_END_DATE');?>
					</th>
					<th width="50%" align="center">
						<?php echo JText::_('OS_PRICE');?>
					</th>
				</tr>
			</thead>
			<tbody>
			<?php
			$k = 0;
			for($i=0;$i<count($rows);$i++){
				$row = $rows[$i];
				?>
				<tr class="row<?php echo $k;?>">
				 	<td align="center">
						<?php echo OSCHelper::showDateFormat($row->start_date,0);?>
					</td>
					<td align="center">
						<?php echo OSCHelper::showDateFormat($row->end_date,0);?>
					</td>
					<td align="center">
						<?php
							echo OSCHelper::showMoney($row->price,0);
						?>
						/<?php echo JText::_('OS_PER')?> <?php echo $row->nights;?> <?php echo JText::_('OS_NIGHTS');?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
		</table>
		<?php
		}else{
			echo "<strong>".Jtext::_('OS_NO_SPECIFIC_PRICE_SETUP')."</strong>";
		}
	}
	
	/**
	 * Show the availability calendar form
	 *
	 * @param unknown_type $property
	 * @param unknown_type $month
	 * @param unknown_type $year
	 */
	static function availabilityCalendar($property,$room,$month,$year){
		global $configClass, $mainframe;
		$title  = OSPHelper::getLanguageFieldValue($property,'pro_name');
		$title .= " > ";
		$title .= OSPHelper::getLanguageFieldValue($room,'room_name');
		$title .= " > ";
		$title .= JText::_('OS_AVAILABILITY');
		OSPHelper::generateHeading(2,$title);
		?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=default_availability&pid='.$property->id.'&rid='.$room->id.'&Itemid='.$mainframe->input->getInt('Itemid',0));?>" name="adminForm">
		<div class="row-fluid">
			<div class="span12">
				<div class="btn-group pull-right">
					<a href="index.php?option=com_oscalendar&task=default_calendarmanage&pid=<?php echo $property->id?>&rid=<?php echo $room->id?>&Itemid=<?php echo $mainframe->input->getInt('Itemid',0);?>" title="<?php echo JText::_('OS_PROPERTY_AVAILABILITY_CALENDAR_MANAGE') ?>" class="btn">
						<i class="osicon-publish"></i> <?php echo JText::_('OS_PROPERTY_AVAILABILITY_CALENDAR_MANAGE')?>
					</a>
					<span class="btn btn-info">
						<i class="osicon-calendar"></i> <?php echo JText::_('OS_AVAILABILITY')?>
					</span>
					<button type="button" class="btn hasTooltip" title="<?php echo JText::_('OS_MANAGE_ROOMS');?>" onclick="javascript:location.href='<?php echo JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$property->id.'&Itemid='.$mainframe->input->getInt('Itemid',0))?>'">
	                    <i class="osicon-calendar"></i> 
	                    <?php echo JText::_('OS_MANAGE_ROOMS');?>
	                </button>
				</div>
			</div>
		</div>
		
		<div class="row-fluid">
			<div class="span12" style="margin-top:15px;">
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#2D9B35;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_FULL_AVAILABLE');?>
							</td>
						</tr>
					</table>
				</div>
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#7CC2EA;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_AVAILABLE');?>
							</td>
						</tr>
					</table>
				</div>
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#C28D25;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_UNAVAILABLE');?>
							</td>
						</tr>
					</table>
				</div>
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#FF0000;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_BOOKED');?>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
		<div class="row-fluid">
			<div class="span12" id="availability_calendar_div_<?php echo $room->id;?>">
				<?php
				$k = 0;
				$m = intval($month);
				$y = intval($year);
				for($i=0;$i<4;$i++){
					$k++;
					$m = $month + $i;
					if($m > 12){
						$m = $m - 12;
						$y = $year + 1;
					}
					?>
					<div class="span6" style="margin-left:0px;padding-right:10px;padding-bottom:20px;">
						<?php HelperOsCalendarCalendar::initAvailabilityCalendar($property->id,$room->id,$y,$m,'');?>
					</div>
					<?php
					if($k == 2)	{
						?>
						<div class="clearfix"></div>
						<?php
						$k = 0;
					}
				}
				?>
			</div>
		</div>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id?>" />
		<input type="hidden" name="room_id" id="room_id" value="<?php echo $room->id?>" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::root()?>" />
		</form>
		<script language="javascript">
		function loadAvailabilityCalendar(pid,rid,year,month){
			ajaxLoadAvailabilityCalendar("<?php echo JURI::root()?>",pid,rid,year,month);
		}
		</script>
		<?php
	}
}
?>