<?php
/*------------------------------------------------------------------------
# customer.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class HTML_OsCalendarCustomer
{
	/**
	 * List Orders
	 *
	 * @param unknown_type $rows
	 * @param unknown_type $pageNav
	 */
	static function listOrders($rows, $pageNav, $lists)
	{
		global $mainframe, $configClass, $cClass;
		$db = JFactory::getDbo();
		// Tooltip behavior - tương thích Joomla 3, 4, 5
		if (version_compare(JVERSION, '4.0', '<')) {
			JHtml::_('behavior.tooltip');
		} else {
			\Joomla\CMS\HTML\HTMLHelper::_('bootstrap.tooltip');
		}
		if ($cClass['use_calendar'] == 1) {
?>
<script src="//code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
<script language="javascript">
jQuery(function() {
    jQuery("#book_from").datepicker({
        dateFormat: 'yy-mm-dd',
        showOn: "button",
        buttonImage: "<?php echo JURI::root() ?>components/com_oscalendar/style/calendar.png",
        buttonImageOnly: true
    });
});
jQuery(function() {
    jQuery("#book_to").datepicker({
        dateFormat: 'yy-mm-dd',
        showOn: "button",
        buttonImage: "<?php echo JURI::root() ?>components/com_oscalendar/style/calendar.png",
        buttonImageOnly: true
    });
});
</script>
<?php } ?>
<form method="POST"
    action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=customer_default&Itemid=' . $mainframe->input->getInt('Itemid', 0)); ?>"
    name="ftForm" id="ftForm">
    <div class="row-fluid">
        <div class="span12">
            <div class="page-header">
                <h2>
                    <?php
							OSPHelper::generateHeading(2, JText::_('OS_LIST_MY_ORDERS'));
							?>
                </h2>
            </div>
            <div id="filter-bar" class="btn-toolbar">
                <div class="btn-group pull-right hidden-phone">
                    <label><?php echo JText::_('OS_ORDERBY') ?>:</label>
                    <?php echo $lists['orderby']; ?>
                </div>
                <div class="btn-group pull-right hidden-phone">
                    <label><?php echo JText::_('OS_SORTBY') ?>:</label>
                    <?php echo $lists['sortby']; ?>
                </div>
            </div>
            <div class="clearfix"> </div>
            <div id="filter-bar" class="btn-toolbar">
                <div class="btn-group pull-left">
                    <label><?php echo JText::_('OS_CALENDAR_ORDER_STATUS') ?>:</label>
                    <?php echo $lists['status']; ?>
                </div>
                <div class="btn-group pull-left" id="checkin-list-customer-order">
                    <label><?php echo JText::_('OS_CALENDAR_CHECK_IN') ?>:</label>
                    <!--<input type="text" readonly value="<?php echo $lists['book_from']; ?>" class="input-small" name="book_from" id="book_from" autocomplete="off" /> -->
                    <?php
							echo OSCHelper::loadCalendarTag('book_from', $lists['book_from'], 'input-small', '', '', '');
							?>
                </div>
                <div class="btn-group pull-left" id="checkout-list-customer-order">
                    <label><?php echo JText::_('OS_CALENDAR_CHECK_OUT') ?>:</label>
                    <?php
							echo OSCHelper::loadCalendarTag('book_to', $lists['book_to'], 'input-small', '', '', '');
							?>
                    <!--<input type="text" readonly value="<?php echo $lists['book_to']; ?>" class="input-small" name="book_to" id="book_to" autocomplete="off" /> -->
                </div>
                <div class="btn-group pull-left" style="margin-top:25px;">
                    <input type="submit" class="btn btn-info" value="<?php echo JText::_('OS_SUBMIT') ?>" />
                    <input type="reset" class="btn btn-warning" value="<?php echo JText::_('OS_RESET') ?>" />
                </div>
            </div>
            <div class="clearfix"></div>
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th width="10%" style="text-align:center;" class="hidden-phone">
                            <?php echo Jtext::_('OS_DATE'); ?>
                        </th>
                        <th width="20%" style="text-align:center;">
                            <?php echo Jtext::_('OS_CALENDAR_PROPERTY'); ?>/ <?php echo Jtext::_('OS_ROOM'); ?>
                        </th>
                        <th width="15%" style="text-align:center;">
                            <?php echo Jtext::_('OS_CALENDAR_BOOKING_TIME'); ?>
                        </th>
                        <th width="10%" style="text-align:center;">
                            <?php echo Jtext::_('OS_CALENDAR_ORDER_STATUS'); ?>
                        </th>
                        <th width="10%" style="text-align:center;" class="hidden-phone">
                            <?php echo Jtext::_('OS_PAYMENT'); ?>
                        </th>
                        <th width="10%" style="text-align:center;" class="hidden-phone">
                            <?php echo Jtext::_('OS_CALENDAR_DEPOSIT'); ?>
                        </th>
                        <th width="10%" style="text-align:center;" class="hidden-phone">
                            <?php echo Jtext::_('OS_TOTAL'); ?>
                        </th>
                        <?php
								if ($cClass['allow_cancel'] == 1) {
								?>
                        <th width="5%" style="text-align:center;" class="hidden-phone">
                            <?php echo Jtext::_('OS_CALENDAR_CANCEL'); ?>
                        </th>
                        <?php } ?>
                        <th width="5%" style="text-align:center;" class="hidden-phone">
                            <?php echo JText::_('OS_PRINT'); ?>
                        </th>
                        <th width="5%" style="text-align:center;" class="hidden-phone">
                            ID
                        </th>
                    </tr>
                </thead>
                <?php
						if (count($rows) > 0) {
						?>
                <tfoot>
                    <tr>
                        <td width="100%" colspan="11" style="text-align:center;padding:5px;">
                            <?php echo $pageNav->getListFooter(); ?>
                        </td>
                    </tr>
                </tfoot>
                <?php } ?>
                <tbody>
                    <?php
							if (count($rows) > 0) {
								$k = 0;
								for ($i = 0; $i < count($rows); $i++) {
									$row = $rows[$i];
									$link = JRoute::_('index.php?option=com_oscalendar&task=default_orderDetailsForm&order_id=' . $row->id);
									$db->setQuery("Select image from #__osrs_photos where pro_id = '$row->pid' order by ordering");
									$photo = $db->loadResult();
									if ($photo == "") {
										$row->photo = JURI::root() . "components/com_osproperty/images/assets/nopropertyphoto.png";
									} else {
										if (file_exists(JPATH_ROOT . "/images/osproperty/properties/" . $row->pid . "/medium/" . $photo)) {
											$row->photo = JURI::root() . "images/osproperty/properties/" . $row->pid . "/medium/" . $photo;
										} else {
											$row->photo = JURI::root() . "components/com_osproperty/images/assets/nopropertyphoto.png";
										}
									}
									if ($row->room_image == "") {
										$row->room_image = JURI::root() . "components/com_osproperty/images/assets/nopropertyphoto.png";
									} else {
										if (file_exists(JPATH_ROOT . "/images/oscalendar/rooms/thumb/" . $row->room_image)) {
											$row->room_image = JURI::root() . "images/oscalendar/rooms/thumb/" . $row->room_image;
										} else {
											$row->room_image = JURI::root() . "components/com_osproperty/images/assets/nopropertyphoto.png";
										}
									}
							?>
                    <tr class="row<?php echo $k; ?>">
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <?php echo date($cClass['date_time_format'], strtotime($row->order_date)); ?>
                        </td>
                        <td style="text-align:left;font-size:11px;">
                            <span class="hasTip"
                                title="&lt;img src=&quot;<?php echo $row->photo; ?>&quot; alt=&quot;<?php echo str_replace("'", "", $row->pro_name); ?>&quot; width=&quot;100&quot; /&gt;"><i
                                    class="osicon-camera"></i></span> |
                            <a href="<?php echo $link ?>">
                                <?php
												if ($row->ref != "") {
													echo $row->ref . ", ";
												}
												echo $row->pro_name;
												?>
                            </a>
                            <br />
                            <span class="hasTip"
                                title="&lt;img src=&quot;<?php echo $row->room_image; ?>&quot; alt=&quot;<?php echo str_replace("'", "", $row->room_name); ?>&quot; width=&quot;100&quot; /&gt;"><i
                                    class="osicon-camera"></i></span> |
                            <a href="<?php echo $link ?>">
                                <?php
												echo $row->room_name;
												?>
                            </a>
                        </td>
                        <td style="text-align:center;font-size:11px;">
                            <?php echo date($cClass['date_format'], strtotime($row->book_from)); ?>
                            -
                            <?php echo date($cClass['date_format'], strtotime($row->book_to)); ?>
                        </td>
                        <td style="text-align:center;font-size:11px;">
                            <?php
											switch ($row->order_status) {
												case "P":
											?>
                            <span class="label label-warning"><?php echo JText::_('OS_CALENDAR_PENDDING'); ?></span>
                            <?php
													break;
												case "C":
												?>
                            <span class="label label-important"><?php echo JText::_('OS_CALENDAR_CANCEL'); ?></span>
                            <?php
													break;
												case "S":
												?>
                            <span class="label label-success"><?php echo JText::_('OS_CALENDAR_COMPLETE'); ?></span>
                            <?php
													break;
											}
											?>
                        </td>
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <?php
											$db->setQuery("Select title from #__oscalendar_plugins where name like '$row->payment_method'");
											echo $db->loadResult();
											?>
                        </td>
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <?php
											//echo OSCHelper::showMoneyInOrder($row->deposit,$row->id);
											echo OSPHelper::generatePrice($row->curr, $row->deposit);
											?>
                        </td>
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <?php
											//echo OSCHelper::showMoneyInOrder($row->total,$row->id);
											echo OSPHelper::generatePrice($row->curr, $row->total_amount);
											?>
                        </td>
                        <?php
										if ($cClass['allow_cancel'] == 1) {
										?>
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <?php
												$allow_cancel_before = $cClass['allow_cancel_before'];
												$current_date = time();
												$check_in_int = strtotime($row->book_from);
												if ($current_date - $allow_cancel_before * 24 * 3600 > $check_in_int) {
												?>
                            <span class="btn disabled">
                                <i class="osicon-unpublish disabled"></i>
                            </span>
                            <?php
												} else {
													if ($row->order_status != "C") {
													?>
                            <a href="javascript:cancelOrder(<?php echo $row->id ?>);" class="btn btn-info"><i
                                    class="osicon-unpublish"></i></a>
                            <?php
													} else {
													?>
                            <span class="btn disabled">
                                <i class="osicon-unpublish"></i>
                            </span>
                            <?php
													}
												}
												?>
                        </td>
                        <?php
										}
										?>
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <a href="<?php echo JURI::root() ?>index.php?option=com_oscalendar&task=default_orderDetailsForm&order_id=<?php echo $row->id ?>&tmpl=component&print=1"
                                class="btn btn-danger" target="_blank"><i class="osicon-print"></i></a>
                        </td>
                        <td style="text-align:center;font-size:11px;" class="hidden-phone">
                            <?php
											echo $row->id;
											?>
                        </td>
                    </tr>
                    <?php
									$k = 1 - $k;
								}
							} else {
								?>
                    <tr>
                        <td width="100%" colspan="10" style="text-align:center;padding:5px;">
                            <?php echo JText::_('OS_NO_ORDER_FOUND'); ?>
                        </td>
                    </tr>
                    <?php
							}
							?>
                </tbody>
            </table>
        </div>
    </div>
    <input type="hidden" name="option" value="com_oscalendar" />
    <input type="hidden" name="task" value="customer_default" />
</form>
<script language="javascript">
function cancelOrder(id) {
    var answer = confirm("<?php echo JText::_('OS_ARE_YOU_SURE_YOU_WANT_TO_REMOVE_ORDER') ?>");
    if (answer == 1) {
        location =
            "<?php echo JURI::root() ?>index.php?option=com_oscalendar&task=default_cancelorder&redirect=1&order_id=" +
            id;
    }
}
</script>
<?php
	}
}
?>