<?php
/*------------------------------------------------------------------------
# booking.html.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class HTML_OsCalendarForm{
	/**
	 * Confirm information form
	 *
	 * @param unknown_type $option
	 * @param unknown_type $total
	 * @param unknown_type $fieldObj
	 * @param unknown_type $lists
	 */
	static function confirmInforFormHTML($order_temp_id,$lists,$property,$room,$fields,$profile){
		global $mainframe,$root_link,$configClass,$cClass;
		$methods = os_payments::getPaymentMethods(true, false) ;
		HTML_OsCalendarForm::showConfirmFormHTML($order_temp_id,$lists,$property,$room,$fields,$profile);
		?>
		<input type="hidden" name="option" value="com_oscalendar" /> 
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="live_site" id="live_site" value="<?php echo $root_link?>"  />
		<input type="hidden" name="order_id" id="order_id" value="" />
		<input type="hidden" name="current_date" id="current_date" value=""  />
		<input type="hidden" name="use_captcha" id="use_captcha" value="<?php echo $configClass['use_captcha'];?>" />
		<input type="hidden" name="coupon_id" id="coupon_id" value="" />
		<input type="hidden" name="current_link" id="current_link" value="<?php echo $configClass['current_link']?>" />
		
		<div  id="divtemp" style="width:1px;height:1px;"></div>
		<script language="javascript">
		<?php
			os_payments::writeJavascriptObjects();
		?>
		</script>
		<?php
	}
	
	/**
	 * Show confirmation form
	 *
	 * @param unknown_type $option
	 * @param unknown_type $total
	 * @param unknown_type $fieldObj
	 * @param unknown_type $lists
	 * @param unknown_type $coupon
	 */
	static function showConfirmFormHTML($order_temp_id,$lists,$property,$room,$fields,$profile){
		global $mainframe,$root_link,$configClass,$cClass;
		$user = JFactory::getUser();
		$methods = $lists['methods'];
		$db = JFactory::getDbo();
		?>
		<?php
		if($configClass['use_ssl'] == 1){
		?>
		<form method="POST" action="<?php echo $cClass['root_link'].'index.php?option=com_oscalendar&task=default_completeorder&Itemid='.$mainframe->input->getInt('Itemid',0);?>" name="appform" id="bookingForm">
		<?php
		}else{
		?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=default_completeorder&Itemid='.$mainframe->input->getInt('Itemid',0));?>" name="appform" id="bookingForm">
		<?php
		}
		?>
		<div class="row-fluid bookingformdiv">
			<div class="span12">
				<?php
				OSPHelper::generateHeading(2,JText::_('OS_CONFIRM'));
				?>
			</div>
			<div class="span12 btn btn-info noleftmargin">
				<?php
				if($property->ref != ""){
					echo $property->ref.", ";
				}
				echo OSPHelper::getLanguageFieldValue($property,'pro_name');
				?>
			</div>
			<div class="row-fluid">
				<div class="span12" style="padding-top:10px;padding-bottom:10px;">
					<div class="span3">
						<?php
						if($property->image != ""){
							if(file_exists(JPATH_ROOT."/images/osproperty/properties/".$property->id."/medium/".$property->image)){
								?>
								<img src="<?php echo $root_link."images/osproperty/properties/".$property->id."/medium/".$property->image?>" class="img-polaroid">
								<?php
							}else{
								?>
								<img src="<?php echo $root_link."/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>" class="img-polaroid">
								<?php
							}
						}else{
							?>
							<img src="<?php echo $root_link."/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>" class="img-polaroid">
							<?php
						}
						?>
					</div>
					<div class="span9">
						<div class="span12">
							<?php
							if($property->show_address == 1){
								?>
								<div class="span12 nomarginleft">
									<div class="span3">
										<strong><?php echo JText::_('OS_LOCATION')?>:</strong>
									</div>
									<div class="span9">
										<?php echo OSPHelper::generateAddress($property);?>
									</div>
									</div>
								<div class="clearfix"></div>
								
								<?php
							}
							?>
							<?php
							echo OSPHelper::getLanguageFieldValue($property,'pro_small_desc');
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="span12 btn btn-info noleftmargin">
				<?php
				echo OSPHelper::getLanguageFieldValue($room,'room_name');
				?>
			</div>
			<div class="row-fluid">
				<div class="span12" style="padding-top:10px;padding-bottom:10px;">
                    <?php if($cClass['allow_room'] == 1){ ?>
					<div class="span3">
						<?php
						if($room->room_image != ""){
							if(file_exists(JPATH_ROOT."/images/oscalendar/rooms/thumb/".$room->room_image)){
								?>
								<img src="<?php echo $root_link."/images/oscalendar/rooms/thumb/".$room->room_image;?>" class="img-polaroid">
								<?php
							}else{
								?>
								<img src="<?php echo $root_link."/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>" class="img-polaroid">
								<?php
							}
						}else{
							?>
							<img src="<?php echo $root_link."/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>" class="img-polaroid">
							<?php
						}
						?>
					</div>
					<div class="span9">
						<div class="span12">
                            <?php } ?>
							<div class="span3" style="margin-left:0px;">
								<strong><?php echo JText::_('OS_CALENDAR_CHECK_IN')?>:</strong>
							</div>
							<div class="span9">
                                <?php echo date($cClass['date_format'],strtotime($lists['date_from']));?>
							</div>
							<div class="clearfix"></div>
							<div class="span3" style="margin-left:0px;">
								<strong><?php echo JText::_('OS_CALENDAR_CHECK_OUT')?>:</strong>
							</div>
							<div class="span9">
                                <?php echo date($cClass['date_format'],strtotime($lists['date_to']));?>
							</div>
                            <?php if($cClass['allow_room'] == 1) { ?>
                                <div class="clearfix"></div>
                                <div class="span3" style="margin-left:0px;">
                                    <strong><?php echo JText::_('OS_NUMBER_ROOMS') ?>:</strong>
                                </div>
                                <div class="span9">
                                    <?php echo $lists['nroom']; ?>
                                </div>
                            <?php
                            }
							if($lists['adult'] > 0){
								?>
								<div class="clearfix"></div>
								<div class="span3" style="margin-left:0px;">
									<strong><?php echo JText::_('OS_ADULT')?>:</strong>
								</div>
								<div class="span9">
									<?php echo $lists['adult'];?>
								</div>
								<?php
							}
							?>
							<?php
							if($lists['child'] > 0){
								?>
								<div class="clearfix"></div>
								<div class="span3" style="margin-left:0px;">
									<strong><?php echo JText::_('OS_CHILD')?>:</strong>
								</div>
								<div class="span9">
									<?php echo $lists['child'];?>
								</div>
								<?php
							}
							?>
                            <?php if($cClass['allow_room'] == 1){ ?>
						</div>
					</div>
                    <?php } ?>
				</div>
			</div>
			<div class="clearfix"></div>
			<div class="row-fluid bookingformdiv">
				<div class="span12 btn btn-info">
					<?php echo JText::_('OS_BOOKING_INFORMATION')?>
				</div>
				
				<div class="row-fluid" style="margin-left:0px;">
					<div class="span12" style="padding-top:15px;">
						<div class="row-fluid">
							<div class="span12 checkout_details_div">
								<strong>
									<?php echo strtoupper(JText::_('OS_CUSTOMER_INFORMATION'));?>
								</strong>
								<BR /><BR />
								<div class="span3 boldtext"  style="margin-left:0px;">
									<?php echo JText::_('OS_NAME')?>
								</div>
								<div class="span8">
									<?php echo $mainframe->input->getString('name','');?>
								</div>
								<div class="clearfix"></div>
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_EMAIL')?>
								</div>
								<div class="span8">
									<?php echo $mainframe->input->getString('email','');?>
								</div>
								
								
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_PHONE')?>
								</div>
								<div class="span8">
									<?php echo $mainframe->input->getString('phone','');?>
								</div>
								<div class="clearfix"></div>
							
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_COUNTRY')?>
								</div>
								<div class="span8">
									<?php echo $mainframe->input->getString('country','');?>
								</div>
								<div class="clearfix"></div>
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_NOTES')?>
								</div>
								<div class="span8">
									<?php echo $mainframe->input->getString('notes','');?>
								</div>
								<div class="clearfix"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <?php
            if(count($fields)){
            ?>
			<div class="row-fluid">
				<div class="span12 btn btn-info">
					<strong>
						<?php echo strtoupper(JText::_('OS_ADDITIONAL_REQUEST'));?>
					</strong>
				</div>
				<div class="span12 noleftmargin">
					<?php
					$fieldArr = array();
					for($i=0;$i<count($fields);$i++){
						$field = $fields[$i];
						$fieldtype = $field->field_type;
						$fieldvalue = HelperOScalendarExtrafields::getFormFieldSubmitted($field);
						if($fieldvalue != ""){
						?>
							<div class="span3 boldtext"  style="margin-left:0px;">
								<?php echo OSPHelper::getLanguageFieldValue($field,'field_label');?>
							</div>
							<div class="span8">
								<?php
								echo $fieldvalue;
								?>
							</div>
							<div class="clearfix"></div>
						<?php
						}
					}
					?>
					<input type="hidden" name="field_ids" id="field_ids" value="<?php echo implode(",",$fieldArr)?>"  />
					<input type="hidden" name="field_values" id="field_values" value=""  />
				</div>
			</div>
            <?php } ?>
			<div class="row-fluid">
				<div class="span12 btn btn-info noleftmargin">
					<?php
					echo JText::_('OS_SUMMARY');
					?>
				</div>
				<div class="span12 checkout_details_div noleftmargin" style="margin-top:10px;padding-bottom:10px;" id="summary_div_oscalendar">
					<?php
					OsCalendarAjax::generateSummary($order_temp_id);
					?>
				</div>
			</div>
			
			<div class="row-fluid">
				<div class="span12 checkout_details_div">
					<strong>
						<?php echo strtoupper(JText::_('OS_PAYMENT'));?>
					</strong>
					<BR /><BR />	
					<?php
					
						$method = $lists['method'];
						?>
						<div class="span3 boldtext" style="margin-left:0px;">
							<?php echo JText::_('OS_SELECT_PAYMENT')?>
						</div>
						<div class="span8">
							<?php echo  JText::_(os_payments::loadPaymentMethod($lists['select_payment'])->title); ?>
						</div>
						<div class="clearfix"></div>
						<?php
						$method = $lists['method'] ;
						if($lists['select_payment'] != ""){
							if ($method->getCreditCard()) {
							?>	
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo  JText::_('OS_AUTH_CARD_NUMBER'); ?>
								</div>
								<div class="span8">
									<?php
										$len = strlen($lists['x_card_num']) ;
										$remaining =  substr($lists['x_card_num'], $len - 4 , 4) ;
										echo str_pad($remaining, $len, '*', STR_PAD_LEFT) ;
									?>												
								</div>
								<div class="clearfix"></div>
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_AUTH_CARD_EXPIRY_DATE'); ?>
								</div>
								<div class="span8">						
									<?php echo $lists['exp_month'] .'/'.$lists['exp_year'] ; ?>
								</div>
								<div class="clearfix"></div>
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_AUTH_CVV_CODE'); ?>
								</div>
								<div class="span8">
									<?php echo $lists['x_card_code'] ; ?>
								</div>
								<div class="clearfix"></div>
								<?php
									if ($method->getCardType()){
									?>
										<div class="span3 boldtext" style="margin-left:0px;">
											<?php echo JText::_('OS_CARD_TYPE'); ?>
										</div>
										<div class="span8">
											<?php echo $lists['card_type'] ; ?>
										</div>
									<div class="clearfix"></div>
									<?php	
									}
								?>
							<?php				
							}						
							if ($method->getCardHolderName()) {
							?>
								<div class="span3 boldtext" style="margin-left:0px;">
									<?php echo JText::_('OS_CARD_HOLDER_NAME'); ?>
								</div>
									<div class="span8">
									<?php echo $lists['card_holder_name'];?>
								</div>
								<div class="clearfix"></div>
							<?php												
							}
						}
						?>
				</div>
			</div>
			<div class="row-fluid">
				<div class="span12 checkout_details_div" style="text-align:center;">
					<input type="submit" class="btn btn-success" value="<?php echo JText::_('OS_SUBMIT')?>"/>
					<input type="button" class="btn btn-warning" value="<?php echo JText::_('OS_BACK')?>" onclick="javascript:window.history.go(-1);"/>
				</div>
			</div>
		</div>
		
		<!-- hidden tags -->
		<input type="hidden" name="name" 		id="name" 		value="<?php echo $mainframe->input->getString('name')?>"   />
		<input type="hidden" name="email" 		id="email" 		value="<?php echo $mainframe->input->getString('email')?>" />
		<input type="hidden" name="phone" 		id="phone" 		value="<?php echo $mainframe->input->getString('phone')?>" />
		<input type="hidden" name="country" 	id="country" 	value="<?php echo $mainframe->input->getString('country')?>" />
		<input type="hidden" name="select_payment" id="select_payment" value="<?php echo $mainframe->input->getString('payment_method')?>" />
		<input type="hidden" name="x_card_num" 	id="x_card_num" value="<?php echo $lists['x_card_num']?>" />
		<input type="hidden" name="x_card_code" id="x_card_code" value="<?php echo $lists['x_card_code']?>"  />
		<input type="hidden" name="card_holder_name" id="card_holder_name" 	value="<?php echo $lists['card_holder_name']?>" />
		<input type="hidden" name="exp_year" 	id="exp_year" 	value="<?php echo $lists['exp_year']?>" />
		<input type="hidden" name="exp_month" 	id="exp_month" 	value="<?php echo $lists['exp_month']?>" />
		<input type="hidden" name="card_type" 	id="card_type" 	value="<?php echo $lists['card_type']?>" />
		<input type="hidden" name="bank_id" 	id="bank_id" 	value="<?php echo $mainframe->input->getString('bank_id');?>" />
		<input type="hidden" name="coupon_id"	id="coupon_id" 	value="<?php echo $coupon->id?>" />
		<input type="hidden" name="date_from"	id="date_from"  value="<?php echo $lists['date_from'];?>" />
		<input type="hidden" name="date_to"		id="date_to"  	value="<?php echo $lists['date_to'];?>" />
		<input type="hidden" name="nNights"		id="nNights"  	value="<?php echo $lists['nNights'];?>" />
		<input type="hidden" name="pid"			id="pid"  		value="<?php echo $property->id;?>" />
		<input type="hidden" name="nadult"		id="nadult"  	value="<?php echo $lists['nadult'];?>" />
		<input type="hidden" name="nchild"		id="nchild"  	value="<?php echo $lists['nchild'];?>" />
		<div style="display:none;">
			<textarea name="notes" id="notes" cols="40" rows="4" class="inputbox"><?php echo $mainframe->input->getString('notes');?></textarea>
		</div>
		<?php
		if($lists['select_payment'] == "os_stripe"){
			?>
			<script type="text/javascript">

			jQuery(document).ready(function(){
				Stripe.card.createToken({
				  number: jQuery('#x_card_num').val(),
				  cvc: jQuery('#x_card_code').val(),
				  exp_month: jQuery('#exp_month').val(),
				  exp_year: jQuery('#exp_year').val(),
				  name: jQuery('#card_holder_name').val()
				 }, stripeResponseHandler);
			});
			function stripeResponseHandler(status, response) {
				var $form = jQuery('#bookingForm');
				if (response.error) {
					// Show the errors on the form
					//$form.find('.payment-errors').text(response.error.message);
					alert(response.error.message);
					//$form.find('#btn-submit').prop('disabled', false);
				} else {
					// token contains id, last4, and card type
					var token = response.id;
					// Empty card data since we now have token
					jQuery('input[name^=x_card_num]').val('');
					jQuery('input[name^=x_card_code]').val('');
					jQuery('input[name^=card_holder_name]').val('');
					// Insert the token into the form so it gets submitted to the server
					$form.append(jQuery('<input type="hidden" name="stripeToken" />').val(token));
					// and re-submit
					//$form.get(0).submit();
				}
			};
			</script>
			<?php
		}
		?>
		<?php
		if(count((array)$fieldObj) > 0){
			for($i=0;$i<count($fieldObj);$i++){
				$f = $fieldObj[$i];
				switch ($f->field_type){
					case "0":
						?>
						<input type="hidden" name="field_<?php echo $f->id?>" id="field_<?php echo $f->id?>" value="<?php echo $mainframe->input->getString('field_'.$f->id);?>">
						<?php
					break;
					case "1":
						?>
						<div style="display:none;">
						<textarea name="field_<?php echo $f->id?>"><?php echo $mainframe->input->getString('field_'.$f->id);?></textarea>
						</div>
						<?php
					break;
					case "2":
						?>
						<input type="hidden" name="field_<?php echo $f->id?>" id="field_<?php echo $f->id?>" value="<?php echo $mainframe->input->getString('field_'.$f->id);?>">
						<?php
					break;
					case "3":
						$fieldvalue = $mainframe->input->getString('field_'.$f->id);
						?>
						<input type="hidden" name="field_<?php echo $f->id?>" id="field_<?php echo $f->id?>" value="<?php echo implode(",",$fieldvalue);?>">
						<?php
					break;
				}
				
			}
		}
		?>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="default_completeorder" />
		<input type="hidden" name="Itemid" value="<?php echo $mainframe->input->getInt('Itemid')?>"  />
		<input type="hidden" name="order_temp_id" id="order_temp_id" value="<?php echo $order_temp_id?>" />
		</form>
		<?php
	}
	
	
	/**
	 * Check-Out form
	 *
	 * @param unknown_type $option
	 * @param unknown_type $lists
	 * @param unknown_type $property
	 * @param unknown_type $fields
	 * @param unknown_type $profile
	 */
	static function checkoutLayout($order_temp_id,$lists,$property,$room,$fields,$profile){
		global $mainframe,$root_link,$configClass;
		//jimport('joomla.html.pane');
		//$pane =& JPane::getInstance('tabs');
		$methods = os_payments::getPaymentMethods(true, false) ;
		HTML_OsCalendarForm::showInforFormHTML($order_temp_id,$lists,$property,$room,$fields,$profile);
		?>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="live_site" id="live_site" value="<?php echo $root_link?>"  />
		
		<div  id="divtemp" style="width:1px;height:1px;"></div>
		<script language="javascript">
		<?php
			os_payments::writeJavascriptObjects();
		?>
		function checkCoupon(){
			var coupon_code = document.getElementById('coupon_code');
			if(coupon_code.value == ""){
				alert("<?php echo JText::_('OS_PLEASE_ENTER_COUPON_CODE');?>");
			}else{
				checkCouponCodeAjax(coupon_code.value,"<?php echo $root_link;?>");
			}
		}
		function validateEmail(form_id,email) {
		   var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
		   //var address = document.forms[form_id].elements[email].value;
		   var address = document.getElementById(email).value;
		   if(reg.test(address) == false) {
		      return false;
		   }
		   return true;
		}
		
		function updateSummarySelectField(fieldid){
			var temp = document.getElementById(fieldid);
			updateSummarySelectFieldAjax(<?php echo $order_temp_id?>,fieldid,temp.value,"<?php echo $root_link?>");
		}
		
		function updateSummaryCheckboxField(fieldid,optionid){
			var temp = document.getElementById(fieldid + "_" + optionid);
			var checkvar = temp.checked;
			if(checkvar == true){
				check = 1;
			}else{
				check = 0;
			}
			updateSummaryCheckboxFieldAjax(<?php echo $order_temp_id?>,fieldid,optionid,temp.value,"<?php echo $root_link?>",check);
		}
		</script>
		<?php
	}
	
	/**
	 * Show Checkout form - Step1
	 *
	 * @param unknown_type $option
	 * @param unknown_type $lists
	 * @param unknown_type $fields
	 */
	static function showInforFormHTML($order_temp_id,$lists,$property,$room,$fields,$profile){
		global $mainframe,$root_link,$configClass,$cClass,$bootstrapHelper;
		if(OSPHelper::isJoomla4())
		{
			OSPHelperJquery::colorbox('osmodal');
		}
		else
		{
			JHTML::_("behavior.modal","osmodal");
		}
		$user  = JFactory::getUser();
		$name = "";
		$email = "";
		$show_booking_form = 1;
		if($user->id > 0){
			$name  = ($profile->order_name != "" ? $profile->order_name : $user->name);
			$email = ($profile->order_email != "" ? $profile->order_email : $user->email);
		}else{
			//check the option "allow_regitered_only"
			if($cClass['only_register_can_book'] == 1){
				$show_booking_form = 0;
			}
		}
		$methods = $lists['methods'];
		$rowFluidClass  = $bootstrapHelper->getClassMapping('row-fluid');
		$span12Class	= $bootstrapHelper->getClassMapping('span12');
		$span6Class		= $bootstrapHelper->getClassMapping('span6');
		$span3Class		= $bootstrapHelper->getClassMapping('span3');
		$span9Class		= $bootstrapHelper->getClassMapping('span9');
		$span1Class		= $bootstrapHelper->getClassMapping('span1');
		$span2Class		= $bootstrapHelper->getClassMapping('span2');
		$span4Class		= $bootstrapHelper->getClassMapping('span4');
		$span7Class		= $bootstrapHelper->getClassMapping('span7');
		$span8Class		= $bootstrapHelper->getClassMapping('span8');

		?>
		<div class="<?php echo $rowFluidClass;?>">
			<div class="<?php echo $span12Class;?>">
				<?php
				OSPHelper::generateHeading(2,JText::_('OS_CHECKOUT'));
				?>
			</div>
		</div>
		<div class="<?php echo $rowFluidClass;?>">
			<div class="<?php echo $span12Class;?> btn btn-info noleftmargin">
				<?php
				if($property->ref != ""){
					echo $property->ref.", ";
				}
				echo OSPHelper::getLanguageFieldValue($property,'pro_name');
				?>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span3Class;?>">
					<?php
					if($property->image != ""){
						if(file_exists(JPATH_ROOT."/images/osproperty/properties/".$property->id."/medium/".$property->image)){
							?>
							<img src="<?php echo $root_link."images/osproperty/properties/".$property->id."/medium/".$property->image?>" class="img-polaroid">
							<?php
						}else{
							?>
							<img src="<?php echo $root_link."/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>" class="img-polaroid">
							<?php
						}
					}else{
						?>
						<img src="<?php echo $root_link."/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>" class="img-polaroid">
						<?php
					}
					?>
				</div>
				<div class="<?php echo $span9Class;?>">
					<div class="<?php echo $rowFluidClass;?>">
						<div class="<?php echo $span12Class;?>">
							<?php
							if($property->show_address == 1){
								?>
								<div class="<?php echo $rowFluidClass;?>">
									<div class="<?php echo $span3Class;?>">
										<strong><?php echo JText::_('OS_LOCATION')?>:</strong>
									</div>
									<div class="<?php echo $span9Class;?>">
										<?php echo OSPHelper::generateAddress($property);?>
									</div>
								</div>
								<?php
							}
							?>
							<?php
							echo OSPHelper::getLanguageFieldValue($property,'pro_small_desc');
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span12Class;?> btn btn-info noleftmargin">
					<?php
					echo OSPHelper::getLanguageFieldValue($room,'room_name');
					?>
				</div>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<?php
				if($cClass['allow_room'] == 1){
				?>
					<div class="<?php echo $span3Class;?>">
						<?php
						if ($room->room_image != "") {
							if (file_exists(JPATH_ROOT . "/images/oscalendar/rooms/thumb/" . $room->room_image)) {
								?>
								<img
									src="<?php echo $root_link . "/images/oscalendar/rooms/thumb/" . $room->room_image;?>"
									class="img-polaroid" />
							<?php
							} else {
								?>
								<img
									src="<?php echo $root_link . "/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>"
									class="img-polaroid" />
							<?php
							}
						} else {
							?>
							<img
								src="<?php echo $root_link . "/components/com_osproperty/images/assets/nopropertyphoto.png"; ?>"
								class="img-polaroid" />
						<?php
						}
						?>
					</div>
			
					<div class="<?php echo $span9Class;?>">
						
					<?php
					}
					?>
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span3Class;?>">
								<strong><?php echo JText::_('OS_CALENDAR_CHECK_IN')?>:</strong>
							</div>
							<div class="<?php echo $span9Class;?>">
								<?php echo date($cClass['date_format'],strtotime($lists['date_from']));?>
							</div>
						</div>
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span3Class;?>">
								<strong><?php echo JText::_('OS_CALENDAR_CHECK_OUT')?>:</strong>
							</div>
							<div class="<?php echo $span9Class;?>">
								<?php echo date($cClass['date_format'],strtotime($lists['date_to']));?>
							</div>
						</div>
						<?php if($cClass['allow_room'] == 1) { ?>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?>">
									<strong><?php echo JText::_('OS_NUMBER_ROOMS') ?>:</strong>
								</div>
								<div class="<?php echo $span9Class;?>">
									<?php echo $lists['nroom']; ?>
								</div>
							</div>
						<?php
						}
						if($lists['adult'] > 0){
							?>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?>">
									<strong><?php echo JText::_('OS_ADULT')?>:</strong>
								</div>
								<div class="<?php echo $span9Class;?>">
									<?php echo $lists['adult'];?>
								</div>
							</div>
							<?php
						}
						?>
						<?php
						if($lists['child'] > 0){
							?>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?>">
									<strong><?php echo JText::_('OS_CHILD')?>:</strong>
								</div>
								<div class="<?php echo $span9Class;?>">
									<?php echo $lists['child'];?>
								</div>
							</div>
							<?php
						}
						?>
						<?php
						if($cClass['allow_room'] == 1){
						?>
					</div>
				<?php } ?>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span12Class;?> btn btn-info" style="margin-left:0px;">
					<?php echo JText::_('OS_BOOKING_FORM')?>
				</div>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span12Class;?>" style="padding-top:15px;">
					<?php
					if($user->id == 0){ //show login form and registration form
						if($cClass['only_register_can_book'] == 1){
							$actionUrl = JRoute::_('index.php?option=com_users&task=user.login');	
							
							if($cClass['use_ssl'] == 1){
								$returnUrl = JRoute::_($cClass['root_link'].'index.php?option=com_oscalendar&task=form_step1&uid='.$mainframe->input->getString('uid','').'&Itemid='.$mainframe->input->getInt('Itemid',0));
							}else{
								$returnUrl = JRoute::_('index.php?option=com_oscalendar&task=form_step1&uid='.$mainframe->input->getString('uid','').'&Itemid='.$mainframe->input->getInt('Itemid',0));	
							}
						?>
						<!-- Login form-->
						<form id="osbloginForm" name="osbloginForm" method="POST" action="<?php echo $actionUrl;?>">
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span12Class;?> boldtext">
								<strong>
								<?php echo  JText::_('OS_EXISTING_USERS_LOGIN');?>
								</strong>
							</div>
						</div>
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span3Class;?> boldtext">
								<?php echo JText::_('OS_USERNAME')?>
							</div>
							<div class="<?php echo $span8Class;?>">
								<input type="text" class="input-medium form-control" size="20" name="username" id="username" value="" />
							</div>
						</div>
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span3Class;?> boldtext">
								<?php echo JText::_('OS_PASSWORD')?>
							</div>
							<div class="<?php echo $span8Class;?>">
								<input type="password" class="input-medium form-control" size="20" name="password" id="password" value="" />
							</div>
						</div>
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span12Class;?>">
								<input type="submit" value="<?php echo JText::_('OS_LOGIN')?>" class="btn btn-success" onclick="javascript:checkLoginForm()" />
							</div>
						</div>
						<input type="hidden" name="remember" value="1" />
						<input type="hidden" name="return" value="<?php echo base64_encode($returnUrl) ; ?>" />
						<?php echo JHTML::_( 'form.token' ); ?>	
						</form>
						<?php
						}
					}
					
					if($user->id == 0){
						$usersConfig = JComponentHelper::getParams('com_users'); 
						if(($cClass['only_register_can_book']==1) and ($usersConfig->get('allowUserRegistration'))){
							?>
							<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar');?>" name="osregisterForm" id="osregisterForm">
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span12Class;?> boldtext">
									<strong>
									<?php echo  JText::_('OS_NEW_USER_REGISTER');?>
									</strong>
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_USERNAME')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input type="text" class="input-medium form-control" size="20" name="username" id="username" value="" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_PASSWORD')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input type="password" class="input-medium form-control" size="20" name="password1" id="password1" value="" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_REPASSWORD')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input type="password" class="input-medium form-control" size="20" name="password2" id="password2" value="" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_NAME')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input type="text" class="input-medium form-control" size="20" name="name" id="name" value="" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_EMAIL')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input type="text" class="input-medium form-control" value="<?php echo $email?>" size="20" name="email" id="email" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span12Class;?> boldtext">
									<input type="button" value="<?php echo JText::_('OS_REGISTER')?>" class="btn btn-warning" onclick="javascript:submitRegisterForm();" />
								</div>
							</div>
							<input type="hidden" name="option" value="com_oscalendar" />
							<input type="hidden" name="task" value="form_register" />
							<input type="hidden" name="Itemid" value="<?php echo $mainframe->input->getInt('Itemid')?>" />
							<input type="hidden" name="pid" id="pid" value="<?php echo $property->id?>" />
							<input type="hidden" name="date_from" id="date_from" value="<?php echo $lists['date_from']?>" />
							<input type="hidden" name="date_to" id="date_to" value="<?php echo $lists['date_to']?>" />
							<input type="hidden" name="uid" id="uid" value="<?php echo $mainframe->input->getString('uid','')?>" />
							</form>
							<script language="javascript">
							function submitRegisterForm(){
								var form = document.osregisterForm
								if (form.username.value == "") {
									alert("<?php echo JText::_('OS_ENTER_USERNAME'); ?>");
									form.username.focus();
									return ;
								}
								if (form.password1.value == "") {
									alert("<?php echo JText::_('OS_ENTER_PASSWORD'); ?>");
									form.password1.focus();
									return ;
								}
								if (form.password2.value != form.password1.value) {
									alert("<?php echo JText::_('OS_PASSWORD_DOES_NOT_MATCH'); ?>");
									form.password1.focus();
									return ;
								}
								if(form.email.value == ""){
									alert("<?php echo JText::_('OS_ENTER_EMAIL'); ?>");
									form.email.focus();
									return ;
								}else if(!validateEmail('osregisterForm','email')){
									alert("<?php echo JText::_('OS_EMAIL_IS_NOT_VALID'); ?>");
									form.email.focus();
									return ;
									
								}
								if(form.name.value == ""){
									alert("<?php echo JText::_('OS_ENTER_NAME'); ?>");
									form.name.focus();
									return ;
								}
								form.submit();
							}
							</script>
							<?php
						}
					}

					if(($cClass['only_register_can_book']==0) or ($user->id > 0)) {
					?>
					
					<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=form_step2&Itemid='.$mainframe->input->getInt('Itemid',0));?>" name="appform" id="bookingForm">
					
					<div class="<?php echo $rowFluidClass;?>">
						<div class="<?php echo $span12Class;?> checkout_details_div">
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span12Class;?>">
									<strong>
										<?php echo strtoupper(JText::_('OS_CUSTOMER_INFORMATION'));?>
									</strong>
								
									<BR /><BR />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_NAME')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input placeholder="<?php echo JText::_('OS_NAME')?>" type="text" class="input-large form-control" size="20" name="name" id="name" value="<?php echo $name;?>" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_EMAIL')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input placeholder="<?php echo JText::_('OS_EMAIL')?>" type="text" class="input-large form-control" value="<?php echo $email;?>" size="20" name="email" id="email" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_PHONE')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<input placeholder="<?php echo JText::_('OS_PHONE')?>" type="text" class="input-medium form-control" value="<?php echo $profile->phone;?>" size="10" name="phone" id="phone" />
								</div>
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_COUNTRY')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<?php echo $lists['country'];?>
								</div>
							
							</div>
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_NOTES')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<textarea name="notes" id="notes" cols="40" rows="4" class="input-large form-control"></textarea>
								</div>
							</div>
						</div>
					</div>
						
					<div class="<?php echo $rowFluidClass;?>">
						<div class="<?php echo $span12Class;?> checkout_details_div">
							<div class="<?php echo $rowFluidClass;?>">
								<div class="<?php echo $span12Class;?>">
									<strong>
										<?php echo strtoupper(JText::_('OS_ADDITIONAL_REQUEST'));?>
									</strong>
								</div>
							</div>
					
							<BR /><BR />
							<?php
							$fieldArr = array();
							for($i=0;$i<count($fields);$i++){
								$field = $fields[$i];
								if(($field->field_type == 2) or ($field->field_type == 3)){
									$fieldArr[] = $field->id;	
								}
								?>
								<div class="<?php echo $rowFluidClass;?>">
									<div class="<?php echo $span3Class;?> boldtext">
										<?php echo OSPHelper::getLanguageFieldValue($field,'field_label');?>
									</div>
									<div class="<?php echo $span8Class;?>">
										<?php
										HelperOScalendarExtrafields::showFormField($field,$order_temp_id);
										?>
									</div>
								</div>
								<?php
							}
							?>
							<input type="hidden" name="field_ids" id="field_ids" value="<?php echo implode(",",$fieldArr)?>"  />
							<input type="hidden" name="field_values" id="field_values" value=""  />
						</div>
					</div>

					<div class="<?php echo $rowFluidClass;?>">
						<div class="<?php echo $span12Class;?> btn btn-info noleftmargin">
							<?php
							echo JText::_('OS_SUMMARY');
							?>
						</div>
					</div>
					<div class="<?php echo $rowFluidClass;?>">
						<div class="<?php echo $span12Class;?> checkout_details_div" style="margin-top:10px;padding-bottom:10px;" id="summary_div_oscalendar">
							<?php
							OsCalendarAjax::generateSummary($order_temp_id);
							?>
						</div>
					</div>
						
						<div class="<?php echo $rowFluidClass;?>">
							<div class="<?php echo $span12Class;?> checkout_details_div">
								<div class="<?php echo $rowFluidClass;?>">
									<div class="<?php echo $span12Class;?>">
										<strong>
											<?php echo strtoupper(JText::_('OS_PAYMENT_OPTION'));?>
										</strong>
									</div>
								</div>
								<BR /><BR />
								<input type="hidden" name="nmethods" id="nmethods" value="<?php echo count($methods)?>" />
								<?php
								if(count($methods) > 0){
								?>
									<div class="<?php echo $rowFluidClass;?>">
										<div class="<?php echo $span3Class;?> boldtext">
											<?php echo JText::_('OS_PAYMENT_OPTION'); ?>*
										</div>
										<div class="<?php echo $span8Class;?>">
											<?php
											$method = null ;
											for ($i = 0 , $n = count($methods); $i < $n; $i++) {
												$paymentMethod = $methods[$i];
												if ($paymentMethod->getName() == $lists['paymentMethod']) {
													$checked = ' checked="checked" ';
													$method = $paymentMethod ;
												}										
												else 
													$checked = '';	
											?>
												<input onclick="changePaymentMethod();" type="radio" name="payment_method" id="pmt<?php echo $i?>" value="<?php echo $paymentMethod->getName(); ?>" <?php echo $checked; ?> /><?php echo JText::_($paymentMethod->getTitle()) ; ?> <br />
											<?php		
											}
											?>
										</div>
									</div>				
								<?php					
								} else {
									$method = $methods[0] ;
								}		
							
								if ($method->getCreditCard()) {
									$style = '' ;	
								} else {
									$style = 'style = "display:none"';
								}			
								?>
								<div class="<?php echo $rowFluidClass;?>">
									<div class="<?php echo $span12Class;?>">
										<table>
											<tr id="tr_card_number" <?php echo $style; ?>>
												<td class="infor_left_col"><?php echo  JText::_('OS_AUTH_CARD_NUMBER'); ?><span class="required">*</span></td>
												<td class="infor_right_col">
													<input type="text" name="x_card_num" id="x_card_num" class="osm_inputbox input-medium" onkeyup="checkNumber(this,'<?php echo JText::_('OS_ONLY_NUMBER'); ?>')" value="<?php echo $x_card_num; ?>" size="20" />
												</td>					
											</tr>
											<tr id="tr_exp_date" <?php echo $style; ?>>
												<td class="infor_left_col">
													<?php echo JText::_('OS_AUTH_CARD_EXPIRY_DATE'); ?><span class="required">*</span>
												</td>
												<td class="infor_right_col">	
													<?php echo $lists['exp_month'] .'  /  '.$lists['exp_year'] ; ?>
												</td>					
											</tr>
											<tr id="tr_cvv_code" <?php echo $style; ?>>
												<td class="infor_left_col">
													<?php echo JText::_('OS_AUTH_CVV_CODE'); ?><span class="required">*</span>
												</td>
												<td class="infor_right_col">
													<input type="text" name="x_card_code" id="x_card_code" class="osm_inputbox input-medium" onKeyUp="checkNumber(this,'<?php echo JText::_('OS_ONLY_NUMBER'); ?>')" value="<?php echo $x_card_code; ?>" size="20" />
												</td>					
											</tr>
											<?php
												if ($method->getCardType()) {
													$style = '' ;
												} else {
													$style = ' style = "display:none;" ' ;										
												}
											?>
												<tr id="tr_card_type" <?php echo $style; ?>>
													<td class="infor_left_col">
														<?php echo JText::_('OS_CARD_TYPE'); ?><span class="required">*</span>
													</td>
													<td class="infor_right_col">
														<?php echo $lists['card_type'] ; ?>
													</td>						
												</tr>					
											<?php
												if ($method->getCardHolderName()) {
													$style = '' ;
												} else {
													$style = ' style = "display:none;" ' ;										
												}
											?>
												<tr id="tr_card_holder_name" <?php echo $style; ?>>
													<td class="infor_left_col">
														<?php echo JText::_('OS_CARD_HOLDER_NAME'); ?><span class="required">*</span>
													</td>
													<td class="infor_right_col">
														<input type="text" name="card_holder_name" id="card_holder_name" class="osm_inputbox input-medium"  value="<?php echo $cardHolderName; ?>" size="40" />
													</td>						
												</tr>
											<?php									
												if ($method->getName() == 'os_echeck') {
													$style = '';												
												} else {
													$style = ' style = "display:none;" ' ;
												}
											?>
											
												<tr id="tr_bank_rounting_number" <?php echo $style; ?>>
												  <td class="infor_left_col"  class="infor_left_col"><?php echo JText::_('OSM_BANK_ROUTING_NUMBER'); ?><span class="required">*</span></td>
												  <td class="infor_right_col"><input type="text" name="x_bank_aba_code" class="osm_inputbox input-medium"  value="<?php echo $x_bank_aba_code; ?>" size="40" onKeyUp="checkNumber(this,'<?php echo JText::_('OS_ONLY_NUMBER'); ?>');" /></td>
												</tr>
												<tr id="tr_bank_account_number" <?php echo $style; ?>>
												  <td class="infor_left_col" class="infor_left_col"><?php echo JText::_('OSM_BANK_ACCOUNT_NUMBER'); ?><span class="required">*</span></td>
												  <td class="infor_right_col"><input type="text" name="x_bank_acct_num" class="osm_inputbox input-medium"  value="<?php echo $x_bank_acct_num; ?>" size="40" onKeyUp="checkNumber(this,'<?php echo JText::_('OS_ONLY_NUMBER'); ?>');" /></td>
												</tr>
												<tr id="tr_bank_account_type" <?php echo $style; ?>>
												  <td class="infor_left_col"  class="infor_left_col"><?php echo JText::_('OSM_BANK_ACCOUNT_TYPE'); ?><span class="required">*</span></td>
												  <td class="infor_right_col"><?php echo $lists['x_bank_acct_type']; ?></td>
												</tr>
												<tr id="tr_bank_name" <?php echo $style; ?>>
												  <td class="infor_left_col" class="infor_left_col"><?php echo JText::_('OSM_BANK_NAME'); ?><span class="required">*</span></td>
												  <td class="infor_right_col"><input type="text" name="x_bank_name" class="osm_inputbox input-medium"  value="<?php echo $x_bank_name; ?>" size="40" /></td>
												</tr>
												<tr id="tr_bank_account_holder" <?php echo $style; ?>>
												  <td class="infor_left_col" class="infor_left_col"><?php echo JText::_('OSM_ACCOUNT_HOLDER_NAME'); ?><span class="required">*</span></td>
												  <td class="infor_right_col"><input type="text" name="x_bank_acct_name" class="osm_inputbox input-medium"  value="<?php echo $x_bank_acct_name; ?>" size="40" /></td>
												</tr>	
											<?php
											$idealEnabled = OSCHelper::idealEnabled();		
											if ($idealEnabled) {
												if ($method->getName() == 'os_ideal') {
													$style = '' ;
												} else {
													$style = ' style = "display:none;" ' ;
												}	
											?>
												<tr id="tr_bank_list" <?php echo $style; ?>>
													<td class="infor_left_col">
														<?php echo JText::_('OS_BANK_LIST'); ?><span class="required">*</span>
													</td>
													<td class="infor_right_col">
														<?php echo $lists['bank_id'] ; ?>
													</td>
												</tr>
											<?php	
											}
										?>
										</table>
									</div>
							    </div>
							</div>
						</div>
					</div>
					<div class="<?php echo $rowFluidClass;?>">
						<div class="<?php echo $span12Class;?> checkout_details_div">
							<div class="<?php echo $rowFluidClass;?>">
								<?php
								if($cClass['use_captcha'] == 3){
								?>
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_CAPCHA')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<?php
									JPluginHelper::importPlugin('captcha');
									$dispatcher = JDispatcher::getInstance();
									$dispatcher->trigger('onInit','dynamic_recaptcha_1');
									?>
									<div id="dynamic_recaptcha_1"></div>
								</div>
								<?php
								}elseif($cClass['use_captcha'] == 2){
								?>
								<div class="<?php echo $span3Class;?> boldtext">
									<?php echo JText::_('OS_CAPCHA')?>
								</div>
								<div class="<?php echo $span8Class;?>">
									<?php
									$resultStr = md5(OSCHelper::getRealTime());// md5 to generate the random string
									$resultStr = substr($resultStr,0,5);//trim 5 digit 
									?>
									<img src="<?php echo $root_link?>index.php?option=com_oscalendar&no_html=1&task=ajax_captcha&resultStr=<?php echo $resultStr?>" />  
									<input type="text" class="input-small" id="security_code" name="security_code" maxlength="5" style="width: 50px; margin: 0;"/>
									<input type="hidden" name="resultStr" id="resultStr" value="<?php echo $resultStr?>">
								</div>
								<?php
								}
							?>
							</div>
							<?php
								if($cClass['enable_term_and_condition'] ==1){
								?>
								<div class="<?php echo $rowFluidClass;?>">
									<div class="<?php echo $span12Class;?>">
										<input type="checkbox" name="term_and_condition" id="term_and_condition" value="0" style="margin:0px !important;" onclick="javascript:changeValue('term_and_condition');"/>
										&nbsp;<strong>
										<a href="<?php echo $root_link?>index.php?option=com_content&view=article&id=<?php echo $cClass['article_id'];?>&tmpl=component" class="osmodal" rel="{handler: 'iframe', size: {x: 500, y: 400}}">
										<?php echo JText::_('OS_I_AGREE_WITH_THE_TERM_AND_CONDITION');?>
										</a>
										</strong>
									</div>
								</div>
								<?php
								}
								?>
								<div class="<?php echo $rowFluidClass;?>">
									<div class="<?php echo $span12Class;?>" style="text-align:center;">
										<input type="button" class="btn btn-success" value="<?php echo JText::_('OS_SUBMIT')?>" onclick="javascript:confirmBooking()">
									</div>
								</div>
							</div>
						</div>
					</div>
					<input type="hidden" name="fields" id="fields" value="" />
					<input type="hidden" name="option" value="com_oscalendar" />
					<input type="hidden" name="task" value="form_step2" />
					<input type="hidden" name="enable_termandcondition" id="enable_termandcondition" value="<?php echo $cClass['enable_term_and_condition'];?>" />
					<input type="hidden" name="coupon_id" id="coupon_id" value=""/>
					<input type="hidden" name="pid" id="pid" value="<?php echo $property->id?>" />
					<input type="hidden" name="use_captcha" id="use_captcha" value="<?php echo $cClass['use_captcha'];?>" />
					<input type="hidden" name="current_link" id="current_link" value="<?php echo $cClass['current_link']?>" />
					<input type="hidden" name="date_from" id="date_from" value="<?php echo $lists['date_from']?>" />
					<input type="hidden" name="date_to" id="date_to" value="<?php echo $lists['date_to']?>" />
					<input type="hidden" name="order_temp_id" id="order_temp_id" value="<?php echo $order_temp_id?>" />

					</form>
					<?php
					}
					?>
				
		</div>	
		
		<script language="javascript">
		function confirmBooking(){
			var form			=   document.appform;
			var order_name 		= 	document.getElementById('name');
			var order_email 	= 	document.getElementById('email');
			var order_phone 	= 	document.getElementById('phone');
			var order_country 	= 	document.getElementById('country');
			var live_site 		= 	document.getElementById('live_site');
			var resultStr 		=   document.getElementById('resultStr');
			var use_captcha		= 	document.getElementById('use_captcha');
			var field_ids		= 	document.getElementById('field_ids');
			var notes		 	= 	document.getElementById('notes');
			var enable_termandcondition = document.getElementById('enable_termandcondition');
			notes				= 	notes.value;
			notes				= 	notes.replace("&","(@)");
			notes				= 	notes.replace("\"","'");
			
			var coupon_code	 	=   document.getElementById('coupon_code');
			if(coupon_code != null){
				if(coupon_code.value != ""){
					var answer = confirm("<?php echo JText::_('OS_YOU_ENTER_COUPON_CODE')?>");
					if(answer == 1){
						alert("<?php echo JText::_('OS_CLICK_CHECK_COUPON');?>");
						coupon_code.focus();
						return false;
					}else{
						coupon_code.value = "";
					}
				}
			}
			//notes				= 	notes.replace("\n","@n@");
			//notes				= 	notes.replace("\r","@r@");
			var methodpass = 1;
			var paymentMethod 	= "";
			var x_card_num = "";
			var x_card_code = "";
			var card_holder_name = "";
			var exp_month = "";
			var exp_year = "";
			var card_type = "";
			<?php
			//if($cClass['disable_payments'] == 1){
				if (count($methods) > 0) {
					if (count($methods) > 1) {
					?>
						var paymentValid = false;
						var nmethods = document.getElementById('nmethods');
						var methodtemp;
						for (var i = 0 ; i < nmethods.value; i++) {
							methodtemp = document.getElementById('pmt' + i);
							if(methodtemp.checked == true){
								paymentValid = true;
								paymentMethod = methodtemp.value;
								break;
							}
						}
						
						if (!paymentValid) {
							alert("<?php echo JText::_('OS_REQUIRE_PAYMENT_OPTION'); ?>");
							methodpass = 0;
						}		
					<?php	
					} else {
					?>
						paymentMethod = "<?php echo $methods[0]->getName(); ?>";
					<?php	
					}				
					?>
					method = methods.Find(paymentMethod);	
					if (method.getCreditCard()) {
						var x_card_nume = document.getElementById('x_card_num');
						if (x_card_nume.value == "") {
							alert("<?php echo  JText::_('OS_ENTER_CARD_NUMBER'); ?>");
							x_card_nume.focus();
							methodpass = 0;
                            return false;
						}else{
							x_card_num = x_card_nume.value;
						}
						
						var x_card_codee = document.getElementById('x_card_code');
						if (x_card_codee.value == "") {
							alert("<?php echo JText::_('OS_ENTER_CARD_CODE'); ?>");
							x_card_codee.focus();
							methodpass = 0;
                            return false;
						}else{
							x_card_code = x_card_codee.value;
						}
					}
					
					if (method.getCardHolderName()) {
						card_holder_namee = document.getElementById('card_holder_name');
						if (card_holder_namee.value == '') {
							alert("<?php echo JText::_('OS_ENTER_CARD_HOLDER_NAME') ; ?>");
							card_holder_namee.focus();
							methodpass = 0;
                            return false;
						}else{
							card_holder_name = card_holder_namee.value;
						}
					}
	
					var exp_yeare = document.getElementById('exp_year');
					exp_year = exp_yeare.value;
					var exp_monthe = document.getElementById('exp_month');
					exp_month = exp_monthe.value;
					var card_typee =  document.getElementById('card_type');
					card_type = card_typee.value;
				<?php
				}
			//}
			?>
			
			field_ids			= 	field_ids.value;
			var fieldArr		= 	new Array();
			fieldArr			= 	field_ids.split(",");
			var str				=	"";
			var temp;
			var element;
			if(fieldArr.length > 0){
				for(i=0;i<fieldArr.length;i++){
					temp = fieldArr[i];
					element = document.getElementById('field_' + temp);
					if(element != null){
						if(element.value != ""){
							str += temp + "|" + element.value + "||";
						}
					}
				}
				if(str != ""){
					str = str.substring(0,str.length - 2);
				}
				str = str.replace("\"","'");
				document.getElementById('fields').value = str;
			}
			
			if(order_name != null){
				order_name = order_name.value;
			}else{
				order_name = "";
			}
			if(order_email != null){
				order_email = order_email.value;
			}else{
				order_email = "";
			}
			if(order_phone != null){
				order_phone = order_phone.value;
			}else{
				order_phone = "";
			}
			if(order_country != null){
				order_country = order_country.value;
			}else{
				order_country = "";
			}
			
			var check_captcha = 0;
			var captcha_pass = 0;
			if(use_captcha.value == "2"){
				check_captcha = 1;
				var security_code   =   document.getElementById('security_code');
				if(security_code.value == ""){
					captcha_pass = 0;
				}else if(security_code.value != resultStr.value){
					captcha_pass = 0;
				}else{
					captcha_pass = 1;
				}
			}
			
			var pass_term = 1;
			if(enable_termandcondition.value == 1){
				var term_and_condition = document.getElementById('term_and_condition');
				//if(term_and_condition.value == 0){
					//pass_term = 0;
				//}
                if(! document.getElementById('term_and_condition').checked){
                    pass_term = 0;
                }
			}
			
			if(methodpass == 1){
				if((check_captcha == 1) && (captcha_pass == 0)){
					var security_code   =   document.getElementById('security_code');
					alert("<?php echo Jtext::_('OS_CAPTCHA_IS_NOT_VALID');?>");
					security_code.focus();
				}else if(order_name == ""){
					alert("<?php echo JText::_('OS_PLEASE_ENTER_YOUR_NAME')?>");
					document.getElementById('name').focus();
				}else if(order_email == ""){
					alert("<?php echo JText::_('OS_PLEASE_ENTER_YOUR_EMAIL')?>");
					document.getElementById('order_email').focus();
				}else if(validateEmail('appform','email') == false){
					alert("<?php echo JText::_('OS_EMAIL_IS_NOT_VALID')?>");
					document.getElementById('email').focus();
				}else if(order_phone == ""){
					alert("<?php echo JText::_('OS_PLEASE_ENTER_YOUR_PHONE_NUMBER')?>");
					document.getElementById('phone').focus();
				}else if(pass_term == 0){
					alert("<?php echo JText::_('OS_PLEASE_AGREE_TERM_AND_CONDITION');?>");
				}else{
					form.submit();
				}
			}
		}
		</script>
		<?php
	}
}
?>