<?php
/*------------------------------------------------------------------------
# ajax.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;


class OsCalendarAjax{
	/**
	 * Ajax default function
	 *
	 * @param unknown_type $option
	 * @param unknown_type $task
	 */
	static function display($option,$task){
		global $mainframe;
		require_once(JPATH_ROOT.DS."components".DS."com_osproperty".DS."helpers".DS."common.php");
		$rid = $mainframe->input->getInt('rid',0);
		$pid = $mainframe->input->getInt('pid',0);
		switch ($task){
			case "ajax_showinfor":
				OsCalendarAjax::showInforForm($option);
			break;
			case "ajax_captcha":
				OsCalendarAjax::captcha($option);
			break;
			case "ajax_confirminfo":
				OsCalendarAjax::confirmInforForm($option);
			break;
			case "ajax_createOrder":
				OsCalendarAjax::createOrder($option);
			break;
			case "ajax_loadCalendar":
				OsCalendarAjax::loadCalendar($option);
			break;
			case "ajax_checkAvailabilityAjax":
				OsCalendarAjax::checkAvailabilityAjax($option);
			break;
			case "ajax_checkavailabilitybackend":
				OsCalendarAjax::checkAvailabilityAjaxBackend($option);
			break;
			case "ajax_loadavailability":
				OsCalendarAjax::loadAvailabilityCalendar($option);
			break;
			case "ajax_updateAjaxSummary":
				OsCalendarAjax::updateAjaxSummary($pid,$rid);
			break;
			case "ajax_showRoomPrice":
				OsCalendarAjax::showRoomPrice($pid,$rid);
			break;
			case "ajax_updateAjaxSummary_selectfield":
				OsCalendarAjax::updateAjaxSummary_selectfield();
			break;
			case "ajax_updateAjaxSummary_checkboxfield":
				OsCalendarAjax::updateAjaxSummary_checkboxfield();
			break;
			case "ajax_addtocart":
				OsCalendarAjax::addtocart($pid,$rid);
			break;
			case "ajax_updateCheckout":
				OsCalendarAjax::updateCheckout();
			break;
		}
	}

	static function updateCheckout(){
		global $mainframe;
		$value = $mainframe->input->getString('value','');
		?>
		<?php echo JText::_('OS_TO')?>:
		<BR />
		<?php
		echo OSCHelper::loadCalendarTag('book_to',$value,'input-small inlinesmall','',JText::_('OS_CHECKOUT'),'');
		exit();
	}
	
	/**
	 * Update Ajax summarys
	 *
	 * @param unknown_type $option
	 */
	static function updateAjaxSummary($pid,$rid){
		global $mainframe,$configClass,$cClass;
		$db = JFactory::getDbo();
		$book_information = $mainframe->input->getString('book_information','');
		$book_informationArr = explode("|",$book_information);
		$price_plan_id = $book_informationArr[0];
		$number_room_booking = $book_informationArr[1];
		$book_from = $book_informationArr[2];
		$book_to = $book_informationArr[3];
		if($price_plan_id > 0){
			$db->setQuery("Select * from #__oscalendar_room_prices where id = '$price_plan_id'");
			$price = $db->loadObject();
			$price_value = $price->price;
			$total_price = $price_value*$number_room_booking;
		}else{
			$selected_date = OSCHelper::generateDateArr($book_from,$book_to);
			$price   	   = OSCHelper::calSubTotalTypeProperty($rid,$selected_date,$number_room_booking);
			$total_price   = $price->price;
		}
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$book_from = strtotime($book_from);
		$book_from = date($cClass['date_format'],$book_from);
		$book_to = strtotime($book_to);
		$book_to = date($cClass['date_format'],$book_to);
		HTML_OsCalendarAjax::updateCartSummary($book_from,$book_to,$total_price,$room,$number_room_booking,$price);
		exit();
	}
	
	/**
	 * Load Availability Calendar
	 *
	 * @param unknown_type $option
	 */
	static function loadAvailabilityCalendar($option){
		global $mainframe,$configClass;
		$pid = $mainframe->input->getInt('pid',0);
		$rid = $mainframe->input->getInt('rid',0);
		$month = $mainframe->input->getInt('month','');
		$year = $mainframe->input->getInt('year','');
		$k = 0;
		$m = intval($month);
		$y = intval($year);
		for($i=0;$i<4;$i++){
			$k++;
			$m = $month + $i;
			if($m > 12){
				$m = $m - 12;
				$y = $year + 1;
			}
			?>
			<div class="span6" style="margin-left:0px;padding-right:10px;padding-bottom:20px;">
				<?php HelperOsCalendarCalendar::initAvailabilityCalendar($pid,$rid,$y,$m,'');?>
			</div>
			<?php
			if($k == 2)	{
				?>
				<div class="clearfix"></div>
				<?php
				$k = 0;
			}
		}
		exit();
	}
	
	/**
	 * Check availability calendar ajax
	 *
	 * @param unknown_type $option
	 */
	static function checkAvailabilityAjaxBackend($option){
		global $mainframe,$configClass;
		$db 			= JFactory::getDbo();
		$order_id		= $mainframe->input->getInt('order_id',0);
		$pid 			= $mainframe->input->getInt('pid',0);
		$rid			= $mainframe->input->getInt('rid',0);
		$nroom			= $mainframe->input->getInt('nroom',0);
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$pro_type = $property->pro_type;
		
		if($property->ref != ""){
			$property_name = $property->ref.", ".$property->pro_name;
		}else{
			$property_name = $property->pro_name;
		}
		
		$db->setQuery("Select price_type from #__osrs_types where id = '$pro_type'");
		$price_type = $db->loadResult();
		
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$room_number = $room->room_number;
		
		$date_from 		= $mainframe->input->getString('book_from','');
		$date_to 		= $mainframe->input->getString('book_to','');
		
		$canbook = 1;
		
		//check season
		$date_from_int 	= strtotime($date_from." ".$hour_from.":00:00");
		$date_to_int	= strtotime($date_to." ".$hour_to.":00:00");
		
		if($date_from == $date_to){
			$canbook = 0;
		}
		
		if($date_from_int > $date_to_int){
			$canbook = 0;
		}
		
		if($order_id > 0){
			$orderSql = " and id <> '$order_id'";
		}else{
			$orderSql = "";
		}
		if($price_type == 0){ //type: Holiday
			//1. There is the an unavailable date between the time range
			$selected_date = OSCHelper::generateDateArr($date_from,$date_to);
			$available_to_book = OSCHelper::checkAvailableStatus($rid,$selected_date); //pass this step?
			if($available_to_book == 0){
				$canbook = 0;
			}
			//2. No price setting for one or more days in time range
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and price_from = '$date_from' and price_to =  '$date_to'");
			$count = $db->loadResult();
			if($count == 0){
				$canbook = 0;
			}
			//3. No available room for one or more days in time range
			$broom = OSCHelper::maxRoomBookedTypeHoliday($rid,$book_from,$book_to);
			if($broom == $room_number){
				$canbook = 0;
			}elseif($room_number - $broom < $nroom){
				$canbook = 0;
			}
		}else{ //type: Property
			//1. There is the an unavailable date between the time range
			$selected_date = OSCHelper::generateDateArr($date_from,$date_to);
			$available_to_book = OSCHelper::checkAvailableStatus($rid,$selected_date); //pass this step?
			if($available_to_book == 0){
				$canbook = 0;
			}
			//2. No price setting for one or more days in time range
			$available_to_book = OSCHelper::checkPriceSetupForOneTimeRange($rid,$selected_date);
			if($available_to_book == 0){
				$canbook = 0;
			}
			//3. No available room for one or more days in time range
			$broom = OSCHelper::maxRoomBookedTypeProperty($rid,$date_from,$date_to);
			if($broom == $room_number){
				$canbook = 0;
			}elseif($room_number - $broom < $nroom){
				$canbook = 0;
			}
		}
		if($canbook == 0){
			echo "0@@";
			printf(JText::_('OS_PROPERTY_IS_NOT_AVAILABLE_IN'),$property_name,$room->room_name,$date_from,$date_to,$nroom);
		}else{
			echo "1@@";
			printf(JText::_('OS_PROPERTY_IS_AVAILABLE_IN'),$property_name,$room->room_name,$date_from,$date_to,$nroom);
		}
		exit();
	}
	
	
	/**
	 * Check availability ajax
	 *
	 * @param unknown_type $option
	 */
	static function checkAvailabilityAjax($option){
		global $mainframe,$configClass;
		$cClass 		= OSCHelper::getConfiguration();
		$db 			= JFactory::getDbo();
		$pid 			= $mainframe->input->getInt('pid',0);
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$start_date 		= $mainframe->input->getString('date_from','');
		$end_date 		= $mainframe->input->getString('date_to','');
		
		$start_date_int 	= strtotime($start_date);
		$end_date_int	= strtotime($end_date);
		
		$canbook = 1;
		
		if($start_date == $end_date){
			$canbook = 0;
			$msg = JText::_('OS_CHECKOUT_MUST_LATER_THAN_CHECKIN');
		}
		
		if($start_date_int > $end_date_int){
			$canbook = 0;
			$msg = JText::_('OS_CHECKOUT_MUST_LATER_THAN_CHECKIN');
		}
		
		$today = OSCHelper::getRealTime();
		if($start_date_int < $today){
			
			$msg = JText::_('OS_CHECKINT_MUST_LATER_THAN_TODAY');
			$canbook = 0;
		}else{
			//check each date
			//step 1: check to see whether if there is the booking request between request days
			for($i=$start_date_int;$i<=$end_date_int;$i=$i + 24*3600){
				$temp_date = date("Y-m-d",$i);
				$query = "Select count(id) from #__oscalendar_booking where pid = '$pid' and book_from <= '$temp_date' and book_to > '$temp_date' and order_status in ('S','P')";
				$db->setQuery($query);
				$count = $db->loadResult();
				if($count > 0){
					$msg = JText::_('OS_YOUR_BOOKING_REQUEST_IS_NOT_AVAILABLE');
					$canbook = 0;
				}
			}
			
			//step 2: check to see whether if there is the unavailable date
			//first date, only check unavailable in the evening
			if($canbook == 1){
				$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and availtype = '2' and checkdate = '$start_date'");
				$count = $db->loadResult();
				if($count > 0){
					$msg = JText::_('OS_YOUR_BOOKING_REQUEST_IS_NOT_AVAILABLE');
					$canbook = 0;
				}
			}
			
			if($canbook == 1){
				//end date
				$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and availtype = '1' and checkdate = '$end_date'");
				$count = $db->loadResult();
				if($count > 0){
					$msg = JText::_('OS_YOUR_BOOKING_REQUEST_IS_NOT_AVAILABLE');
					$canbook = 0;
				}
			}
			
			if($canbook == 1){
				//check the date between start and end date
				for($i=$start_date_int + 24*3600;$i<$end_date_int;$i=$i + 24*3600){
					$temp_date = date("Y-m-d",$i);
					$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and checkdate = '$temp_date'");
					$count = $db->loadResult();
					if($count > 0){
						$msg = JText::_('OS_YOUR_BOOKING_REQUEST_IS_NOT_AVAILABLE');
						$canbook = 0;
					}
				}
			}
		}
		
		if($canbook == 1){
			//check season to return price or warning
			$season = array();
			$season_store = array();
			for($i=$start_date_int;$i<$end_date_int;$i=$i + 24*3600){
				$temp_date = date("Y-m-d",$i);
				$db->setQuery("Select count(id) from #__oscalendar_seasons where published = '1' and start_date <= '$temp_date' and end_date >= '$temp_date'");
				$count = $db->loadResult();
				if($count == 0){
					$msg = JText::_('OS_PRICE_HAS_NOT_BEEN_SETUP_FOR_YOUR_BOOKING_REQUEST');
					$canbook = 0;
				}else{
					$db->setQuery("Select id from #__oscalendar_seasons where published = '1' and start_date <= '$temp_date' and end_date >= '$temp_date'");
					$sid = $db->loadResult();
					if(!in_array($sid,$season)){
						$season[count($season)] = $sid;
						$season_store[$sid]->value = 1;
						$season_store[$sid]->start = $i;
					}else{
						$season_store[$sid]->value++;
					}
				}
			}
		}
		
		if($canbook == 1){
			if(count($season) > 0){
				$total = 0;
				for($i=0;$i<count($season);$i++){
					$sid = $season[$i];
					$db->setQuery("Select * from #__oscalendar_seasons where id = '$sid'");
					$seasonObj = $db->loadObject();
					$min_book = $seasonObj->min_book;
					$nights = $seasonObj->nights;
					$db->setQuery("Select * from #__oscalendar_property_seasons_prices where pid = '$pid' and season_id = '$sid'");
					$priceObj = $db->loadObject();
					if(!$priceObj->id){
						$msg = JText::_('OS_PRICE_HAS_NOT_BEEN_SETUP_FOR_YOUR_BOOKING_REQUEST');
						$canbook = 0;
					}else{
						$price = $priceObj->price;
						$pricePerNight = round($price/$nights,2);
						$season_store[$sid]->season_id = $sid;
						$selected_night = $season_store[$sid]->value;
						if($selected_night < $min_book){
							$msg = JText::_('OS_WE_HAVE_THE_PROBLEM_WITH_NUMBER_NIGHTS_AT_BOOKING_REQUEST');
							$canbook = 0;
						}else{
							
							$season_store[$sid]->end = $season_store[$sid]->start + $selected_night*24*3600;
							
							if($selected_night >= $nights){
								$rNights = $selected_night % $nights;
								$nBlocks = ($selected_night - $rNights)/ $nights;
								$season_store[$sid]->nBlocks->count = $nBlocks;
								$season_store[$sid]->nBlocks->from  = $season_store[$sid]->start;
								$season_store[$sid]->nBlocks->to  	= $season_store[$sid]->start + $nBlocks*$nights*24*3600;
								$season_store[$sid]->nBlocks->price = $nBlocks*$price;
								$season_store[$sid]->nNights->count = $rNights;
								$season_store[$sid]->nNights->price = $rNights*$pricePerNight;
								//calculate the remain date
								$temp = array();
								for($j=$season_store[$sid]->nBlocks->to;$j<$season_store[$sid]->end;$j=$j + 24*3600){
									$temp[] = $j;
								}
								$season_store[$sid]->nNights->rNights = $temp;
								
								$total += $season_store[$sid]->nBlocks->price + $season_store[$sid]->nNights->price;
							}else{
								$rNights = $selected_night;
								$season_store[$sid]->nBlocks->count	= 0;
								$season_store[$sid]->nNights->count = $rNights;
								$season_store[$sid]->nNights->price = $rNights*$pricePerNight;
								$temp = array();
								for($j=$season_store[$sid]->start;$j<$season_store[$sid]->end;$j=$j + 24*3600){
									$temp[] = $j;
								}
								$season_store[$sid]->nNights->rNights = $temp;
								
								$total += $season_store[$sid]->nNights->price;
							}
						}
					}
				}
			}
		}
		
		//echo $msg;
		if($canbook == 0){
			echo JText::_('OS_CANNOT_BOOK_FROM')." <B>".OSCHelper::showDateFormat($start_date_int,1)."</B> to <B>".OSCHelper::showDateFormat($end_date_int,1)."</B>";
			
		}else{
			OsCalendarAjax::showInforForm($option,$start_date_int,$end_date_int,$season_store,$property,$total);
		}
		exit();
	}
	
	
	/**
	 * Load calendar
	 *
	 * @param unknown_type $option
	 */
	static function loadCalendar($option){
		global $mainframe;
		$month = $mainframe->input->getInt('month');
		$year  = $mainframe->input->getInt('year');
		$item  = $mainframe->input->getString('item','');
		$pid   = $mainframe->input->getInt('pid',0);
		HelperOsCalendarCalendar::initCalendar($pid,$year,$month,$item);
		exit();
	}
	
	/**
	 * Show information form
	 *
	 * @param unknown_type $option
	 */
	static function showInforForm($option,$date_from_int,$date_to_int,$season_store,$property,$total){
		global $mainframe;
		$db = JFactory::getDbo();
		$lists['date_from_int'] = $date_from_int;
		$lists['date_to_int'] = $date_to_int;
		$lists['property'] = $property;
		$lists['season_store'] = $season_store;
		$lists['total'] = $total;
		HTML_OsCalendarAjax::showInforFormHTML($option,$lists);
	}
	
	function confirmInforForm($option){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$pid 			= $mainframe->input->getInt('pid',0);
		$db->setQuery("Select * from #__oscalendar_properties_config where pid = '$pid'");
		$config = $db->loadObject();
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$date_from 		= $mainframe->input->getString('book_from','');
		$date_to 		= $mainframe->input->getString('book_to','');
		$hour_from		= $mainframe->input->getString('hour_from','');
		$hour_to		= $mainframe->input->getString('hour_to','');
		$lists['date_from_int'] = strtotime($date_from." ".$hour_from.":00:00");
		$lists['date_to_int'] = strtotime($date_to." ".$hour_to.":00:00");
		$lists['config'] = $config;
		$lists['property'] = $property;
		HTML_OsCalendarAjax::confirmInforFormHTML($option,$lists);
		exit();
	}

	
	/**
	 * Get order cost
	 *
	 * @param unknown_type $userdata
	 */
	static function getOrderCost($userdata){
		global $mainframe;
		$db = JFactory::getDbo();
		$total = 0;
		if($userdata != ""){
			$userdata = explode("||",$userdata);
			for($i=0;$i<count($userdata);$i++){
				$data = explode("|",$userdata[$i]);
				$sid  = $data[0];
				$db->setQuery("Select service_price from #__app_sch_services where id = '$sid'");
				$service_price = $db->loadResult();
				$total += $service_price;
			}
		}
		return $total;
	}
	
	/**
	 * Captcha generetor
	 *
	 * @param unknown_type $option
	 */
	static function captcha($option){
		global $mainframe;
		while (@ob_end_clean());
		$ResultStr = $mainframe->input->getString('resultStr');
		$NewImage =imagecreatefromjpeg(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."style".DS."images".DS."img.jpg");//image create by existing image and as back ground 
		$LineColor = imagecolorallocate($NewImage,233,239,239);//line color 
		$TextColor = imagecolorallocate($NewImage, 255, 255, 255);//text color-white
		imageline($NewImage,1,1,40,40,$LineColor);//create line 1 on image 
		imageline($NewImage,1,100,60,0,$LineColor);//create line 2 on image 
		imagestring($NewImage, 5, 20, 10, $ResultStr, $TextColor);// Draw a random string horizontally 
		header("Content-type: image/jpeg");// out out the image 
		imagejpeg($NewImage);//Output image to browser 
		exit();
	}
	
	/**
	 * Show Room price
	 *
	 * @param unknown_type $rid
	 */
	static function showRoomPrice($pid,$rid){
		global $mainframe;
		$m = $mainframe->input->getInt('m',0);
		$y = $mainframe->input->getInt('y',0);
		$optionArr = array();
		$monthArr = array(JText::_('OS_CALENDAR_JANUARY'),JText::_('OS_CALENDAR_FEBRUARY'),JText::_('OS_CALENDAR_MARCH'),JText::_('OS_CALENDAR_APRIL'),JText::_('OS_CALENDAR_MAY'),JText::_('OS_CALENDAR_JUNE'),JText::_('OS_CALENDAR_JULY'),JText::_('OS_CALENDAR_AUGUST'),JText::_('OS_CALENDAR_SEPTEMBER'),JText::_('OS_CALENDAR_OCTOBER'),JText::_('OS_CALENDAR_NOVEMBER'),JText::_('OS_CALENDAR_DECEMBER'));
		for($i=1;$i<=12;$i++){
			$optionArr[] = JHTML::_('select.option',$i,$monthArr[$i-1]);
		}
		$lists['month'] = JHTML::_('select.genericlist',$optionArr,'m','class="input-small"','value','text',$m);
		$optionArr = array();
		$current_year = date("Y",time());
		for($i=$current_year;$i<=$current_year + 5;$i++){
			$optionArr[] = JHTML::_('select.option',$i,$i);
		}
		$lists['year'] = JHTML::_('select.genericlist',$optionArr,'y','class="input-small"','value','text',$y);
		
		HTML_OsCalendarAjax::showPriceForm($pid,$rid,$y,$m,$lists);
	}
	
	/**
	 * This function is used to show the Summary with:
	 * Subtotal price
	 * Extra field price
	 *
	 * @param unknown_type $order_temp_id
	 */
	public static function generateSummary($order_temp_id){
		global $mainframe,$lang_suffix;
		$db = JFactory::getDbo();
		$db->setQuery("Select a.*,b.pro_name$lang_suffix as pro_name, c.room_name$lang_suffix as room_name from #__oscalendar_order_temp as a inner join #__osrs_properties as b on b.id = a.pid inner join #__oscalendar_rooms as c on c.id = a.rid where a.id = '$order_temp_id'");
		$order = $db->loadObject();
		
		$db->setQuery("Select a.*,b.field_label$lang_suffix as field_label,c.field_option$lang_suffix as field_option from #__oscalendar_order_temp_field_options as a inner join #__oscalendar_fields as b on b.id = a.field_id inner join #__oscalendar_field_options as c on a.option_id = c.id where a.order_id = '$order_temp_id' order by b.field_label");
		$fields = $db->loadObjectList();
		HTML_OsCalendarAjax::generateSummaryForm($order,$fields);
		
	}
	
	/**
	 * This function is used to update the select list extra field into temp order table 
	 * And then, it will call function self::generateSummary to show the Summary form
	 *
	 */
	public static function updateAjaxSummary_selectfield(){
		global $mainframe;
		$db = JFactory::getDbo();
		$order_temp_id = $mainframe->input->getInt('order_temp_id',0);
		$fieldid       = $mainframe->input->getInt('fieldid',0);
		$fieldvalue    = $mainframe->input->getInt('fieldvalue',0);
	
		if($fieldvalue > 0){
			$db->setQuery("Delete from #__oscalendar_order_temp_field_options where order_id = '$order_temp_id' and field_id = '$fieldid'");
			$db->execute();
			$db->setQuery("Select * from #__oscalendar_field_options where id = '$fieldvalue'");
			$fieldoption = $db->loadObject();
			if($fieldoption->option_free == 0){
				$fee = $fieldoption->additional_price;
			}else{
				$fee = 0;
			}
			$db->setQuery("Insert into #__oscalendar_order_temp_field_options  (id,order_id,field_id,option_id,additional_price) values (NULL,'$order_temp_id','$fieldid','$fieldoption->id','$fee')");
			$db->execute();
		}else{
			$db->setQuery("Delete from #__oscalendar_order_temp_field_options where order_id = '$order_temp_id' and field_id = '$fieldid'");
			$db->execute();
		}
		
		self::generateSummary($order_temp_id);
	}
	
	/**
	 * This function is used to update the checkboxes extra field into temp order table
	 * And then, it will call function self::generateSummary to show the Summary form
	 *
	 */
	static function updateAjaxSummary_checkboxfield(){
		global $mainframe;
		$db = JFactory::getDbo();
		$order_temp_id = $mainframe->input->getInt('order_temp_id',0);
		$fieldid       = $mainframe->input->getInt('fieldid',0);
		$fieldvalue    = $mainframe->input->getInt('fieldvalue',0);
		$fieldoption   = $mainframe->input->getInt('fieldoption',0);
		$check		   = $mainframe->input->getInt('check',0);
		if($fieldvalue > 0){
			$db->setQuery("Delete from #__oscalendar_order_temp_field_options where order_id = '$order_temp_id' and field_id = '$fieldid' and option_id = '$fieldoption'");
			$db->execute();
			$db->setQuery("Select * from #__oscalendar_field_options where id = '$fieldoption'");
			$fieldoptionvalue = $db->loadObject();
			if($fieldoptionvalue->option_free == 0){
				$fee = $fieldoptionvalue->additional_price;
			}else{
				$fee = 0;
			}
			if($check == 1){
				$db->setQuery("Insert into #__oscalendar_order_temp_field_options  (id,order_id,field_id,option_id,additional_price) values (NULL,'$order_temp_id','$fieldid','$fieldoption','$fee')");
				$db->execute();
			}
		}else{
			$db->setQuery("Delete from #__oscalendar_order_temp_field_options where order_id = '$order_temp_id' and field_id = '$fieldid' and option_id = '$fieldoption'");
			$db->execute();
		}
		
		self::generateSummary($order_temp_id);
	}
	
	/**
	 * Add to cart
	 *
	 */
	static function addtocart($pid,$rid){
		global $mainframe,$cClass,$configClass;
		
		$db = JFactory::getDbo();
		$date_from 			= $mainframe->input->getString('book_from','');
		$date_to   			= $mainframe->input->getString('book_to','');
		$nroom				= $mainframe->input->getInt('nroom',0);
		$adult				= $mainframe->input->getInt('adult',0);
		$child				= $mainframe->input->getInt('child',0);
		
		$db->setQuery("Select pro_type from #__osrs_properties where id = '$pid'");
		$pro_type = $db->loadResult();
		
		$db->setQuery("Select price_type from #__osrs_types where id = '$pro_type'");
		$price_type = $db->loadResult();
		
		//generate user data value
		$userdata = time().rand(11111,99999).$user->id;
		//add booking information into temp database table
		if($price_type == 0){
			$priceInformation = OSCHelper::calSubTotalTypeHoliday($rid,$date_from,$date_to,$nroom);
			$date_from = $priceInformation->price_from;
			$date_to   = $priceInformation->price_to;
		}else{
			$selected_date    = OSCHelper::generateDateArr($date_from,$date_to);
			$priceInformation = OSCHelper::calSubTotalTypeProperty($rid,$selected_date,$nroom);
		}
		//print_r($priceInformation);
		
		$subtotal = $priceInformation->price;
		$curr = $priceInformation->curr;
		$db->setQuery("Insert into #__oscalendar_order_temp (id,user_data,pid,rid,nroom,adult,child,book_from,book_to,sub_total,curr,created_on) values (NULL,'$userdata',$pid,$rid,$nroom,$adult,$child,'$date_from','$date_to','$subtotal','$curr','".time()."')");
		$db->execute();
		$order_temp_id = $db->insertID();
		echo $userdata;
		exit();
	}
}

?>