<?php
/*------------------------------------------------------------------------
# ajax.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;


class HTML_OsCalendarAjax{
	
	/**
	 * Show infor HTML
	 *
	 * @param unknown_type $option
	 * @param unknown_type $lists
	 */
	static function showInforFormHTML($option,$lists){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$user = JFactory::getUser();
		$season_store = $lists['season_store'];
		$property = $lists['property'];
		//print_r($season_store);
		?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_oscalendar&task=form_step1&pid='.$property->id)?>" name="calendarForm" id="calendarForm" class="form-horizontal">
		<div class="row-fluid">
			<div class="span12">
				<div class="componentheading">
					<?php echo JText::_('OS_BOOKING_DETAILS')?>
				</div>
				<div class="clearfix"></div>
				<table class="table table-striped">
					<tr class="row0">
						<td>
							<?php echo JText::_('OS_CALENDAR_CHECK_IN');?>
						</td>
						<td>
							<?php echo OSCHelper::showDateFormat($lists['date_from_int'],1);?>
						</td>
					</tr>
					<tr class="row1">
						<td>
							<?php echo JText::_('OS_CALENDAR_CHECK_OUT');?>
						</td>
						<td>
							<?php echo OSCHelper::showDateFormat($lists['date_to_int'],1);?>
						</td>
					</tr>
					<tr class="row0">
						<td>
							<?php echo JText::_('OS_NUMBER_NIGHTS');?>
						</td>
						<td>
							<?php 
							$nights = round(($lists['date_to_int'] - $lists['date_from_int'])/(24*3600));
							echo $nights;
							?>
						</td>
					</tr>
				<tr class="row<?php echo $k;?>">
					<td style="border-top:1px solid #000 !important;">
						<?php echo JText::_('OS_SUB_TOTAL');?>
					</td>
					<td style="border-top:1px solid #000 !important;">
						<?php 
						echo OSCHelper::showMoney($lists['total'],1);
						?>
					</td>
				</tr>
				<tr class="row0">
					<td style="border-top:1px solid #000 !important;">
						
					</td>
					<td style="border-top:1px solid #000 !important;border-top:1px solid #000 !important;padding:20px;">
						<input type="submit" class="btn btn-info" value="<?php echo JText::_('OS_BOOK_IT')?>" />
					</td>
				</tr>
				</table>
			</div>
		</div>
		<input type="hidden" name="option" 		value="com_oscalendar" />
		<input type="hidden" name="task"   		value="form_step1" />
		<input type="hidden" name="pid"    		id="pid" value="<?php echo $property->id?>" />
		<input type="hidden" name="date_from" 	value="<?php echo $lists['date_from_int']; ?>" />
		<input type="hidden" name="date_to" 	value="<?php echo $lists['date_to_int']; ?>" />
		</form>
		<!--
		<table  width="100%">
			<tr>
				<td width="100%" style="padding:5px;">
					<table  width="100%" class="table table-striped">
						<tr>
							<td width="100%" colspan="2" style="color:gray;font-size:11px;padding:5px;padding-left:0px;">
								<?php echo JText::_('OS_PLEASE_FILL_THE_FORM_BELLOW')?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_CHECK_IN')?>
							</td>
							<td class="infor_right_col">
								<?php echo date("h:i A, l, j F Y",$lists['date_from_int'])?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_CHECK_OUT')?>
							</td>
							<td class="infor_right_col">
								<?php echo date("h:i A, l, j F Y",$lists['date_to_int'])?>
							</td>
						</tr>
						<?php
						$config = $lists['config'];
						$property = $lists['property'];
						if($config->disable_payment == 0){
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_TOTAL')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::calPrice($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_TAX')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::calTax($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_FINAL_COST')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::getFinalCost($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_DEPOSIT')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::calDeposit($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<?php
						}
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_NAME')?>
							</td>
							<td class="infor_right_col">
								<input type="text" class="input-large" size="20" name="order_name" id="order_name" value="<?php echo $user->name; ?>" />
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_EMAIL')?>
							</td>
							<td class="infor_right_col">
								<input type="text" class="input-large" size="20" name="order_email" id="order_email" value="<?php echo $user->email; ?>" />
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_PHONE')?>
							</td>
							<td class="infor_right_col">
								<input type="text" class="input-small" value="" size="10" name="order_phone" id="order_phone">
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_NUMBER_ADULTS')?>
							</td>
							<td class="infor_right_col">
								<?php echo $lists['adults']?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_NUMBER_CHILDRENS')?>
							</td>
							<td class="infor_right_col">
								<?php echo $lists['childs']?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col" valign="top"  style="padding-top:10px;">
								<?php echo JText::_('OS_CALENDAR_NOTES')?>
							</td>
							<td class="infor_right_col">
								<textarea name="order_notes" id="order_notes" class="input-large" cols="40" rows="6"></textarea>
							</td>
						</tr>
						<?php
						if($config->disable_payment == 0){
							$payments = $config->payments;	
							if($payments != ""){
								$paymentsArr = explode(",",$payments);
							}
							if(count($paymentsArr) > 0){
							?>
								<tr>
									<td width="30%" class="infor_left_col">
										<?php echo JText::_('OS_CALENDAR_PAYMENT')?>
									</td>
									<td class="infor_right_col">
										<?php
										if(count($paymentsArr) == 1){
											?>
											<div style="padding:4px;">
											<input type="radio" name="payment" id="payment" value="<?php echo $paymentsArr[0]?>"  onclick="javascript:updatePayment('<?php echo $paymentsArr[0]?>')"  checked>
											&nbsp;
											<?php
											$payment_name = $paymentsArr[0];
											if(file_exists(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php")){
												require_once(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php");
												$payment = new $payment_name();
												echo $payment->_name;
											}
											?>
											</div>
											<input type="hidden" name="select_payment" id="select_payment" value="<?php echo $paymentsArr[0]?>">
											<?php
										}else{
											for($i=0;$i<count($paymentsArr);$i++){
												?>
												<div style="padding:4px;">
												<input type="radio" name="payment" id="payment" value="<?php echo $paymentsArr[$i]?>"  onclick="javascript:updatePayment('<?php echo $paymentsArr[$i]?>')">
												&nbsp;
												<?php
												$payment_name = $paymentsArr[$i];
												if(file_exists(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php")){
													require_once(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php");
													$payment = new $payment_name();
													echo $payment->_name;
												}
												?>
												</div>
												<?php
											}
											?>
											<input type="hidden" name="select_payment" id="select_payment" value="" />
											<?php
										}
										?>
									</td>
								</tr>
							<?php
							}
						}
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_CAPCHA')?>
							</td>
							<td class="infor_right_col">
								<?php
								$resultStr = md5(OSCHelper::getRealTime());// md5 to generate the random string
								$resultStr = substr($resultStr,0,5);//trim 5 digit 
								?>
								<img src="<?php echo JURI::root()?>index.php?option=com_oscalendar&no_html=1&task=ajax_captcha&resultStr=<?php echo $resultStr?>"> 
								<input type="text" class="input-small" id="security_code" name="security_code" maxlength="5" style="width: 50px; margin: 0;" class="inputbox"/>
								<input type="hidden" name="resultStr" id="resultStr" value="<?php echo $resultStr?>" />
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<input type="button" class="btn btn-info" value="Submit" onclick="javascript:confirmBooking(<?php echo $property->id?>)">
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		-->
		<?php
	}
	
	static function confirmInforFormHTML($option,$lists){
		global $mainframe,$configClass;
		?>
		<table  width="100%">
			<tr>
				<td width="100%">
					<b><?php echo JText::_('OS_CALENDAR_CONFIRMATION_INFOMATION')?></b>
				</td>
			</tr>
			<tr>
				<td width="100%" style="padding:5px;">
					<table  width="100%" class="table table-striped">
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_BOOKING_FROM')?>
							</td>
							<td class="infor_right_col">
								<?php echo date("h:i A, l, j F Y",$lists['date_from_int']);?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_BOOKING_TO')?>
							</td>
							<td class="infor_right_col">
								<?php echo date("h:i A, l, j F Y",$lists['date_to_int'])?>
							</td>
						</tr>
						<?php
						$config = $lists['config'];
						$property = $lists['property'];
						if($config->disable_payment == 0){
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_TOTAL')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::calPrice($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_TAX')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::calTax($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_FINAL_COST')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::getFinalCost($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_DEPOSIT')?>
							</td>
							<td class="infor_right_col">
								<?php 
								echo HelperOspropertyCommon::loadCurrency($property->curr)." ".HelperOspropertyCommon::showPrice(HelperOScalendarCommon::calDeposit($property->id,date("Y-m-d",$lists['date_from_int']),date("Y-m-d",$lists['date_to_int'])));
								?>
							</td>
						</tr>
						<?php
						}
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_NAME')?>
							</td>
							<td class="infor_right_col">
								<?php
								echo $mainframe->input->getString('order_name','');
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_EMAIL')?>
							</td>
							<td class="infor_right_col">
								<?php
								echo $mainframe->input->getString('order_email','');
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_PHONE')?>
							</td>
							<td class="infor_right_col">
								<?php
								echo $mainframe->input->getString('order_phone','');
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_NUMBER_ADULTS')?>
							</td>
							<td class="infor_right_col">
								<?php
								echo $mainframe->input->getString('nAdults','');
								?>
							</td>
						</tr>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_NUMBER_CHILDRENS')?>
							</td>
							<td class="infor_right_col">
								<?php
								echo $mainframe->input->getString('nChilds','');
								?>
							</td>
						</tr>
						<?php
						$note = $mainframe->input->getString('notes');
						$note = str_replace("(@)","&",$note);
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_NOTES');?>
							</td>
							<td class="infor_right_col">
								<?php
								echo nl2br($note);
								?>
							</td>
						</tr>
						<?php
						if($config->disable_payment == 0){
						?>
						<tr>
							<td width="30%" class="infor_left_col">
								<?php echo JText::_('OS_CALENDAR_PAYMENT');?>
							</td>
							<td class="infor_right_col">
								<?php
								$payment_name = $mainframe->input->getString('payment','');
								if(file_exists(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php")){
									require_once(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."payments".DS.$payment_name.".php");
									$payment = new $payment_name();
									echo $payment->_name;
								}
								?>
								<input type="hidden" name="payment" id="payment" value="<?php echo $payment_name?>">
							</td>
						</tr>
						<?php
						}
						?>
						<tr>
							<td colspan="2">
								<input type="button" class="btn btn-info" value="Back" onclick="javascript:showBookingForm(<?php echo $property->id?>)">
								<input type="button" class="btn btn-warning" value="Confirm" onclick="javascript:createBooking()">
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<!-- hidden tags -->
		<input type="hidden" name="order_name" 	id="order_name" value="<?php echo $mainframe->input->getString('order_name')?>" />
		<input type="hidden" name="order_email" id="order_email" value="<?php echo $mainframe->input->getString('order_email')?>" />
		<input type="hidden" name="order_phone" id="order_phone" value="<?php echo $mainframe->input->getString('order_phone')?>" />
		<input type="hidden" name="nAdults" id="nAdults" value="<?php echo $mainframe->input->getString('nAdults')?>" />
		<input type="hidden" name="nChilds" id="nChilds" value="<?php echo $mainframe->input->getString('nChilds')?>" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $mainframe->input->getInt('pid',0);?>">
		<div style="display:none;">
		<textarea name="notes" id="notes" cols="40" rows="4" class="inputbox"><?php echo $note?></textarea>
		</div>
		<?php
	}
	
	/**
	 * Update cart summary
	 *
	 * @param unknown_type $nights
	 * @param unknown_type $total
	 * @param unknown_type $fieldObj
	 */
	static function updateCartSummary($book_from,$book_to,$total_price,$room,$number_room_booking,$price){
		global $mainframe,$configClass,$cClass;
		?>
		<div class="row-fluid">
			<div class="span12 nomarginleft summary_text">
				<h3>
					<?php echo JText::_('OS_YOUR_RESERVATION_SUMMARY');?>
				</h3>
			</div>
            <?php
            if($cClass['allow_room'] == 1){
            ?>
			<div class="span12 nomarginleft summary_text noleftmargin">
				<div class="span3">
					<?php 
					echo JText::_('OS_PROPERTY');
					?>
				</div>
				<div class="span9 summary_text noleftmargin">
					<?php
					echo $number_room_booking;
					?>
				</div>
			</div>
            <?php } ?>
            <div class="span12 nomarginleft summary_text noleftmargin">
                <div class="span3">
                    <?php
                    echo JText::_('OS_FROM')."/ ".JText::_('OS_TO');
                    ?>
                </div>
                <div class="span9 summary_text noleftmargin">
                    <?php
                    echo $book_from. " ".$book_to;
                    ?>
                </div>
            </div>
			<div class="span12 nomarginleft summary_text noleftmargin">
				<div class="span3">
					<?php 
					echo JText::_('OS_PRICE');
					?>
				</div>
				<div class="span9 summary_text noleftmargin">
					<?php
					echo OSPHelper::generatePrice($price->curr,$total_price);
					?>
				</div>
			</div>
		</div>
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id?>" />
		<input type="hidden" name="price_plan_id" id="price_plan_id" value="<?php echo $price->id?>" />
		<input type="hidden" name="nroom" id="nroom" value="<?php echo $number_room_booking;?>" />
		<?php
	}

	/**
	 * Show price form
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $rid
	 * @param unknown_type $y
	 * @param unknown_type $m
	 */
	static function showPriceForm($pid,$rid,$y,$m,$lists){
		global $mainframe,$configClass,$cClass;
		?>
		<form method="POST" action="<?php echo JURI::root()?>index.php?option=com_oscalendar&task=ajax_showRoomPrice&tmpl=component">
		<div class="row-fluid">
			<div class="span12" style="text-align:center;">
				<strong>
				<?php echo JText::_('OS_FILTER')?>: <?php echo $lists['month']?><?php echo $lists['year']?>
				<input type="submit" class="btn btn-warning" value="<?php echo JText::_('OS_SUBMIT')?>" />
				</strong>
			</div>
			<div class="clearfix"></div>
			<div class="span12" style="margin-left:0px;">
				<?php
				HelperOsCalendarCalendar::showCalendarWithPriceBackend($rid,$pid,$y,$m);
				?>
			</div>
		</div>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="ajax_showRoomPrice" />
		<input type="hidden" name="rid" value="<?php echo $rid?>" />
		<input type="hidden" name="pid" value="<?php echo $pid?>" />
		</form>
		<?php
	}
	
	static function showError($sids){
		?>
		
		<?php
	}
	
	/**
	 * Generate the Summary form
	 *
	 * @param unknown_type $order
	 */
	static function generateSummaryForm($order,$fieldoptions){
		global $mainframe,$cClass,$configClass;
		$total = 0;
		$db = JFactory::getDbo();
		?>
		<div class="row-fluid">
			<div class="span12">
				<table class="table table-striped">
					<thead>
						<tr>
							<th width="5%">
								#
							</th>
							<?php
							if($cClass['enable_tax'] == 1){
							?>
							<th width="60%">
								<?php echo JText::_('OS_ITEM');?>
							</th>
							<th width="20%" class="hidden-phone">
								<?php echo JText::_('OS_GROSS_AMOUNT');?>
							</th>
							<th width="15%">
								<?php echo JText::_('OS_NET_AMOUNT');?>
							</th>
							<?php
							}else{
							?>
							<th width="80%">
								<?php echo JText::_('OS_ITEM');?>
							</th>
							<th width="15%">
								<?php echo JText::_('OS_SUB_TOTAL');?>
							</th>
							<?php
							}
							?>
						</tr>
					</thead>
					<tbody>
						<tr class="row0">
							<td width="5%">
								1
							</td>
							<td>
								<?php
								echo JText::_('OS_BOOK')." ";
								echo $order->pro_name;
                                if ($cClass['allow_room'] == 1) {
                                    echo " > ".$order->room_name;
                                }
								$nights = OSCHelper::calNights(strtotime($order->book_from),strtotime($order->book_to));
								echo ".<BR />".$nights." ".JText::_('OS_NIGHTS')." [".JText::_('OS_FROM').": ".$order->book_from;
								echo JText::_('OS_TO').": ".$order->book_to."]";
								?>
							</td>
							<td class="hidden-phone">
								<?php
								echo OSPHelper::generatePrice($order->curr,$order->sub_total);
								?>
							</td>
							<?php
							if($cClass['enable_tax'] == 1){
							?>
							<td>
								<?php
								$order->sub_total = $order->sub_total + round(($cClass['tax_payment']*$order->sub_total)/100,2);
								echo OSPHelper::generatePrice($order->curr,$order->sub_total);
								?>
							</td>
							<?php
							}
								$total += $order->sub_total;
							?>
						</tr>
						<?php
						$k = 1;
						if(count($fieldoptions) > 0){
							for($i=0;$i<count($fieldoptions);$i++){
								$fieldoption = $fieldoptions[$i];
								?>
								<tr class="row<?php echo $k;?>">
									<td>
										<?php
										echo $i + 2;
										?>
									</td>
									<td>
										<?php
										echo OSPHelper::getLanguageFieldValue($fieldoption,'field_label')." > ".OSPHelper::getLanguageFieldValue($fieldoption,'field_option');
										?>
									</td>
									<td class="hidden-phone">
										<?php
										$db->setQuery("Select field_id from #__oscalendar_field_options where id = '$fieldoption->option_id'");
										$fieldid = $db->loadResult();
										$db->setQuery("Select price_for_order from #__oscalendar_fields where id = '$fieldid'");
										$price_for = $db->loadResult();
										if($price_for == 0){
											$price = $fieldoption->additional_price;
										}else{
											$price = $order->nroom*$fieldoption->additional_price;
										}
                                        if($price < 0){
                                            $price1 = -1*$price;
                                            $sign = "- ";
                                        }else{
											$price1 = $price;
                                            $sign = "";
                                        }
										echo $sign.OSPHelper::generatePrice($order->curr,$price1);
										?>
									</td>
									<?php
									if($cClass['enable_tax'] == 1){
									?>
									<td>
										<?php
										$db->setQuery("Select price_for_order from #__oscalendar_fields where id = '$fieldid'");
										$price_for = $db->loadResult();
										if($price_for == 0){
											$price = $fieldoption->additional_price;
										}else{
											$price = $order->nroom*$fieldoption->additional_price;
										}
										
										$price = $price + round(($cClass['tax_payment']*$price)/100,2);
                                        if($price < 0){
                                            $price1 = -1*$price;
                                            $sign = "- ";
                                        }else{
											$price1 = $price;
                                            $sign = "";
                                        }
										echo $sign.OSPHelper::generatePrice($order->curr,$price1);
										?>
									</td>
									<?php
									}
									$total += $price;
									?>
								</tr>
								<?php
								$k = 1 - $k;
							}
						}
						?>
						
					</tbody>
					<tfoot>
						<tr>
							<?php
							if($cClass['enable_tax'] == 1){
								$colspan = 2;
							}else{
								$colspan = 1;
							}
							?>
							<td colspan="<?php echo $colspan;?>">
								<strong>
								<?php
								echo JText::_('OS_TOTAL');
								?>
								</strong>
							</td>
							<td class="hidden-phone">
							</td>
							<td>
								<?php
								echo OSPHelper::generatePrice($order->curr,$total);
								?>
							</td>
						</tr>
					</tfoot>
				</table>
			</div>
		</div>
		<?php
	}
}

?>