<?php
namespace JExtstore\Component\JMap\Site\View\Viewer;
/**
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage views
 * @subpackage viewer
 * @author Joomla! Extensions Store
 * @copyright (C) 2025 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Registry\Registry;
use Joomla\String\StringHelper;
use JExtstore\Component\JMap\Administrator\Framework\Language\Multilang;
use JExtstore\Component\JMap\Administrator\Framework\View as JMapView;

/**
 * Main view class
 *
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage views
 * @subpackage sitemap
 * @since 4.27
 */
class HtmlView extends JMapView {
	// Template view variables
	protected $xmlUrl;
	protected $xslt;
	protected $cparams;
	protected $scriptsLoading;
	
	/**
	 * Display the sitemap
	 * @access public
	 * @return void
	 */
	public function display($tpl = null) {
		// App alias
		$app = $this->app;
		$app->setTemplate('system');
		$menu = $app->getMenu ();
		
		$this->menuname = $menu->getActive ();
		$this->cparams = $this->getModel ()->getComponentParams();
		if (isset ( $this->menuname )) {
			$this->menuname = $this->menuname->title;
		}
		$this->scriptsLoading = $this->cparams->get('loadasyncscripts', 0) ? true : false;

		$langQueryParam = '';
		$lang = $app->getInput()->getCmd('lang');
		if($lang) {
			// Split language if ISO format
			if(StringHelper::strpos($lang, '-') !== false) {
				$lang = MultiLang::loadLanguageSEF($lang);
			}
			$langQueryParam = '&lang=' . $lang;
		}
		$this->xslt = $app->getInput()->getCmd('xslt', 'xml');
		
		// Allowed formats (hard safety)
		$allowedFormats = [ 
				'xml',
				'images',
				'gnews',
				'mobile',
				'videos',
				'hreflang',
				'amp'
		];

		$format = in_array ( $this->xslt, $allowedFormats, true ) ? $this->xslt : 'xml';
		
		// Call by cache handler get no params, so recover from model state
		if(!$tpl) {
			$tpl = $format;
		}
		
		// URL XML reale
		$this->xmlUrl = Uri::root() . 'index.php?option=com_jmap&view=sitemap&format=' . $format . $langQueryParam;
		
		// Add the original component script
		$this->document->addScriptOptions('jmapViewer', [
				'xmlUrl' => $this->xmlUrl,
				'format' => $this->xslt,
				'labelTotalURLs' => Text::_('COM_JMAP_VIEWER_TOTAL_URLS'),
				'labelTotalImages' => Text::_('COM_JMAP_VIEWER_TOTAL_IMAGES'),
				'labelTotalVideos' => Text::_('COM_JMAP_VIEWER_TOTAL_VIDEOS'),
				'imagesCrawlingMessage' => Text::_('COM_JMAP_VIEWER_IMAGES_SITEMAP_CRAWLING'),
				'videosCrawlingMessage' => Text::_('COM_JMAP_VIEWER_VIDEOS_SITEMAP_CRAWLING'),
		]);
		
		$this->document->getWebAssetManager()->useScript('jquery');
		$this->document->getWebAssetManager()->registerAndUseScript('jmap.chartjs', 'components/com_jmap/js/viewer/chartjs.min.js', [], ['defer'=>$this->scriptsLoading]);
		$this->document->getWebAssetManager()->registerAndUseScript('jmap.tablesorter', 'components/com_jmap/js/viewer/tablesorter/jquery.tablesorter.min.js', [], ['defer'=>$this->scriptsLoading]);
		$this->document->getWebAssetManager()->registerAndUseScript('jmap.xmlviewerjs', 'components/com_jmap/js/viewer/xmlviewer.js', [], ['defer'=>$this->scriptsLoading]);
		$this->document->getWebAssetManager()->registerAndUseStyle ('jmap.xmlviewercss', 'components/com_jmap/js/viewer/xmlviewer.css');
		
		$uriInstance = Uri::getInstance();
		if($this->cparams->get('append_livesite', true)) {
			$customHttpPort = trim($this->cparams->get('custom_http_port', ''));
			$getPort = $customHttpPort ? ':' . $customHttpPort : '';
			
			$customDomain = trim($this->cparams->get('custom_sitemap_domain', ''));
			$getDomain = $customDomain ? rtrim($customDomain, '/') : rtrim($uriInstance->getScheme() . '://' . $uriInstance->getHost(), '/');

			$this->liveSite = rtrim($getDomain . $getPort, '/');
		} else {
			$this->liveSite = null;
		}
		
		parent::display ( $tpl );
	}
}