<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

/**
 * Layout variables
 *
 * @var array                 $categories
 * @var array                 $rowStatuses
 * @var array                 $rowPriorities
 * @var bool                  $isCustomer
 * @var \Joomla\CMS\User\User $user
 * @var stdClass              $item
 */

HTMLHelper::_('bootstrap.dropdown');

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
if (Factory::getApplication()->isClient('site'))
{
	$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
}

$btnPrimary    = $bootstrapHelper->getClassMapping('btn btn-primary');
$config        = HelpdeskProHelper::getConfig();
$useBootstrap5 = true;
?>
<div class="btn-toolbar <?php echo $bootstrapHelper->getClassMapping('clearfix'); ?> hdp-toolbar-container hpd-joomla4-container">
	<?php
	if ($user->authorise('helpdeskpro.changeticketcategory', 'com_helpdeskpro') && count($categories) > 1)
	{
	?>
		<div class="btn-group">
			<button class="<?php echo $btnPrimary; ?> dropdown-toggle" data<?php if ($useBootstrap5) echo '-bs'; ?>-toggle="dropdown"><?php echo Text::_('HDP_CHANGE_TICKET_CATEGORY'); ?> <span class="caret"></span></button>
			<ul class="dropdown-menu">
				<?php
				foreach ($categories as $category)
				{
				?>
					<li><a class="dropdown-item" href="javascript:HDP.changeTicketCategory(<?php echo $category->id; ?>)"><?php echo $category->treename; ?></a></li>
				<?php
				}
				?>
			</ul>
		</div>
	<?php
	}

	if ($user->authorise('helpdeskpro.changeticketstatus', 'com_helpdeskpro') && count($rowStatuses) > 1)
	{
	?>
		<div class="btn-group">
			<button class="<?php echo $btnPrimary; ?> dropdown-toggle" data<?php if ($useBootstrap5) echo '-bs'; ?>-toggle="dropdown"><?php echo Text::_('HDP_CHANGE_TICKET_STATUS'); ?> <span class="caret"></span></button>
			<ul class="dropdown-menu">
				<?php
				foreach ($rowStatuses as $rowStatus)
				{
				?>
					<li><a class="dropdown-item" href="javascript:HDP.changeTicketStatus(<?php echo $rowStatus->id; ?>);"><?php echo $rowStatus->title; ?></a></li>
				<?php
				}
				?>
			</ul>
		</div>
	<?php
	}

	if (count($rowPriorities) > 1)
	{
	?>
		<div class="btn-group">
			<button class="<?php echo $btnPrimary; ?> dropdown-toggle" data<?php if ($useBootstrap5) echo '-bs'; ?>-toggle="dropdown"><?php echo Text::_('HDP_CHANGE_TICKET_PRIORITY'); ?> <span class="caret"></span></button>
			<ul class="dropdown-menu">
				<?php
				foreach ($rowPriorities as $rowPriority)
				{
				?>
					<li><a class="dropdown-item" href="javascript:HDP.changeTicketPriority(<?php echo $rowPriority->id; ?>)"><?php echo $rowPriority->title; ?></a></li>
				<?php
				}
				?>
			</ul>
		</div>
	<?php
	}

	if ($config->get('enable_rating', 1) && $isCustomer && !$item->rating)
	{
	?>
		<div class="btn-group">
			<button class="<?php echo $btnPrimary; ?> dropdown-toggle" data<?php if ($useBootstrap5) echo '-bs'; ?>-toggle="dropdown"><?php echo Text::_('HDP_TICKET_RATING'); ?> <span class="caret"></span></button>
			<ul class="dropdown-menu">
				<li><a class="dropdown-item" href="javascript:HDP.ticketRating(1)"><?php echo Text::_('HDP_VERY_POOR'); ?></a></li>
				<li><a class="dropdown-item" href="javascript:HDP.ticketRating(2)"><?php echo Text::_('HDP_FAIR'); ?></a></li>
				<li><a class="dropdown-item" href="javascript:HDP.ticketRating(3)"><?php echo Text::_('HDP_AVERAGE'); ?></a></li>
				<li><a class="dropdown-item" href="javascript:HDP.ticketRating(4)"><?php echo Text::_('HDP_GOOD'); ?></a></li>
				<li><a class="dropdown-item" href="javascript:HDP.ticketRating(5)"><?php echo Text::_('HDP_EXCELLENT'); ?></a></li>
			</ul>
		</div>
	<?php
	}

	if (!empty($rowLabels))
	{
	?>
		<div class="btn-group">
			<button class="<?php echo $btnPrimary; ?> dropdown-toggle" data<?php if ($useBootstrap5) echo '-bs'; ?>-toggle="dropdown"><?php echo Text::_('HDP_APPLY_LABEL'); ?><span class="caret"></span></button>
			<ul class="dropdown-menu">
				<li><a class="dropdown-item" href="javascript:HDP.applyTicketLabel(0)"><?php echo Text::_('HDP_NO_LABEL'); ?></a></li>
				<?php
				foreach ($rowLabels as $rowLabel)
				{
				?>
					<li><a class="dropdown-item" href="javascript:HDP.applyTicketLabel(<?php echo $rowLabel->id; ?>)"><?php echo $rowLabel->title; ?></a></li>
				<?php
				}
				?>
			</ul>
		</div>
	<?php
	}

	if (!empty($convertToKb))
	{
	?>
		<div class="btn-group">
			<input type="button" class="<?php echo $bootstrapHelper->getClassMapping('btn'); ?> btn-success" value="<?php echo Text::_('HDP_CONVERT_TO_KB'); ?>" onclick="HDP.convertToArticle(this.form)" style="margin-left:20px;" />
		</div>
	<?php
	}
	?>
</div>
