<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

$config = HelpdeskProHelper::getConfig();

$allowedExtensions = $config->allowed_file_types ?: 'doc|docx|ppt|pptx|pdf|zip|rar|bmp|gif|jpg|jepg|png|swf|zipx';
$maxNumberOfFiles  = (int) $config->max_number_attachments ?: 1;

$allowedExtensions = explode('|', $allowedExtensions);

for ($i = 0, $n = count($allowedExtensions); $i < $n; $i++)
{
	$allowedExtensions[$i] = '.' . strtolower(trim($allowedExtensions[$i]));
}

$token       = Session::getFormToken() . '=' . 1;
$maxFileSize = 'null';

if ($config->max_file_size > 0)
{
	switch ($config->max_filesize_type)
	{
		case 1:
			$maxFileSize = (int) ($config->max_file_size / 1024 * 1024);
			break;
		case 2:
			$maxFileSize = (int) ($config->max_file_size / 1024);
			break;
		case 3:
			$maxFileSize = (int) $config->max_file_size;
			break;
	}
}

$rootUri      = Uri::root(true);
$assetVersion = HelpdeskProHelper::getInstalledVersion();
Factory::getApplication()
	->getDocument()
	->addScriptOptions('maxFiles', $maxNumberOfFiles)
	->addScriptOptions('acceptedFiles', implode(',', $allowedExtensions))
	->addScriptOptions('maxFilesize', $maxFileSize)
	->addScriptOptions('uploadProcessUrl', Uri::base(true) . '/index.php?option=com_helpdeskpro&task=ticket.upload&' . $token)
	->getWebAssetManager()
	->registerAndUseScript('com_helpdeskpro.ticket-upload-attachments', 'media/com_helpdeskpro/js/ticket-upload-attachments.js', ['version' => $assetVersion]);

Text::script('HDP_DROP_FILES_TO_UPLOAD', true);
Text::script('HDP_PLEASE_WAIT_UNTIL_ALL_FILES_UPLOADED', true);