<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

/**
 * Layout variables
 *
 * @var stdClass $item
 */

$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
$attachmentsPath = JPATH_ROOT . '/media/com_helpdeskpro/attachments';
$rootUri         = Uri::root(true);
$imageFileTypes  = ['gif', 'jpg', 'jpeg', 'png', 'bmp'];
$originalFileNames = explode('|', $item->original_filenames);
$attachments       = explode('|', $item->attachments);
?>
<ul class="hdp-attachments-container">
    <?php
    $i = 0 ;

    foreach ($originalFileNames as $fileName)
    {
	    $actualFileName = $attachments[$i++];

	    if (!file_exists($attachmentsPath . '/' . $actualFileName))
	    {
		    continue;
	    }

	    $icon = substr($fileName, strrpos($fileName, '.') + 1);
	    $icon = strtolower($icon);

	    if (in_array($icon, $imageFileTypes))
	    {
		    $class = ' class="hdp-modal"';
	    }
	    else
	    {
		    $class = '';
	    }

	    if ($icon === 'pdf')
	    {
		    $target = ' target="_blank"';
	    }
	    else
	    {
		    $target = '';
	    }

	    if (!file_exists(JPATH_SITE . "/media/com_helpdeskpro/assets/images/icons/$icon.png"))
	    {
		    $icon = 'default';
	    }
        ?>
        <li>
            <a <?php echo $class; ?> href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename=' . $actualFileName . '&original_filename=' . $fileName); ?>"<?php echo $target; ?>>
                <img height="16" width="16" src="<?php echo $rootUri . "/media/com_helpdeskpro/assets/images/icons/$icon.png" ?>"/><?php echo $fileName; ?>
            </a>

	        <?php
	            if (HelpdeskProHelper::canDeleteAttachment($item))
		        {
			        if (HelpdeskProHelper::isMessageRecord($item))
			        {
				        $append = '&message_id=' . $item->id;
			        }
			        else
			        {
				        $append = '&ticket_id=' . $item->id;
			        }

			        $append .= '&return=' . base64_encode(Uri::getInstance()->toString()) . '&' . Session::getFormToken() . '=1';
				?>
			        <a class="hpd-delete-attachment_link" href="<?php echo Route::_('index.php?option=com_helpdeskpro' . $append . '&task=ticket.delete_attachment&filename=' . $actualFileName); ?>" onclick="return confirm('<?php echo Text::_('HPD_DELETE_ATTACHMENT_CONFIRM') ?>');">
				        <i class="<?php echo $bootstrapHelper->getClassMapping('icon-remove'); ?>"></i>
			        </a>
	            <?php
		        }
	        ?>
        </li>
        <?php
    }
    ?>
</ul>