<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined( '_JEXEC' ) or die ;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

$ordering = $this->state->filter_order == 'tbl.ordering';

HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', ['html' => true, 'sanitize' => false, 'placement' => 'top']);
$cols = 2;

$centerClass = $this->bootstrapHelper->getClassMapping('center');
$pullLeft    = $this->bootstrapHelper->getClassMapping('pull-left');
$clearFix    = $this->bootstrapHelper->getClassMapping('clearfix');
$config      = HelpdeskProHelper::getConfig();
$role        = HelpdeskProHelper::getUserRole();

// Do not show user column for user, it is useless
if ($role === 'user')
{
	$this->params->set('show_user', 0);
}
?>
<div id="hdp-container" class="hdp-container hpd-joomla4-container">
    <h1 class="hdp-page-title"><?php echo $this->params->get('page_heading') ?: Text::_('HDP_MY_TICKETS'); ?>
	    <?php
	        if (!$this->params->get('enable_export_tickets'))
			{
			?>
				<a class="hpd-add-new-ticket-link" href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.add&Itemid='.$this->Itemid); ?>"><i class="icon-new"></i><?php echo Text::_('HDP_ADD_NEW_TICKET'); ?></a>
	        <?php
	        }
	    ?>
    </h1>
	<?php
	if ($this->params->get('enable_export_tickets'))
	{
	?>
		<div class="btn-toolbar mt-2 mb-2" id="btn-toolbar">
			<?php echo Toolbar::getInstance('toolbar')->render(); ?>
		</div>
	<?php
	}

	if (HelpdeskProHelper::isValidMessage($this->params->get('intro_text')))
	{
	?>
		<div class="hdp-intro-text <?php echo $clearFix; ?>"><?php echo $this->params->get('intro_text'); ?></div>
	<?php
	}
	?>
    <form action="<?php echo Route::_(RouteHelper::getTicketsRoute()); ?>" method="post" name="adminForm" id="adminForm">
        <fieldset class="filters btn-toolbar <?php echo $this->bootstrapHelper->getClassMapping('clearfix'); ?>">
            <div class="filter-search btn-group <?php echo $pullLeft; ?>">
                <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->filter_search); ?>" class="form-control hasTooltip" title="<?php echo HTMLHelper::tooltipText('HDP_FILTER_SEARCH_TICKETS_DESC'); ?>" />
            </div>
            <div class="btn-group <?php echo $this->bootstrapHelper->getClassMapping('pull-left'); ?>">
                <button type="submit" class="btn btn-primary hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><span class="<?php echo $this->bootstrapHelper->getClassMapping('icon-search'); ?>"></span></button>
                <button type="button" class="btn btn-primary hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><span class="<?php echo $this->bootstrapHelper->getClassMapping('icon-remove'); ?>"></span></button>
            </div>
            <div class="btn-group <?php echo $pullLeft; ?>">
				<?php
				echo $this->lists['filter_category_id'];

				if (isset($this->lists['filter_status_id']))
				{
					echo $this->lists['filter_status_id'];
				}

				if (isset($this->lists['filter_priority_id']))
				{
					echo $this->lists['filter_priority_id'];
				}

				if (isset($this->lists['filter_staff_id']))
				{
					echo $this->lists['filter_staff_id'];
				}

				// Display filterable custom field filters
				foreach ($this->filterableFields as $filterableField)
				{
					if (isset($this->lists['filter_field_' . $filterableField->id]))
					{
						echo $this->lists['filter_field_' . $filterableField->id];
					}
				}
				?>
            </div>
        </fieldset>
        <table class="<?php echo $this->bootstrapHelper->getClassMapping('table table-striped table-bordered'); ?> table-hover">
            <thead>
            <tr>
                <th style="text-align: left;">
					<?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_TITLE'), 'tbl.subject', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                </th>
	            <?php
                if ($this->params->get('show_user', 1))
                {
					$cols++;
				?>
                    <th class="title" style="text-align: left;">
                        <?php echo HTMLHelper::_('grid.sort', Text::_('HDP_USER'), 'tbl.name', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                    </th>
                <?php
                }

				foreach ($this->fields as $field)
				{
				    $cols++;
				?>
                    <th>
                        <?php
                        if ($field->is_searchable)
                        {
	                        echo HTMLHelper::_('grid.sort', Text::_($field->title), 'tbl.' . $field->name, $this->state->filter_order_Dir, $this->state->filter_order);
                        }
                        else
                        {
	                        echo $field->title;
                        }
                        ?>
                    </th>
				<?php
				}

				if ($this->params->get('show_created_date', 1))
                {
					$cols++;
				?>
                    <th class="<?php echo $centerClass; ?>">
                        <?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_CREATED_DATE'), 'tbl.created_date', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                    </th>
                <?php
                }

				if ($this->params->get('show_modified_date', 1))
				{
					$cols++;
				?>
					<th class="<?php echo $centerClass; ?>">
                        <?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_MODIFIED_DATE'), 'tbl.modified_date', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
					</th>
                <?php
				}

				if (isset($this->lists['filter_status_id']) && $this->params->get('show_status', 1))
                {
                    $cols++;
                ?>
                    <th width="8%">
                        <?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_STATUS'), 'tbl.status_id', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                    </th>
                <?php
                }

                if (isset($this->lists['filter_priority_id']) && $this->params->get('show_priority', 1))
                {
                    $cols++;
                ?>
                    <th width="8%">
                        <?php echo HTMLHelper::_('grid.sort', Text::_('HDP_PRIORITY'), 'tbl.priority_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                    </th>
                <?php
                }

                if (!empty($this->showStaffColumn) && $this->params->get('show_staff', 1))
				{
					$cols++;
				?>
                    <th width="10%">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_ASSIGNED_TO'), 'tbl.staff_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                    </th>
				<?php
				}
				?>
                <th width="2%" class="<?php echo $centerClass; ?>">
					<?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_ID'), 'tbl.id', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                </th>
            </tr>
            </thead>
            <?php
                if ($this->pagination->total > $this->pagination->limit)
                {
                ?>
                    <tfoot>
                        <tr>
                            <td colspan="<?php echo $cols + count($this->fields); ?>">
                                <div class="pagination"><?php echo $this->pagination->getListFooter(); ?></div>
                            </td>
                        </tr>
                    </tfoot>
                <?php
                }
            ?>
            <tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $this->items ); $i < $n; $i++)
			{
				$row  = $this->items[$i];
				$link = Route::_(RouteHelper::getTicketRoute($row->id), false);

				if (!$row->staff_id)
				{
					$assignTicketClass = ' hdp-ticket-unassigned';
				}
				else
				{
					$assignTicketClass = '';
				}
				?>
                <tr class="<?php echo "row$k"; ?> hdp-ticket-status-<?php echo $row->status_id . $assignTicketClass; ?>">
                    <td>
                        <a href="<?php echo $link; ?>"><?php echo $this->escape($row->subject) ; ?></a>
	                    <?php
	                        if ($this->params->get('show_category', 1))
							{
							?>
								<br />
								<small><?php echo Text::_('HDP_CATEGORY'); ?>: <strong><?php echo $row->category_title ; ?></strong></small>
	                        <?php
                            }
	                    ?>
                    </td>
	                <?php
                    if ($this->params->get('show_user', 1))
					{
					?>
						<td>
	                        <span class="submitter_name"><?php echo $row->name; ?>
	                            <?php
	                            if ($row->username)
	                            {
	                            ?>
			                        <span>[<strong><?php echo $row->username; ?></strong>]</span>
	                            <?php
	                            }
	                            ?>
	                        </span>
						</td>
                    <?php
                    }

					foreach ($this->fields as $field)
					{
					    $fieldValue = $this->fieldValues[$row->id][$field->id] ?? '';

						if ($fieldValue && $field->fieldtype == 'Date')
						{
							try
							{
								$fieldValue = HTMLHelper::_('date', $fieldValue, $config->date_format);
							}
							catch (Exception $e)
							{
								// Might happen because date is in wrong format
							}
						}
					?>
                        <td>
							<?php echo $fieldValue;?>
                        </td>
					<?php
					}

					if ($this->params->get('show_created_date', 1))
                    {
					?>
	                    <td class="<?php echo $centerClass; ?>">
                            <?php echo HTMLHelper::_('date', $row->created_date, $this->config->date_format); ?>
	                    </td>
	                <?php
                    }

                    if ($this->params->get('show_modified_date', 1))
                    {
					?>
	                    <td class="<?php echo $centerClass; ?>">
                            <?php echo HTMLHelper::_('date', $row->modified_date, $this->config->date_format); ?>
	                    </td>
	                <?php
                    }

                    if (isset($this->lists['filter_status_id']) && $this->params->get('show_status', 1))
                    {
                    ?>
                        <td>
	                        <?php echo @$this->statusList[$row->status_id]; ?>
                        </td>
                    <?php
                    }

                    if (isset($this->lists['filter_priority_id']) && $this->params->get('show_priority', 1))
                    {
                    ?>
                        <td>
	                        <?php echo $this->priorityList[$row->priority_id] ?? ''; ?>
                        </td>
                    <?php
                    }

                    if (!empty($this->showStaffColumn) && $this->params->get('show_staff', 1))
                    {
                    ?>
                        <td>
                            <?php echo $this->staffs[$row->staff_id] ?? ''; ?>
                        </td>
                    <?php
                    }
					?>
                    <td class="<?php echo $centerClass; ?>">
						<?php echo $row->id; ?>
                    </td>
                </tr>
				<?php
				$k = 1 - $k;
			}
			?>
            </tbody>
        </table>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="filter_order" value="<?php echo $this->state->filter_order; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $this->state->filter_order_Dir; ?>" />
		<?php echo HTMLHelper::_( 'form.token' ); ?>
    </form>
</div>