<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\View\Tickets;

use Exception;
use HelpdeskProHelperBootstrap;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Admin\Model\Tickets;
use OSSolution\HelpdeskPro\Admin\View\Tickets\Common;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

defined('_JEXEC') or die;

/**
 * Class Html
 *
 * @property-read Tickets $model
 */
class Html extends ListView
{
	use Common;

	/**
	 * Active menu item params
	 *
	 * @var Registry
	 */
	protected $params;

	/**
	 * Bootstrap Helper
	 *
	 * @var HelpdeskProHelperBootstrap
	 */
	protected $bootstrapHelper;

	/**
	 * Prepare view data
	 *
	 * @return void
	 * @throws Exception
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		$user = Factory::getApplication()->getIdentity();

		// Require user to login to view tickets
		if (!$user->id)
		{
			$redirectUrl = Route::_(
				'index.php?option=com_users&view=login&return=' . base64_encode(Uri::getInstance()->toString())
			);
			$app         = Factory::getApplication();
			$app->enqueueMessage(Text::_('HDP_PLEASE_LOGIN_TO_CONTINUE'));
			$app->redirect($redirectUrl);
		}

		// Category filter
		$filters = [];

		$role = 'admin';

		if (!$user->authorise('core.admin', 'com_helpdeskpro'))
		{
			$userId = $user->id;
			$email  = $user->email;

			$role = HelpdeskProHelper::getUserRole();

			if ($role === 'manager')
			{
				$managedCategoryIds = HelpdeskProHelper::getTicketCategoryIds($user->username);
				$managedCategoryIds = ArrayHelper::toInteger($managedCategoryIds);

				$conditions = [];

				if (count($managedCategoryIds) > 0)
				{
					$conditions[] = 'id IN (' . implode(',', $managedCategoryIds) . ')';
				}

				$conditions[] = 'id IN (SELECT DISTINCT category_id FROM #__helpdeskpro_tickets AS t WHERE t.staff_id =' . $userId . ')';

				$filters [] = '(' . implode(' OR ', $conditions) . ')';
			}
			elseif ($role == 'staff')
			{
				$filters[] = 'id IN (SELECT DISTINCT category_id FROM #__helpdeskpro_tickets AS t WHERE t.staff_id =' . $userId . ')';
			}
			else
			{
				$db = $this->model->getDbo();

				$filters[] = 'id IN (SELECT DISTINCT category_id FROM #__helpdeskpro_tickets AS t WHERE t.user_id = ' . $userId
					. ' OR t.email = ' . $db->quote($email) . ')';
			}

			$filters[] = '`access` IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')';
		}

		$fieldSuffix = HelpdeskProHelper::getFieldSuffix();

		$rows = HelpdeskProHelperDatabase::getAllCategories('ordering', $filters, $fieldSuffix);

		$this->lists['filter_category_id'] = HelpdeskProHelperHtml::buildCategoryDropdown(
			$this->state->filter_category_id,
			'filter_category_id',
			'class="input-large form-select" onchange="submit();"',
			$rows,
			false
		);

		$this->prepareDisplayData($this->state, $fieldSuffix);

		$active = Factory::getApplication()->getMenu()->getActive();

		if ($active && isset($active->query['view']) && $active->query['view'] === 'tickets')
		{
			$params = $active->getParams();
		}
		else
		{
			$params = new Registry;
		}

		$this->params          = $params;
		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();

		if (!in_array($role, ['admin', 'manage']) && $this->params->get('enable_export_tickets'))
		{
			$this->params->set('enable_export_tickets', 0);
		}

		$this->addToolbar();
	}

	/**
	 * Add toolbar buttons to the view
	 *
	 * @return void
	 */
	protected function addToolbar()
	{
		ToolbarHelper::addNew('ticket.add', Text::_('HDP_SUBMIT_TICKET'));

		if (count($this->items) > 0)
		{
			ToolbarHelper::custom('ticket.export', 'download', 'download', Text::_('HDP_EXPORT_TICKETS'), false);
		}
	}
}