<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

HTMLHelper::_('behavior.keepalive');

$rootUri       = Uri::root(true);
$cbIntegration = file_exists(JPATH_ROOT . '/components/com_comprofiler/comprofiler.php');
$editor        = Editor::getInstance(Factory::getApplication()->get('editor'));
$user          = Factory::getApplication()->getIdentity();

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = $this->bootstrapHelper;
$formHorizontalClass = $bootstrapHelper->getClassMapping('form form-horizontal');
$rowFluidClass       = $bootstrapHelper->getClassMapping('row-fluid');
$controlGroupClass   = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass   = $bootstrapHelper->getClassMapping('control-label');
$controlsClass       = $bootstrapHelper->getClassMapping('controls');
$span4Class          = $bootstrapHelper->getClassMapping('span4');
$span8Class          = $bootstrapHelper->getClassMapping('span8');
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
?>
<div id="hdp-container" class="hdp-container  hpd-joomla4-container">
    <h1 class="hdp-page-title"><?php echo Text::_('HDP_VIEW_TICKET'); ?></h1>
    <div class="<?php echo $rowFluidClass; ?>">
        <div class="<?php echo $span8Class; ?>" id="hdp-left-panel-container">
            <div id="hdp-left-panel">
                <h3 class="hdp-ticket-subject">
                    [#<?php echo $this->item->id ?>] - <?php echo $this->escape($this->item->subject); ?>

                    <?php
                    if (HelpdeskProHelper::canEditTicket($this->item))
                    {
                    ?>
                        <a href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.edit&id=' . $this->item->id . '&Itemid=' . $this->Itemid) ?>"><i class="<?php echo $bootstrapHelper->getClassMapping('icon-edit'); ?>"></i> <?php echo Text::_('HDP_EDIT_TICKET'); ?></a>
                    <?php
                    }
                    ?>
                </h3>
                <?php
                $layoutData = [
                    'item'   => $this->item,
                    'config' => $this->config,
                ];

                echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_detail.php', $layoutData);
                ?>
                <h3 class="hdp-comments-heading"><?php echo Text::_('HDP_COMMENTS'); ?></h3>
                <?php
                if (count($this->messages))
                {
                    // List of comments
                    $layoutData = [
                        'messages'      => $this->messages,
                        'user'          => $user,
                        'cbIntegration' => $cbIntegration,
                        'config'        => $this->config
                    ];

                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_comments.php', $layoutData);
                }
                ?>
            </div>
        </div>
        <div class="<?php echo $span4Class; ?>" id="hdp-right-panel-container">
            <div id="hdp-right-panel">
                <?php
                // Customer information
                $layoutData = [
                    'item'        => $this->item,
                    'fields'      => $this->fields,
                    'fieldValues' => $this->fieldValues,
                    'rootUri'     => $rootUri,
                    'results'     => [],
                ];

                echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_customer_info.php', $layoutData);
                ?>
            </div>
        </div>
    </div>
</div>
<script>
    window.print();
</script>