<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;
use OSSolution\HelpdeskPro\Site\Helper\Route as HelpdeskProHelperRoute;

$app = Factory::getApplication();

$editor = Editor::getInstance($app->get('editor'));

$wa = $app->getDocument()
	->addScriptOptions('ticketsUrl', Route::_(HelpdeskProHelperRoute::getTicketRoute($this->item->id), false))
	->getWebAssetManager()
	->useScript('keepalive');

OSSolution\HelpdeskPro\Site\Helper\Jquery::validateForm();

$assetVersion = HelpdeskProHelper::getInstalledVersion();

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$wa->registerAndUseScript('com_helpdeskpro.helpdeskpro.bbcode', 'media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js', ['version' => $assetVersion]);
}

$wa->registerAndUseScript('com_helpdeskpro.admin-ticket-form', 'media/com_helpdeskpro/js/admin-ticket-form.js', ['version' => $assetVersion]);

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = $this->bootstrapHelper;
$formHorizontalClass = $bootstrapHelper->getClassMapping('form form-horizontal');
$controlGroupClass   = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass   = $bootstrapHelper->getClassMapping('control-label');
$controlsClass       = $bootstrapHelper->getClassMapping('controls');
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
?>
<div class="hdp-container hpd-joomla4-container">
	<form class="<?php echo $formHorizontalClass; ?>>" name="adminForm" id="adminForm" action="<?php echo Route::_('index.php?option=com_helpdeskpro&Itemid=' . $this->Itemid) ?>" method="post"
	      enctype="multipart/form-data">
		<?php
		if (!$this->item->user_id)
		{
		?>
			<div class="<?php echo $controlGroupClass; ?>">
				<div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_NAME'); ?><span class="required">*</span></div>
				<div class="<?php echo $controlsClass; ?>">
					<input type="text" id="name" name="name" placeholder="<?php echo Text::_('HDP_CUSTOMER_NAME'); ?>" value="<?php echo $this->item->name; ?>" class="form-control uk-input validate[required]"/>
				</div>
			</div>
			<div class="<?php echo $controlGroupClass; ?>">
				<div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_EMAIL'); ?><span class="required">*</span></div>
				<div class="<?php echo $controlsClass; ?>">
					<input type="text" id="email" name="email" placeholder="<?php echo Text::_('HDP_CUSTOMER_EMAIL'); ?>" value="<?php echo $this->item->email; ?>" class="form-control uk-input validate[required,custom[email]]"/>
				</div>
			</div>
		<?php
		}
		?>
		<div class="<?php echo $controlGroupClass; ?>">
			<div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_CATEGORY'); ?><span
					class="required">*</span></div>
			<div class="<?php echo $controlsClass; ?>">
				<?php echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['category_id']); ?>
			</div>
		</div>
		<div class="<?php echo $controlGroupClass; ?>">
			<div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_SUBJECT'); ?><span
					class="required">*</span></div>
			<div class="<?php echo $controlsClass; ?>">
				<input type="text" id="subject" name="subject" class="form-control uk-input validate[required]" value="<?php echo htmlspecialchars($this->item->subject, ENT_COMPAT, 'UTF-8'); ?>" size="50"/>
			</div>
		</div>

		<?php
		if (isset($this->lists['priority_id']))
		{
		?>
			<div class="<?php echo $controlGroupClass; ?>">
				<div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_PRIORITY'); ?><span
						class="required">*</span></div>
				<div class="<?php echo $controlsClass; ?>">
					<?php echo $this->lists['priority_id']; ?>
				</div>
			</div>
		<?php
		}
		
		$fields = $this->form->getFields();

		/* @var HDPFormField $field*/
		foreach ($fields as $field)
		{
			echo $field->getControlGroup(true, $this->bootstrapHelper);
		}
		?>
		<div class="<?php echo $controlGroupClass; ?>">
			<div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_MESSAGE'); ?><span class="required">*</span></div>
			<div class="<?php echo $controlsClass; ?>">
				<?php
				if ($this->config->use_html_editor)
				{
					echo $editor->display('message', $this->item->message, '100%', '250', '75', '10', false);
				}
				else
				{
				?>
					<textarea rows="10" cols="70" name="message" class="hdp_fullwidth form-control uk-textarea validate[required]"><?php echo htmlspecialchars($this->item->message, ENT_COMPAT, 'UTF-8'); ?></textarea>
				<?php
				}
				?>
			</div>
		</div>

		<?php echo $this->loadCommonLayout('captcha'); ?>

		<div class="form-actions">
			<input type="submit" name="btnSubmit" id="btnSubmitButton" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_SAVE'); ?>" />
			<input type="button" name="btnSubmit" id="btnCancelButton" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_CANCEL'); ?>" onclick="HDP.ticketList();"/>
		</div>
		<input type="hidden" name="option" value="com_helpdeskpro"/>
		<input type="hidden" name="task" value="ticket.save"/>
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>