<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

HTMLHelper::_('behavior.keepalive');

$rootUri  = Uri::root(true);

$cbIntegration = file_exists(JPATH_ROOT . '/components/com_comprofiler/comprofiler.php');
$editor        = Editor::getInstance(Factory::getApplication()->get('editor'));
$user          = Factory::getApplication()->getIdentity();

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = $this->bootstrapHelper;
$formHorizontalClass = $bootstrapHelper->getClassMapping('form form-horizontal');
$rowFluidClass       = $bootstrapHelper->getClassMapping('row-fluid');
$controlGroupClass   = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass   = $bootstrapHelper->getClassMapping('control-label');
$controlsClass       = $bootstrapHelper->getClassMapping('controls');
$span4Class          = $bootstrapHelper->getClassMapping('span4');
$span8Class          = $bootstrapHelper->getClassMapping('span8');
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
?>
<div id="hdp-container" class="hdp-container  hpd-joomla4-container">
    <h1 class="hdp-page-title"><?php echo Text::_('HDP_VIEW_TICKET'); ?></h1>
    <form action="<?php echo Route::_('index.php?option=com_helpdeskpro&view=ticket&Itemid='.$this->Itemid); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
        <!--Toolbar buttons-->
        <?php
            $layoutData = [
                'categories'    => $this->categories,
                'rowStatuses'   => $this->rowStatuses,
                'rowPriorities' => $this->rowPriorities,
                'isCustomer'    => $this->isCustomer,
                'item'          => $this->item,
                'user'          => $user,
            ];

            echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/toolbar.php', $layoutData);
        ?>
        <div class="<?php echo $rowFluidClass; ?>">
            <div class="<?php echo $span8Class; ?>" id="hdp-left-panel-container">
                <div id="hdp-left-panel">
                    <h3 class="hdp-ticket-subject">
                        [#<?php echo $this->item->id ?>] - <?php echo $this->escape($this->item->subject); ?>

                        <?php
                            if (HelpdeskProHelper::canEditTicket($this->item))
                            {
                            ?>
                                <a href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.edit&id=' . $this->item->id . '&Itemid=' . $this->Itemid) ?>"><i class="<?php echo $bootstrapHelper->getClassMapping('icon-edit'); ?>"></i> <?php echo Text::_('HDP_EDIT_TICKET'); ?></a>
                            <?php
                            }
                        ?>
                    </h3>
                    <?php
                    $layoutData = [
	                    'item'   => $this->item,
	                    'config' => $this->config,
                    ];

                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_detail.php', $layoutData);
                    ?>
                    <h3 class="hdp-comments-heading"><?php echo Text::_('HDP_COMMENTS'); ?>
                        <?php
                        if ($this->canComment)
                        {
                        ?>
                            <a id="hdp-add-comment-link" href="javascript:HDP.showMessageBox();" class="<?php echo $bootstrapHelper->getClassMapping('pull-right'); ?>">
                                <i class="<?php echo $bootstrapHelper->getClassMapping('icon-plus'); ?>"></i>
                                <span><?php echo Text::_('HDP_ADD_COMMENT'); ?></span>
                            </a>
                        <?php
                        }
                        ?>
                    </h3>
                    <?php

                    if ($this->canComment)
                    {
	                    $layoutData = [
		                    'canComment'     => $this->canComment,
		                    'captchaInvalid' => $this->captchaInvalid,
		                    'config'         => $this->config,
		                    'rootUri'        => $rootUri,
		                    'editor'         => $editor,
		                    'message'        => $this->message,
		                    'captcha'        => $this->captcha ?? '',
		                    'captchaPlugin' => $this->captchaPlugin ?? '',
	                    ];

                        // Comment form
                        echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_add_comment.php', $layoutData);
                    }

                    if (count($this->messages))
                    {
                        // List of comments
	                    $layoutData = [
		                    'item'          => $this->item,
		                    'messages'      => $this->messages,
		                    'user'          => $user,
		                    'cbIntegration' => $cbIntegration,
		                    'config'        => $this->config,
	                    ];

                        echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_comments.php', $layoutData);
                    }
                    ?>
                </div>
            </div>
            <div class="<?php echo $span4Class; ?>" id="hdp-right-panel-container">
                <div id="hdp-right-panel">
                    <?php
                        // Customer information
	                    $layoutData = [
		                    'item'           => $this->item,
		                    'fields'         => $this->fields,
		                    'fieldValues'    => $this->fieldValues,
		                    'rootUri'        => $rootUri,
		                    'results'        => $this->results,
		                    'hiddenFieldIds' => $this->hiddenFieldIds,
		                    'hasStatuses'    => count($this->rowStatuses) > 0,
		                    'hasPriorities'  => count($this->rowPriorities) > 0,
	                    ];

                        echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_customer_info.php', $layoutData);
                    ?>
                </div>
            </div>
        </div>
        <input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="new_value" value="0" />
        <input type="hidden" name="Itemid" value="<?php echo $this->Itemid; ?>" />
	    <input type="text" name="<?php echo $this->config->get('honeypot_fieldname', 'hdp_my_own_website_name'); ?>" value="" autocomplete="off" class="<?php echo $this->config->get('honeypot_field_css_class', 'hpp-invisible-to-visitors'); ?>" />
        <?php
            if ($this->item->is_ticket_code)
            {
            ?>
                <input type="hidden" name="ticket_code" value="<?php echo $this->item->ticket_code ?>" />
            <?php
            }

            echo HTMLHelper::_( 'form.token' );
        ?>
    </form>
</div>