<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined( '_JEXEC' ) or die ;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();

$params        = $this->params;
$numberColumns = $params->get('number_columns', 2);
$spanClass     = 'span' . intval(12 / $numberColumns);
$spanClass     = $bootstrapHelper->getClassMapping($spanClass);
$clearFix      = $bootstrapHelper->getClassMapping('clearfix');
$rowFluid      = $bootstrapHelper->getClassMapping('row-fluid');
?>
<div id="hdp-container" class="hdp-container">
	<h1 class="hdp-page-title"><?php echo Text::_('HDP_ARTICLE_CATEGORIES'); ?></h1>
	<div class="hdp-categories-list <?php echo $clearFix; ?>">
		<div class="<?php echo $rowFluid; ?>">
			<?php
			$i = 0;
			$numberCategories = count($this->items);

			foreach ($this->items as $item)
			{
				$i++;
				$link = Route::_(RouteHelper::getArticlesRoute($item->id, $this->Itemid, Factory::getLanguage()->getTag()));
			?>
				<div class="hpd-category-wrapper <?php echo $spanClass; ?>">
					<h3>
						<i class="icon-folder-open"></i><a title="<?php echo Text::sprintf('HDP_VIEW_ALL_ARTICLES_IN_CATEGORY', $item->title);?>" href="<?php echo $link; ?>"><?php echo $item->title; ?></a><span class="hdp-articles-count badge badge-info"><?php echo $item->total_articles; ?></span>
					</h3>
					<?php 
						if ($item->description)
						{
						?>
							<div class="hdp-category-description clearfix"><?php echo $item->description; ?></div>
						<?php			
						}
					?>
					<ul class="hp-category-articles">
						<?php
							foreach($item->articles as $article)
							{
							?>
								<li class="hdp-article">
									<i class="icon-list-alt"></i><a title="<?php echo $article->title; ?>" href="<?php echo Route::_(RouteHelper::getArticleRoute($article->id, $article->category_id, $this->Itemid, Factory::getLanguage()->getTag()));?>"><?php echo $article->title; ?></a>
								</li>
							<?php
							}
						?>
					</ul>
				</div>
				<?php
				if ($i % $numberColumns == 0 && $i < $numberCategories)
				{
				?>
					</div>
                    <div class="<?php echo $clearFix . ' ' . $rowFluid; ?>">
				<?php
				}
			}
			?>
		</div>
	</div>
</div>