<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\View\Articles;

use HelpdeskProHelperBootstrap;
use Joomla\CMS\Factory;
use OSL\Utils\Database as DatabaseUtils;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

defined('_JEXEC') or die;

class Html extends ListView
{
	/**
	 * Bootstrap Helper
	 *
	 * @var HelpdeskProHelperBootstrap
	 */
	protected $bootstrapHelper;

	/**
	 * Prepare view data
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		// Add articles to route
		RouteHelper::addArticles($this->items);

		$fieldSuffix = HelpdeskProHelper::getFieldSuffix();

		$filters = [];

		$user = Factory::getApplication()->getIdentity();

		if (!$user->authorise('core.admin', 'com_helpdeskpro'))
		{
			$filters[] = '`access` IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')';
		}

		$rows = HelpdeskProHelperDatabase::getAllCategories('title', $filters, $fieldSuffix, 2);

		$this->lists['id'] = HelpdeskProHelperHtml::buildCategoryDropdown(
			$this->state->id,
			'id',
			'class="input-large form-select" onchange="submit();"',
			$rows
		);

		// Handle page title
		$active = Factory::getApplication()->getMenu()->getActive();
		$params = HelpdeskProHelperHtml::getViewParams($active, ['categories', 'articles']);

		$category = null;

		if ($this->state->filter_category_id)
		{
			$db    = $this->model->getDbo();
			$query = $db->getQuery(true);
			$query->select('title')
				->from('#__helpdeskpro_categories')
				->where('id = ' . $this->state->filter_category_id);

			if ($fieldSuffix)
			{
				DatabaseUtils::getMultilingualFields($query, ['title'], $fieldSuffix);
			}

			$db->setQuery($query);
			$categoryTitle = $db->loadResult();

			if (!$params->get('page_title') && $categoryTitle)
			{
				$params->set('page_title', $categoryTitle);
			}

			// Pathway
			$pathway = Factory::getApplication()->getPathway();
			$pathway->addItem($categoryTitle);
		}

		HelpdeskProHelperHtml::prepareDocument($params);

		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
	}
}