<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\View\Article;

use Exception;
use HelpdeskProHelperBootstrap;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSL\Utils\Database as DatabaseUtils;
use OSL\View\HtmlView;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;
use OSSolution\HelpdeskPro\Site\Model\Article;
use stdClass;

defined('_JEXEC') or die;

/**
 * Class Html
 *
 * @property Article $model
 */
class Html extends HtmlView
{
	/**
	 * Ticket data
	 *
	 * @var stdClass
	 */
	protected $item;

	/**
	 * Bootstrap Helper
	 *
	 * @var HelpdeskProHelperBootstrap
	 */
	protected $bootstrapHelper;

	/**
	 * Prepare data
	 *
	 * @return void
	 * @throws Exception
	 */
	protected function beforeRender()
	{
		$this->item = $this->model->getData();

		if (empty($this->item->id))
		{
			throw new Exception(Text::_('HDP_ARTICLE_NOT_FOUND'), 404);
		}

		$config = HelpdeskProHelper::getConfig();

		// Update hits
		$this->model->hits();

		if ($config->highlight_code)
		{
			HelpdeskProHelper::loadHighlighter();
		}

		// Pathway
		$pathway = Factory::getApplication()->getPathway();

		// Get category title
		$fieldSuffix = HelpdeskProHelper::getFieldSuffix();

		$db = $this->model->getDbo();
		$query = $db->getQuery(true)
			->select('title')
			->from('#__helpdeskpro_categories')
			->where('id = ' . $this->item->category_id);

		if ($fieldSuffix)
		{
			DatabaseUtils::getMultilingualFields($query, ['title'], $fieldSuffix);
		}
		$db->setQuery($query);
		$categoryTitle = $db->loadResult();
		$pathway->addItem(
			$categoryTitle,
			Route::_(
				'index.php?option=com_helpdeskpro&view=articles&filter_category_id=' . $this->item->category_id . '&Itemid=' . $this->Itemid
			)
		);
		$pathway->addItem($this->item->title);

		// Handle page title
		$active = Factory::getApplication()->getMenu()->getActive();
		$params = HelpdeskProHelperHtml::getViewParams($active, ['categories', 'articles', 'article']);

		if (!$params->get('page_title'))
		{
			$params->set('page_title', $this->item->title);
		}

		HelpdeskProHelperHtml::prepareDocument($params, $this->item);

		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
	}
}