<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Model;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseQuery;
use OSL\Model\ListModel;
use OSL\Utils\Database as DatabaseUtils;
use Ossolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

class Categories extends ListModel
{

	/**
	 * Clear join clause for getTotal method
	 *
	 * @var bool
	 */
	protected $clearJoin = false;

	/**
	 * Build the query object which is used to get list of records from database
	 *
	 * @return DatabaseQuery
	 */
	protected function buildListQuery()
	{
		$query = parent::buildListQuery();

		$query->select('COUNT(b.id) AS total_articles')
			->innerJoin('#__helpdeskpro_articles AS b ON tbl.id = b.category_id')
			->where('tbl.published = 1')
			->whereIn('tbl.access', Factory::getApplication()->getIdentity()->getAuthorisedViewLevels())
			->where('b.published = 1')
			->group('tbl.id');

		if ($fieldSuffix = HelpdeskProHelper::getFieldSuffix())
		{
			DatabaseUtils::getMultilingualFields($query, ['tbl.title'], $fieldSuffix);
		}

		return $query;
	}

	/**
	 * Get list of articles belong to each category, max 10 articles per category
	 *
	 * @param   array  $rows
	 */
	protected function beforeReturnData($rows)
	{
		$db          = $this->getDbo();
		$fieldSuffix = HelpdeskProHelper::getFieldSuffix();

		$query = $db->getQuery(true)
			->select('id, category_id, title')
			->from('#__helpdeskpro_articles')
			->order('ordering');

		if ($fieldSuffix)
		{
			DatabaseUtils::getMultilingualFields($query, ['title'], $fieldSuffix);

			$aliasField = $db->quoteName('alias' . $fieldSuffix);
			$query->select("IF(CHAR_LENGTH($aliasField) > 0, $aliasField, alias) AS alias");
		}
		else
		{
			$query->select('alias');
		}

		foreach ($rows as $row)
		{
			$query->where('category_id = ' . $row->id)
				->where('published = 1');
			$db->setQuery($query, 0, 10);
			$row->articles = $db->loadObjectList();

			$query->clear('where');
		}
	}
}