<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Factory;

class HelpdeskProHelperBootstrap
{
	/**
	 * Bootstrap Helper instance
	 *
	 * @var HelpdeskProHelperBootstrap
	 */
	protected static $instance;

	/**
	 * Twitter bootstrap version, default 2
	 * @var string
	 */
	protected $bootstrapVersion;

	/**
	 * UI component
	 *
	 * @var HDPUiInterface
	 */
	protected $ui;

	/**
	 * The class mapping to map between twitter bootstrap 2 and twitter bootstrap 3
	 * @var string
	 */
	protected static $classMaps;

	/**
	 * Get bootstrap helper object
	 *
	 * @return HelpdeskProHelperBootstrap
	 */
	public static function getInstance()
	{
		if (self::$instance === null)
		{
			$config = HelpdeskProHelper::getConfig();

			if (Factory::getApplication()->isClient('administrator'))
			{
				self::$instance = new self('5');
			}
			else
			{
				self::$instance = new self($config->get('twitter_bootstrap_version', 5));
			}
		}

		return static::$instance;
	}

	/**
	 * Constructor, initialize the classmaps array
	 *
	 * @param   string  $ui
	 * @param   array   $classMaps
	 *
	 * @throws Exception
	 */
	public function __construct($ui, $classMaps = [])
	{
		if (empty($ui) || in_array($ui, [2, 3, 4]))
		{
			$ui = 5;
		}

		switch ($ui)
		{
			case 2:
			case 3:
			case 4:
			case 5:
				$uiClass = 'HDPUiBootstrap' . $ui;
				break;
			default:
				$uiClass = 'HDPUi' . ucfirst($ui);
				break;
		}

		$this->bootstrapVersion = $ui;

		if (!class_exists($uiClass))
		{
			throw new Exception(sprintf('UI class %s not found', $uiClass));
		}

		$this->ui = new $uiClass($classMaps);
	}

	/**
	 * Get the mapping of a given class
	 *
	 * @param   string  $class  The input class
	 *
	 * @return string The mapped class
	 */
	public function getClassMapping($class)
	{
		return $this->ui->getClassMapping($class);
	}

	/**
	 * Add class mapping
	 *
	 * @param   string  $class
	 * @param   string  $mappedClass
	 *
	 * @return $this
	 */
	public function addClassMapping($class, $mappedClass)
	{
		$this->ui->addClassMapping($class, $mappedClass);

		return $this;
	}

	/**
	 * Get twitter bootstrap version
	 *
	 * @return int|string
	 */
	public function getBootstrapVersion()
	{
		return $this->bootstrapVersion;
	}

	/**
	 * Method to get input with prepend add-on
	 *
	 * @param   string  $input
	 * @param   string  $addOn
	 *
	 * @return string
	 */
	public function getPrependAddon($input, $addOn)
	{
		return $this->ui->getPrependAddon($input, $addOn);
	}

	/**
	 * Method to get input with append add-on
	 *
	 * @param   string  $input
	 * @param   string  $addOn
	 *
	 * @return string
	 */
	public function getAppendAddon($input, $addOn)
	{
		return $this->ui->getAppendAddon($input, $addOn);
	}

	/**
	 * Get framework own css class
	 *
	 * @param   string  $class
	 * @param   int     $behavior
	 *
	 * @return string
	 */
	public function getFrameworkClass($class, $behavior = 0)
	{
		return $this->ui->getFrameworkClass($class, $behavior);
	}
}