<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class Jquery
{
	/**
	 * validate form
	 */
	public static function validateForm()
	{
		static $loaded = false;

		if (!$loaded)
		{
			$app = Factory::getApplication();
			$wa  = $app->getDocument()
				->getWebAssetManager();

			$wa->registerAndUseStyle(
				'com_helpdeskpro.validationEngine.jquery',
				'media/com_helpdeskpro/assets/js/validate/css/validationEngine.jquery.css'
			)
				->useScript('core');

			// Allow adding custom validation rules
			if (is_file(JPATH_ROOT . '/media/com_helpdeskpro/js/custom_validation_rules.js'))
			{
				$wa->registerAndUseScript(
					'com_helpdeskpro.custom_validation_rules',
					'media/com_helpdeskpro/js/custom_validation_rules.js'
				);
			}

			// Add possible language files for jquery validation engine
			$tag = $app->getLanguage()->getTag();
			$tag = substr($tag, 0, 2);
			$files = [
				"jquery.validationEngine-$tag.custom.js",
				"jquery.validationEngine-$tag.js",
				'jquery.validationEngine-en.js',
			];

			foreach ($files as $file)
			{
				if (file_exists(JPATH_ROOT . '/media/com_helpdeskpro/assets/js/validate/js/languages/' . $file))
				{
					$wa->registerAndUseScript(
						'com_helpdeskpro.' . $file,
						'media/com_helpdeskpro/assets/js/validate/js/languages/' . $file
					);
					break;
				}
			}

			// Add validation engine
			$wa->registerAndUseScript(
				'com_helpdeskpro.jquery.validationEngine',
				'media/com_helpdeskpro/assets/js/validate/js/jquery.validationEngine.js'
			);

			$loaded = true;
		}
	}
}