<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Helper;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

class EmailTags
{
	public static function getCommonTags()
	{
		$tags = [
			'ticket_id',
			'ticket_subject',
			'name',
			'email',
			'staff_name',
			'ticket_message',
			'frontend_link',
			'frontend_link_without_login',
			'backend_link',
			'ticket_category',
			'category_title',
			'ticket_status',
			'ticket_priority',
		];

		/* @var DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('name')
			->from('#__helpdeskpro_fields')
			->where('published = 1')
			->order('ordering');
		$db->setQuery($query);

		$tags = array_merge($tags, $db->loadColumn());

		return array_map('strtoupper', $tags);
	}

	public static function getEmailTags($name)
	{
		static $commonTags;

		if ($commonTags === null)
		{
			$commonTags = self::getCommonTags();
		}

		switch ($name)
		{
			case 'new_ticket_admin_email_subject':
			case 'new_ticket_admin_email_body':
			case 'new_ticket_user_email_subject':
			case 'new_ticket_user_email_body':
				return $commonTags;
			case 'ticket_updated_admin_email_subject':
			case 'ticket_updated_admin_email_body':
				return array_merge(['TICKET_COMMENT'], $commonTags);
			case 'ticket_updated_user_email_subject':
			case 'ticket_updated_user_email_body':
				return array_merge(['MANAGER_NAME', 'TICKET_COMMENT'], $commonTags);
			case 'manager_ticket_closed_email_subject':
			case 'manager_ticket_closed_email_body':
				return $commonTags;
			case 'customer_ticket_closed_email_subject':
			case 'customer_ticket_closed_email_body':
				return array_merge(['MANAGER_NAME'], $commonTags);
			case 'customer_ticket_assigned_email_subject':
			case 'customer_ticket_assigned_email_body':
			case 'ticket_assiged_email_subject':
			case 'ticket_assiged_email_body':
				return array_merge(['MANAGER_NAME'], $commonTags);
			case 'manager_ticket_status_changed_email_subject':
			case 'manager_ticket_status_changed_email_body':
				return array_merge(['OLD_STATUS', 'NEW_STATUS'], $commonTags);
			case 'customer_ticket_status_changed_email_subject':
			case 'customer_ticket_status_changed_email_body':
				return array_merge(['MANAGER_NAME', 'OLD_STATUS', 'NEW_STATUS'], $commonTags);
			case 'internal_comment_added_email_subject':
			case 'internal_comment_added_email_body':
				return array_merge(['USER_USERNAME', 'USER_EMAIL', 'USER_NAME', 'TICKET_COMMENT'], $commonTags);
			default:
				return [];
		}
	}
}