<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Controller;

use Exception;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

class Controller extends \OSL\Controller\Controller
{
	/**
	 * Display information
	 *
	 */
	public function display($cachable = false, array $urlparams = [])
	{
		$wa = $this->app->getDocument()
			->getWebAssetManager();

		$config       = HelpdeskProHelper::getConfig();
		$assetVersion = HelpdeskProHelper::getInstalledVersion();

		// Load part of twitter bootstrap
		if ($config->load_twttier_bootstrap_framework_in_frontend
			&& in_array($config->get('twitter_bootstrap_version', 5), [5]))
		{
			$wa->useStyle('bootstrap.css');
		}

		$viewName = strtolower($this->input->get('view', $this->container->defaultView));

		$wa->registerAndUseStyle('com_helpdeskpro.style', 'media/com_helpdeskpro/assets/css/style.min.css', ['version' => $assetVersion])
			->registerAndUseStyle('com_helpdeskpro.common', 'media/com_helpdeskpro/assets/css/common.min.css', ['version' => $assetVersion]);

		$customCssFile = JPATH_ROOT . '/media/com_helpdeskpro/assets/css/custom.css';

		if (file_exists($customCssFile) && filesize($customCssFile))
		{
			$wa->registerAndUseStyle(
				'com_helpdeskpro.custom',
				'media/com_helpdeskpro/assets/css/custom.css',
				['version' => filemtime($customCssFile)]
			);
		}

		if ($viewName == 'ticket')
		{
			$wa->useScript('core')
				->useScript('jquery')
				->useScript('jquery-noconflict')
				->useScript('bootstrap.dropdown')
				->registerAndUseScript(
					'com_helpdeskpro.helpdeskpro',
					'media/com_helpdeskpro/assets/js/helpdeskpro.min.js',
					['version' => $assetVersion]
				)
				->registerAndUseScript(
					'com_helpdeskpro.dropzone',
					'media/com_helpdeskpro/assets/dropzone/dropzone.min.js'
				)
				->registerAndUseStyle(
					'com_helpdeskpro.dropzone.basic',
					'media/com_helpdeskpro/assets/dropzone/basic.min.css',
					['version' => $assetVersion]
				)
				->registerAndUseStyle(
					'com_helpdeskpro.dropzone.dropzone',
					'media/com_helpdeskpro/assets/dropzone/dropzone.min.css',
					['version' => $assetVersion]
				);
		}

		parent::display($cachable, $urlparams);
	}

	/**
	 * @throws Exception
	 */
	public function get_reply()
	{
		$this->getApplication()->setHeader('Content-Type', 'text/html; charset=UTF-8');

		$replyId = $this->input->getInt('reply_id', 0);

		/* @var DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('message')
			->from('#__helpdeskpro_replies')
			->where('id = ' . $replyId);
		$db->setQuery($query);

		echo $db->loadResult();

		$this->app->close();
	}
}