<?php

/**

 * @package     Lmstarbiats.Site

 * @subpackage  com_ardhs

 *

 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.

 * @license     GNU General Public License version 2 or later; see LICENSE.txt

 */



namespace Abdul\Component\Lmstarbiats\Site\Helper;



defined('_JEXEC') or die;



use Joomla\CMS\Categories\CategoryNode;

use Joomla\CMS\Language\Multilanguage;



/**

 * Lmstarbiats Component Route Helper.

 *

 * @since  1.5

 */

abstract class RouteHelper

{

	/**

	 * Get the article route.

	 *

	 * @param   integer  $id        The route of the content item.

	 * @param   integer  $language  The language code.

	 * @param   string   $layout    The layout value.

	 *

	 * @return  string  The article route.

	 *

	 * @since   1.5

	 */

	public static function getWalkRoute($id, $slug, $language = 0, $layout = null)

	{

		// Create the link

		$link = 'index.php?option=com_ardhs&view=park_exchg_e&id=' . $id . '&slug=' . $slug;



		if ($language && $language !== '*' && Multilanguage::isEnabled())

		{

			$link .= '&lang=' . $language;

		}



		if ($layout)

		{

			$link .= '&layout=' . $layout;

		}



		return $link;

	}



	/**

	 * Get the category route.

	 *

	 * @param   integer  $catid     The category ID.

	 * @param   integer  $language  The language code.

	 * @param   string   $layout    The layout value.

	 *

	 * @return  string  The article route.

	 *

	 * @since   1.5

	 */

	public static function getWalksRoute($language = 0, $layout = null)

	{



		$link = 'index.php?option=com_content&view=lmstarbiats';



		if ($language && $language !== '*' && Multilanguage::isEnabled())

		{

			$link .= '&lang=' . $language;

		}



		if ($layout)

		{

			$link .= '&layout=' . $layout;

		}


		return $link;

	}

}

