<?php



/**

 * @package     Joomla.Administrator

 * @subpackage  com_content

 *

 * @copyright   (C) 2020 Open Source Matters, Inc. <https://www.joomla.org>

 * @license     GNU General Public License version 2 or later; see LICENSE.txt

 */



namespace Abdul\Component\Lmstarbiats\Site\Field;



use Joomla\CMS\Form\Field\ListField;

use Joomla\CMS\Plugin\PluginHelper;

use Joomla\CMS\Factory;

use Joomla\CMS\Form\FormField;

use Joomla\CMS\HTML\HTMLHelper;

use Joomla\CMS\Language\LanguageHelper;

use Joomla\CMS\Language\Text;

use Joomla\CMS\Session\Session;

use Joomla\Database\ParameterType;



// phpcs:disable PSR1.Files.SideEffects

\defined('_JEXEC') or die;

// phpcs:enable PSR1.Files.SideEffects



/**

 * Votelist Field class.

 *

 * @since  4.0.0

 */

class buildinglistField extends FormField

{

    /**

     * The form field type.

     *

     * @var     string

     * @since   1.6

     */

    protected $type = 'Modal_Contact';



    /**

     * Method to get the field input markup.

     *

     * @return  string  The field input markup.

     *

     * @since   1.6

     */

    protected function getInput()

    {

        $allowNew       = ((string) $this->element['new'] == 'true');

        $allowEdit      = ((string) $this->element['edit'] == 'true');

        $allowClear     = ((string) $this->element['clear'] != 'false');

        $allowSelect    = ((string) $this->element['select'] != 'false');

        $allowPropagate = ((string) $this->element['propagate'] == 'true');



        $languages = LanguageHelper::getContentLanguages(array(0, 1), false);



        // Load language

        Factory::getLanguage()->load('com_contact', JPATH_ADMINISTRATOR);



        // The active contact id field.

        $value = (int) $this->value ?: '';



        // Create the modal id.

        $modalId = 'Contact_' . $this->id;



//	echo '<pre>aya: ';print_r($this->value);exit;

/*

echo '<pre>aya: ';print_r($this->element);exit;

$this->element

 [@attributes] => Array

        (

            [name] => user_bldg_code

            [type] => buildinglist

            [label] => Building Code

            [class] => validate-user_bldg_code

            [message] => Building Codenumber required

            [required] => true

            [size] => 30

            [autocomplete] => user_bldg_code

        )

*/

        /** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();



        $db = Factory::getContainer()->get('DatabaseDriver'); //J4 onwards, outside of the		 Model or Table  



		$query="select * from #__px_buildings where bldg_status=1";



		$db->setQuery($query);

		$rows = $db->loadObjectList();

$html='<select id="jform_'.$this->element['name'].'" name="jform['.$this->element['name'].']" class="form-select '.$this->element['class'].'">';



for($i=0;$i<count($rows);$i++) {

	$row=$rows[$i];



	if($row->bldg_code1!="")

		$html.='<option value="'.$row->bldg_code1 .'">'.$row->bldg_name.'</option>';

	

}

$html.='</select>';

//        $class = $this->required ? ' class="required modal-value"' : '';





        return $html;

    }



    /**

     * Method to get the field label markup.

     *

     * @return  string  The field label markup.

     *

     * @since   3.4

     */

    protected function getLabel()

    {

        return str_replace($this->id, $this->id . '_name', parent::getLabel());

    }

}