<?php
/**
 * @package     Ardhs
 * @subpackage  com_ardhs
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Abdul\Component\Ardhs\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;
// Import `ComponentHelper` class.
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;

/**
 * Ardhs list controller class.
 *
 * @since  1.6
 */
class PropsController extends AdminController
{
	public function __construct($config = [], $factory = null, $app = null, $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
		$this->registerTask( 'unpublish'  , 	'unpublish' );
		$this->registerTask( 'getardhs'  , 	'getArdhs' );

    }
	
	public function cropText_mod($text, $maxLength = 70) {
	return (strlen($text) > $maxLength)
	? substr($text, 0, $maxLength - 3) . '...'
	: $text;
	}
	
//	public function getArdhs($limit=12, $offset=1) {
	public function getArdhs() {
		
		$db	 = Factory::getDbo();
		$app = Factory::getApplication();
		$query = $db->getQuery(true);
		$input  = $app->input;
		//$post = $input->post->get('jform', array(), 'array');
		$limit= $input->get('limit', 12, 'INT');
		$limit_start= $input->get('limit_start', 1, 'INT');
		//$num_col = $input->get('num_col',3,'INT');

		$sitebaseurl=Uri::base();//exit;
		
		// Get all params of a specific component.
		$params = ComponentHelper::getParams('com_ardhs');
		
		// To get the value of the param.
		$singlepropmenu = $params->get('singlepropmenu');
		$num_col = $params->get('num_col');

		$status= $input->get('status', "", 'STRING');
		$proptype= $input->get('proptype', "", 'STRING');
		
		$html='
		<script>
			jQuery("#limit").val('.$limit.');
			jQuery("#limit_start").val('.$limit_start+$limit.');
		</script>';

		$sitebaseurl=Uri::base();//exit;

		// Get all params of a specific component.
		$params_ = ComponentHelper::getParams('com_ardhs');

		// To get the value of the param.
		$singlepropmenu = $params_->get('singlepropmenu');

		// Select the required fields from the table.
		$where=array();
		$query= "SELECT * from #__ardh_properties";
//		$query.= " where ";
			
		if($status!="") {
			$where[]= '(status in ('.$status.'))';
		}
		if($proptype!="") {
			$where[]= "(proptype in (".$proptype.") )";
		}
		if(count($where)>0)
			$query.=" where ".implode(" AND ",$where);
//$query.=" where ".substr(implode(" AND ",$where), 5);

		$query.= " limit $limit OFFSET $limit_start";
		$orderCol  = 'id';
		$orderDirn = 'ASC';

//   echo $status." : ".$proptype." : ".count($where). "<h2>$query</h2>"; exit;
		$db->setQuery($query);
		$items = $db->loadObjectList();
		$module = ModuleHelper::getModule('mod_related_ardhs');
		$mra = new Registry($module->params);

		$columns=	$mra->get('columns', "4");
//		echo $columns;exit;
		$show_address=	$mra->get('show_address', 0);
		$show_price=	$mra->get('show_price', 0);
		$small_desc=	$mra->get('small_desc', 0);

		$show_bathroom=	$mra->get('show_bathroom', 0);
		$show_bedroom=	$mra->get('show_bedroom', 0);
		$show_parking=	$mra->get('show_parking', 0);
		$show_size=	$mra->get('show_size', 0);
		
		$title_words_limit=	$mra->get('title_words_limit', 50);
		$show_photo=$mra->get('show_photo', 0);
		$order_by=	$mra->get('order_by', "title");

		foreach ($items as $i => $item)
		{
			$main_image=($item->main_image!="")?$sitebaseurl.'images/mls/'.$item->main_image:"";
			$alias=strtolower(str_replace(" ","-",$item->title));
	
			$status=$item->status;
			$proptype=$item->proptype;
	
			$neighborhood=$item->neighborhood;
			$building=$item->building;
			$region=$item->region;
			$address=($show_address)?$neighborhood." ".$building." ".$region.'' : '';
	
			$bathrooms=($item->bathrooms!=""&&($show_bathroom))?'<i class="fa fa-bath" aria-hidden="true"></i> '.$item->bathrooms.' | ':'';
			$bedrooms=($item->bedrooms!=""&&($show_bedroom))?'<i class="fa fa-bed" aria-hidden="true"></i> '.$item->bedrooms.' | ':'';
			$size=($item->size!=""&&($show_size))?'<i class="fa fa-ruler-combined"></i> '.$item->size.' | ':'';
			$parking=($item->parking!=""&&($show_parking))?'<i class="fa fa-car"></i> '.$item->parking:'';
	
			$link=Route::_('index.php?option=com_ardhs&view=prop&id=' . $item->id.":".$alias.'&Itemid='.$singlepropmenu);
			//echo $singlepropmenu;exit;
			$price=($show_price) ?'<h3 class="ps-2 pt-2 pb-1 m-0 pull-left">'.$item->price.'</h3>':'';
			$district=$item->district;
			$country=$item->country;
	
			$html
			.='<div class="abdul col-12 col-md-'.$columns.' mb-2 position-relative" >
				<div id="courseData_'.$i.'" class="border p-1" style="min-height:415px; background-color:#fafafa;">
				<div class="main_image"><a href="'.$link.'"><img src="'.$main_image.'" alt="no image" class="img-fluid" /></a></div>
				'.$price.'
				<div class="ps-2 pt-2 pb-1 m-0 pull-right"><i class="fa fa-square" aria-hidden="true"></i> '.$proptype.'</div>
				<div class="position-absolute ps-1 pe-1" style="top:40px; right:10px; background:#FF6E00; color:#FFFFFF; border-radius:3px;">'.$status.'</div>

			<div style="clear:both; height:1px;"></div>
			
				<h4 class="ps-2 pb-2 m-0"><a style="text-decoration:none; color: #ec430f;" href="'.$link.'">'.substr($item->title,0,35)."...".'</a></h4>
				<div class="ps-2">
				'.$address;
	
			if($show_size||$show_bedroom||$show_bathroom||$show_parking)
			{
				$html.=$size.' '.$bedrooms.' '.$bathrooms.' '.$parking;
			}
	
			$html
				.='<div style="width: 85%; float: left"><i class="fa fa-location-arrow" aria-hidden="true"></i> '.$district.", ".$region.", ".$country.'</div>
					<div style="clear:both; height:1px;"></div>
				</div>
			
				</div>
			</div>';
			
			
			
$main_image=($item->main_image!="")?$sitebaseurl.'images/mls/'.$item->main_image:"";
$alias=strtolower(str_replace(" ","-",$item->title));
$neighborhood=$item->neighborhood;
$building=$item->building;
$region=$item->region;
$size=$item->size;
$bedrooms=$item->bedrooms;
$bathrooms=$item->bathrooms;
$parking=$item->parking;
$status=$item->status;
$proptype=$item->proptype;
$link=Route::_('index.php?option=com_ardhs&view=prop&id=' . $item->id.":".$alias.'&Itemid='.$singlepropmenu);
//echo $singlepropmenu;exit;
$price=$item->price;
$district=$item->district;
$country=$item->country;

			?>
			<div class="col-12 col-md-<?=$num_col?> mb-2 position-relative" >
				<div id="propBlock_<?php echo $i?>" class="border p-1" style="min-height:400px; background-color:#fafafa;">
			
				<!-- IMAGE PART -->
				
				<div class=" position-relative">
				<a href="<?php echo $link; ?>" style="text-decoration:none;">
					<img src="<?php echo $main_image?>" alt="no image" class="img-fluid" />
					<div class="position-absolute ps-1 pe-1" style="top:10px; right:10px; background:#224faa; color:#FFFFFF; border-radius:3px;"><?=$proptype?></div>
					<div class="position-absolute ps-1 pe-1" style="top:40px; right:10px; background:#FF6E00; color:#FFFFFF; border-radius:3px;"><?=$status?></div>
					<div class=" position-absolute" style="bottom:10px; color:white; font-size:11px; left:10px;">
					<i class="fa-solid fa-location-dot"></i> 
					<!--<?=$neighborhood." ".$building." ".$region?>-->
					<?=$district.", ".$region.", ".$country?>
					</div>
				</a>
				</div>
			
				<!-- TITLE PART -->
				<p class="pt-2 ps-2 pb-2 m-0">
					<a style="font-size:16px; font-weight:bold; text-decoration:none; " href="<?php echo $link; ?>"><?php echo ($item->title); ?></a>
				</p>
			
				<!-- PRICE PART -->
				<p class="ps-2 m-0 " style="color: #ec430f;"><?=$price?></p>
				<!--        <div class="ps-2 pt-2 pb-1 m-0 pull-right"><i class="fa fa-square" aria-hidden="true"></i> <?=$proptype?></div>
				<div style="clear:both"></div>
			-->        
			
				<!-- SHORT DESC(MEta) -->
				<p class="ps-2" style="font-size:16px; ">
					<?=$this->cropText_mod($item->meta_description)?>
				</p>
			
				<!-- BED BATHROOM, PARKING, PART -->
				<p class="ps-2" style="font-size:14px; ">
				<?php if($bedrooms!=""){?><i class="fa fa-bed" aria-hidden="true"></i> <?=$bedrooms?> | <?php }?>
				<?php if($bathrooms!=""){?><i class="fa fa-bath" aria-hidden="true"></i> <?=$bathrooms?> | <?php }?>
				<?php if($parking!=""){?><i class="fa fa-car"></i> <?=$parking?><?php }?>
				<?php if($size!=""){?><i class="fas fa-ruler"></i> <?=$size?> <?php }?>
			
				</p>
			
				</div>
			
			</div>
		<?php

		}

		//echo $html;
		exit;
	}
	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  The array of possible config values. Optional.
	 *
	 * @return  \Joomla\CMS\MVC\Model\BaseDatabaseModel
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Ardhs', $prefix = 'Administrator', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}


    /**
     * Remove all associated data with for the user name
     *
     * @param   array    $bldg_id
     */
   
	
	public function delete()	{

		$app = Factory::getApplication();
		$input = $app->input;
		$cids= $input->get('cid', '', 'array');
		//$result=$this->onUserAfterDelete($cids);
		$msg=($result=='success') ? 'Building with associated information deleted successfully.' : 'Something went wrong.';
		$this->setRedirect( 'index.php?option=com_ardhs&view=lmstarbiats',$msg);
		
		return true;
	}

}