<?php
/**
 * @package     Ardhs
 * @subpackage  com_ardhs
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Abdul\Component\Ardhs\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Versioning\VersionableControllerTrait;
use Joomla\Input\Input;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Uri\Uri;
/**
 * Controller for a single 
 *
 * @since  1.6
 */
class PropController extends FormController
{
	
	/**
     * Constructor.
     *
     * @param   array                $config   An optional associative array of configuration settings.
     * Recognized key values include 'name', 'default_task', 'model_path', and
     * 'view_path' (this list is not meant to be comprehensive).
     * @param   MVCFactoryInterface  $factory  The factory.
     * @param   CMSApplication       $app      The Application for the dispatcher
     * @param   Input                $input    Input
     *
     * @since   3.0
     */
    public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
		$this->registerTask( 'email'  , 'sendEmail' );
		
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'detail'  , 	'detail' );
		$this->registerTask( 'apply', 	'save' );
    }
	
	//	send Email 
	public function sendEmail()
	{
// OLD JOOMLA		$post = JRequest::get( 'post' , JREQUEST_ALLOWHTML );
		$app = Factory::getApplication();
		$post = $app->input->getArray();
		

//	echo '<pre>';print_r($post );exit;
$subject = 'MLS Inquiry: '.$post['mlsid'];
$body='';
$body.='Name: '.$post['contact_name'].'<br>';
$body.='Email: '.$post['contact_email'].'<br>';
$body.='Phone: '.$post['contact_tel'].'<br>';
$body.='Link: '.$post['url'].'<br><br>';

$body.='Comments:<br>'.$post['contact_comments'].' <br> Property URL: '.$post['url'].' <br><br>
Submitted by: '. $_SERVER['REMOTE_ADDR'] ;

		$mailer = Factory::getMailer();
		$config = Factory::getConfig();
	
		$sender = array( 
			$post['contact_email'] ,
			$post['contact_name'] 
		);

		$mailer->setSender($sender);
	
		$recipient = array( $post['comp_email']);
//		$mailer->addRecipient($recipient);
		$mailer->addRecipient("sayfrndship@gmail.com");
		$mailer->addRecipient("mike@realestate-panama.com");
		$mailer->addBCC("sayfrndship@gmail.com", "B2C");
		$mailer->isHTML(true);
		$mailer->Encoding = 'base64';
		$mailer->setBody($body);

		$mailer->setSubject($subject);
		
		/*
		$send = $mailer->Send();
		if ( $send !== true ) {
		//	echo 'Error sending email: ' . $send->__toString();
		} else {
		//	echo 'Mail sent Successfully.';
		}
		*/

		
// Always set content-type when sending HTML email
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

// More headers
//$headers .= 'From: <'.$post['contact_email'] .'>' . "\r\n";
$headers .= 'Cc: sayfrndship@gmail.com' . "\r\n";
$to = "mike@realestate-panama.com";
//$to = "sayfrndship@gmail.com";
		$post['comp_email'];
$subject = $subject;
$message = $body;

	$send = mail($to,$subject,$message,$headers);
// working	$send = mail("sayfrndship@gmail.com","sub","message",$headers);
	if ( $send !== true ) {
		echo 'Error sending email: ' . $send->__toString();
	} else {
		echo 'Your message has been sent successfully';
	}
//	echo "<pre>";	print_r($post);	echo "</pre>";	exit;
		$uri = Uri::getInstance();
		$url = $uri->toString();
		$url = $post['url'];//URI::base();
		$msg = ( 'Your message has been sent successfully' );
	$this->setRedirect( $url, $msg );
		return true;
echo '<script>
setTimeout(function () {
   window.location.href = "'.$url.'"; //will redirect )
}, 2000); //will call the function after 2 secs.
</script>';
		exit;//JApplication::close();
	}
	
	public function getModel($name = 'prop', $prefix = 'Administrator', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}


	public function cancel($key = NULL)
	{
		$msg = ( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_ardhs&view=props', $msg );
	}

    /**
     * Method override to check if you can add a new record.
     *
     * @param   array  $data  An array of input data.
     *
     * @return  boolean
     *
     * @since   1.6
     */
    protected function allowAdd($data = array())
    {
        $categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('filter_category_id'), 'int');

        if ($categoryId) {
            // If the category has been passed in the data or URL check it.
            return $this->app->getIdentity()->authorise('core.create', 'com_content.category.' . $categoryId);
        }

        // In the absence of better information, revert to the component permissions.
        return parent::allowAdd();
    }

    /**
     * Method override to check if you can edit an existing record.
     *
     * @param   array   $data  An array of input data.
     * @param   string  $key   The name of the key for the primary key.
     *
     * @return  boolean
     *
     * @since   1.6
     */
    protected function allowEdit($data = array(), $key = 'id')
    {
        return true;
        $recordId = (int) isset($data[$key]) ? $data[$key] : 0;
        $user = $this->app->getIdentity();

        // Zero record (id:0), return component edit permission by calling parent controller method
        if (!$recordId) {
            return parent::allowEdit($data, $key);
        }

        // Check edit on the record asset (explicit or inherited)
        if ($user->authorise('core.edit', 'com_content.article.' . $recordId)) {
            return true;
        }

        // Check edit own on the record asset (explicit or inherited)
        if ($user->authorise('core.edit.own', 'com_content.article.' . $recordId)) {
            // Existing record already has an owner, get it
            $record = $this->getModel()->getItem($recordId);

            if (empty($record)) {
                return false;
            }

            // Grant if current user is owner of the record
            return $user->id == $record->created_by;
        }

        return false;
    }

}
