<?php
/**
 * @version    6.0.2
 * @package    TAGZ
 * @author     roosterz.nl <roy@roosterz.nl>
 * @copyright  2025 roosterz.nl
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Ensure backward compatibility for Joomla 3.x and forward compatibility for 4–6
if (version_compare(JVERSION, '4.0', '<')) {
    jimport('joomla.application.component.modellist');
    class_alias('JModelList', 'Joomla\\CMS\\MVC\\Model\\ListModel');
}

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Database\DatabaseDriver;

if (!class_exists('TagzModelTagz')) {
    class TagzModelTagz extends ListModel
    {
        /**
         * Constructor.
         *
         * @param   array  $config  An optional associative array of configuration settings.
         */
        public function __construct($config = array())
        {
            if (empty($config['filter_fields'])) {
                $config['filter_fields'] = array(
                    'title', 'a.title', 'modified', 'a.modified',
                    'search', 'id', 'a.id'
                );
            }

            parent::__construct($config);
        }

        /**
         * Build an SQL query to load the list data.
         *
         * @return   \Joomla\Database\QueryInterface
         */
        protected function getListQuery()
        {
            $app   = Factory::getApplication();
            $input = $app->input;
            $type  = $input->get('component_type');

            // Ensure TagzHelper exists and is loaded
            if (!class_exists('TagzHelper')) {
                return;
            }

            $structure    = TagzHelper::getContentTypeStructure($type);
            $id           = $structure['id'] ?? null;
            $title        = $structure['title'] ?? null;
            $table        = $structure['table'] ?? null;
            $defaultSort  = $structure['defaultSort'] ?? 'id';

            if (!$id || !$title || !$type || !$table) {
                return;
            }

            /** @var DatabaseDriver $db */
            $db    = $this->getDbo();
            $query = $db->getQuery(true);

            if ($type !== 'opencart' && $type !== 'jcart') {
                $table = '#__' . $table;
            }

            // J2Store special handling
            if ($type === 'j2store') {
                $query
                    ->select($db->quoteName('a.' . $title, 'title'))
                    ->select('t.*')
                    ->select($db->quoteName($id, 'component_id'))
                    ->from($db->quoteName($table, 'a'))
                    ->join('INNER', $db->quoteName('#__j2store_products', 'b') . ' ON (' . $db->quoteName('b.product_source_id') . ' = ' . $db->quoteName('a.id') . ')')
                    ->join('LEFT', '#__tagz AS t ON t.component_id = ' . $id . ' AND t.component_type = ' . $db->quote($type));
            } else {
                $query
                    ->select($db->quoteName('a.' . $title, 'title'))
                    ->select('t.*')
                    ->select($db->quoteName('a.' . $id, 'component_id'))
                    ->from($db->quoteName($table, 'a'))
                    ->join('LEFT', '#__tagz AS t ON t.component_id = a.' . $id . ' AND t.component_type = ' . $db->quote($type));
            }

            // Filter by search term
            $search = $this->getState('filter.search');
            if (!empty($search)) {
                $search = $db->quote('%' . $db->escape($search, true) . '%');
                $query->where($db->quoteName('a.' . $title) . ' LIKE ' . $search);
            }

            // Additional filters
            if ($type === 'menu') {
                $query->select($db->quoteName('a.menutype', 'menutype'))
                      ->where($db->quoteName('a.published') . ' = 1');
            }

            if ($type === 'zoo') {
                $query->select($db->quoteName('a.type', 'zoo_type'));
            }

            // Ordering
            $orderCol  = $this->state->get('list.ordering', $defaultSort);
            $orderDirn = $this->state->get('list.direction', 'desc');
            $query->order($db->escape($orderCol . ' ' . $orderDirn));

            return $query;
        }

        /**
         * Get an array of data items
         *
         * @return mixed Array of data items on success, false on failure.
         */
        public function getItems()
        {
            $items = parent::getItems();
            return $items;
        }
    }
}
