<?php
/**
 * TAGZ Joomla 3–6 Compatibility Layer
 */

namespace Tagz\Helper;

defined('_JEXEC') or die;

// ---- Legacy stubs ----

// JError stub
if (!class_exists('JError')) {
    class JError {
        public static function raiseWarning($code, $msg) {
            \Joomla\CMS\Factory::getApplication()->enqueueMessage($msg, 'warning');
            return false;
        }

        public static function raiseError($code, $msg) {
            \Joomla\CMS\Factory::getApplication()->enqueueMessage($msg, 'error');
            throw new \RuntimeException($msg, $code);
        }
    }
}

if (!class_exists('JHtmlBehavior')) {
    class JHtmlBehavior {
        public static function multiselect() { return; }
        public static function tooltip() { return; }
    }
}


// ---- Compatibility aliases ----
class Compat
{
    public static function init()
    {
        if (!class_exists('JFactory') && class_exists('\Joomla\CMS\Factory')) {
            class_alias('\Joomla\CMS\Factory', 'JFactory');
        }

        if (!class_exists('JText') && class_exists('\Joomla\CMS\Language\Text')) {
            class_alias('\Joomla\CMS\Language\Text', 'JText');
        }

        if (!class_exists('JControllerLegacy') && class_exists('\Joomla\CMS\MVC\Controller\BaseController')) {
            class_alias('\Joomla\CMS\MVC\Controller\BaseController', 'JControllerLegacy');
        }

        if (!class_exists('JModelLegacy') && class_exists('\Joomla\CMS\MVC\Model\BaseDatabaseModel')) {
            class_alias('\Joomla\CMS\MVC\Model\BaseDatabaseModel', 'JModelLegacy');
        }

        if (!class_exists('JViewLegacy') && class_exists('\Joomla\CMS\MVC\View\HtmlView')) {
            class_alias('\Joomla\CMS\MVC\View\HtmlView', 'JViewLegacy');
        }

        if (!class_exists('JHtml') && class_exists('\Joomla\CMS\HTML\HTMLHelper')) {
            class_alias('\Joomla\CMS\HTML\HTMLHelper', 'JHtml');
        }

        if (!class_exists('JUri') && class_exists('\Joomla\CMS\Uri\Uri')) {
            class_alias('\Joomla\CMS\Uri\Uri', 'JUri');
        }

        if (!class_exists('JRoute') && class_exists('\Joomla\CMS\Router\Route')) {
            class_alias('\Joomla\CMS\Router\Route', 'JRoute');
        }

        if (!class_exists('JComponentHelper') && class_exists('\Joomla\CMS\Component\ComponentHelper')) {
            class_alias('\Joomla\CMS\Component\ComponentHelper', 'JComponentHelper');
        }
        
        if (!class_exists('JTable') && class_exists('\Joomla\CMS\Table\Table')) {
            class_alias('\Joomla\CMS\Table\Table', 'JTable');
        }

        if (!class_exists('JModelAdmin') && class_exists('\Joomla\CMS\MVC\Model\AdminModel')) {
            class_alias('\Joomla\CMS\MVC\Model\AdminModel', 'JModelAdmin');
        }

        if (!class_exists('JForm') && class_exists('\Joomla\CMS\Form\Form')) {
            class_alias('\Joomla\CMS\Form\Form', 'JForm');
        }

        if (!class_exists('JFormField') && class_exists('\Joomla\CMS\Form\FormField')) {
            class_alias('\Joomla\CMS\Form\FormField', 'JFormField');
        }

        if (!class_exists('JFormRule') && class_exists('\Joomla\CMS\Form\FormRule')) {
            class_alias('\Joomla\CMS\Form\FormRule', 'JFormRule');
        }

        if (!class_exists('JToolBarHelper') && class_exists('\Joomla\CMS\Toolbar\ToolbarHelper')) {
            class_alias('\Joomla\CMS\Toolbar\ToolbarHelper', 'JToolBarHelper');
        }
    }
}

// Initialize immediately
\Tagz\Helper\Compat::init();