<?php
/**
 * @version    6.0.2
 * @package    TAGZ
 * @author     roosterz.nl <roy@roosterz.nl>
 * @copyright  2025 roosterz.nl
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

// Controller compatibility wrapper for Joomla 3..6
// Prefer namespaced FormController when available, otherwise fall back to legacy JControllerForm

if (class_exists('\Joomla\\CMS\\MVC\\Controller\\FormController')) {
    class TagzControllerTag extends \Joomla\CMS\MVC\Controller\FormController
    {
        public function save($key = null, $urlVar = null)
        {
            $return = parent::save($key, $urlVar);

            $app = class_exists('Joomla\\CMS\\Factory') ? \Joomla\CMS\Factory::getApplication() : JFactory::getApplication();
            $input = $app->input;
            $formData = $input->get('jform', array(), 'array');
            $componentType = isset($formData['component_type']) ? $formData['component_type'] : '';

            $task = $input->getString('task', '');

            if ($task === 'save') { // Only by Save and Close redirect, not Apply
                $redirect = 'index.php?option=com_tagz&view=tagz&component_type=' . $componentType;
                $routeClass = class_exists('Joomla\\CMS\\Router\\Route') ? 'Joomla\\CMS\\Router\\Route' : 'JRoute';
                $this->setRedirect($routeClass::_( $redirect, false ));
            }

            return $return;
        }

        public function cancel($key = null, $urlVar = null)
        {
            $return = parent::cancel($key, $urlVar);

            $app = class_exists('Joomla\\CMS\\Factory') ? \Joomla\CMS\Factory::getApplication() : JFactory::getApplication();
            $input = $app->input;
            $formData = $input->get('jform', array(), 'array');
            $componentType = isset($formData['component_type']) ? $formData['component_type'] : '';

            $redirect = 'index.php?option=com_tagz&view=tagz&component_type=' . $componentType;
            $routeClass = class_exists('Joomla\\CMS\\Router\\Route') ? 'Joomla\\CMS\\Router\\Route' : 'JRoute';
            $this->setRedirect($routeClass::_( $redirect, false ));
            return $return;
        }
    }
} elseif (class_exists('JControllerForm')) {
    class TagzControllerTag extends JControllerForm
    {
        public function save($key = null, $urlVar = null)
        {
            $return = parent::save($key, $urlVar);

            $app = JFactory::getApplication();
            $input = $app->input;
            $formData = $input->get('jform', array(), 'array');
            $componentType = isset($formData['component_type']) ? $formData['component_type'] : '';

            $task = $input->getString('task', '');

            if ($task == 'save') { // Only by Save and Close redirect, not Apply
                $redirect = 'index.php?option=com_tagz&view=tagz&component_type=' . $componentType;
                $this->setRedirect(JRoute::_($redirect, false));
            }

            return $return;
        }

        public function cancel($key = null, $urlVar = null)
        {
            $return = parent::cancel($key, $urlVar);

            $app = JFactory::getApplication();
            $input = $app->input;
            $formData = $input->get('jform', array(), 'array');
            $componentType = isset($formData['component_type']) ? $formData['component_type'] : '';

            $redirect = 'index.php?option=com_tagz&view=tagz&component_type=' . $componentType;
            $this->setRedirect(JRoute::_($redirect, false));
            return $return;
        }
    }
} else {
    // Very old/unknown environment: provide a minimal class to avoid fatal errors
    class TagzControllerTag
    {
        public function save($key = null, $urlVar = null)
        {
            return true;
        }

        public function cancel($key = null, $urlVar = null)
        {
            return true;
        }
    }
}
