<?php
/**
 * @package   Phoca Gallery
 * @author    Jan Pavelka - https://www.phoca.cz
 * @copyright Copyright (C) Jan Pavelka https://www.phoca.cz
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 and later
 * @cms       Joomla
 * @copyright Copyright (C) Open Source Matters. All rights reserved.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 */
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Version;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Phoca\Render\Adminview;


class PhocaCommanderRenderAdminView extends Adminview
{
	protected $t;
	public $compatible;
	public $view;
	public $option;
	public $sidebar;

	public function __construct(){

		$paramsC 		= ComponentHelper::getParams('com_phocacommander');
		$this->t['theme']					= $paramsC->get( 'theme', 'phoca-light' );

		$app				= Factory::getApplication();
		$version 			= new Version();
		$this->compatible 	= $version->isCompatible('4.0.0-alpha');
		$this->view			= $app->getInput()->get('view');
		$this->option		= $app->getInput()->get('option');
		$this->sidebar 		= Factory::getApplication()->getTemplate(true)->params->get('menu', 1) ? true : false;

		$wa 				= $app->getDocument()->getWebAssetManager();

		HTMLHelper::_('behavior.formvalidator');
		HTMLHelper::_('behavior.keepalive');
		HTMLHelper::_('jquery.framework', false);



		// CP View
		//if ($this->view ==  null || $this->view == 'phocagalleryin') {
			HTMLHelper::_('stylesheet', 'media/'.$this->option.'/duotone/joomla-fonts.css', array('version' => 'auto'));
		//}




		if ($this->t['theme'] !== 0) {
			HTMLHelper::_('stylesheet', 'media/com_phocacommander/css/themes/'.htmlspecialchars(strip_tags($this->t['theme'])).'.css', array('version' => 'auto'));
		}



		//HTMLHelper::_('stylesheet', 'media/com_phocacommander/css/administrator/jquery-ui.css', array('version' => 'auto'));
		//HTMLHelper::_('stylesheet', 'media/com_phocacommander/css/administrator/phoca-ui.css', array('version' => 'auto'));
		//HTMLHelper::_('stylesheet', 'media/com_phocacommander/js/administrator/prettyphoto/css/prettyPhoto.css', array('version' => 'auto'));
		$wa->registerAndUseStyle('com_phocacommander.jquery-ui', 'media/com_phocacommander/css/administrator/jquery-ui.css', array('version' => 'auto'));
		$wa->registerAndUseStyle('com_phocacommander.phoca-ui', 'media/com_phocacommander/css/administrator/phoca-ui.css', array('version' => 'auto'));
		$wa->registerAndUseStyle('com_phocacommander.prettyphoto', 'media/com_phocacommander/js/administrator/prettyphoto/css/prettyPhoto.css', array('version' => 'auto'));

		HTMLHelper::_('jquery.framework', false);
		//HTMLHelper::_('script', 'system/core.js', false, true);
		HTMLHelper::_('behavior.core');
		HTMLHelper::_('script', 'media/com_phocacommander/js/administrator/jquery.base64.js', array('version' => 'auto'));
		HTMLHelper::_('script', 'media/com_phocacommander/js/administrator/jquery-ui.min.js', array('version' => 'auto'));
		HTMLHelper::_('script', 'media/com_phocacommander/js/administrator/prettyphoto/js/jquery.prettyPhoto.js', array('version' => 'auto'));
		HTMLHelper::_('script', 'media/com_phocacommander/js/administrator/jquery.pause.min.js', array('version' => 'auto'));


		$wa->registerAndUseStyle('com_phocacommander.plupload', 'media/com_phocacommander/js/administrator/plupload/jquery.plupload.queue/css/jquery.plupload.queue.css', array('version' => 'auto'));

		switch($this->view) {
			case 'phocacommanderinfo':

			break;
			default:
				HTMLHelper::_('script', 'media/com_phocacommander/js/administrator/phocacommander.js', array('version' => 'auto'));
		}

		if ($this->compatible) {
			HTMLHelper::_('stylesheet', 'media/'.$this->option.'/css/administrator/4.css', array('version' => 'auto'));
		} else {
			HTMLHelper::_('stylesheet', 'media/'.$this->option.'/css/administrator/3.css', array('version' => 'auto'));
		}

		$wa->registerAndUseStyle('com_phocacommander.phocacommander', 'media/com_phocacommander/css/administrator/phocacommander.css', array('version' => 'auto'));
		if ($this->t['theme'] === '0'){
			$wa->registerAndUseStyle('com_phocacommander.theme', 'media/com_phocacommander/css/administrator/theme-dark.css', array('version' => 'auto'), [], ['template.active']);
		}

	}
/*
	public function startCp() {

		$o = array();
		if ($this->compatible) {

			if ($this->sidebar) {

			} else {
				$o[] = '<div class="row">';
				$o[] = '<div id="j-main-container" class="col-md-2">'.Sidebar::render().'</div>';
				$o[] = '<div id="j-main-container" class="col-md-10">';
			}

		} else {
			$o[] = '<div id="j-sidebar-container" class="span2">' . Sidebar::render() . '</div>'."\n";
			$o[] = '<div id="j-main-container" class="span10">'."\n";
		}

		return implode("\n", $o);
	}

	public function endCp() {

		$o = array();
		if ($this->compatible) {
			if ($this->sidebar) {

			} else {

				$o[] = '</div></div>';
			}
		} else {
			$o[] = '</div>';
		}

		return implode("\n", $o);
	}
*/
/*
	public function startForm($option, $view, $itemId, $id = 'adminForm', $name = 'adminForm', $class = '', $layout = 'edit',  $tmpl = '') {


		if ($layout != '') {
			$layout = '&layout='.$layout;
		}
		$viewP = '';
		if ($view != '') {
			$viewP = '&view='.$view;
		}
		if ($tmpl != '') {
			$tmpl = '&tmpl='.$tmpl;
		}

		return '<div id="'.$view.'"><form action="'.Route::_('index.php?option='.$option . $viewP . $layout . '&id='.(int) $itemId . $tmpl).'" method="post" name="'.$name.'" id="'.$id.'" class="form-validate '.$class.'" role="form">'."\n"
		.'<div id="phAdminEdit" class="row-fluid">'."\n";

	}

	public function endForm() {
		$o = '</div>'."\n";
		$o .= '</form>'."\n";
		$o .= '</div>'."\n";

		return $o;
	}
*/
/*	public function formInputs($task = '') {

		$o = '<input type="hidden" name="task" value="" />'. "\n";
		$o .= HTMLHelper::_('form.token'). "\n";

		return $o;
	}


	public function group($form, $formArray, $clear = 0) {

		$o = '';
		if (!empty($formArray)) {
			if ($clear == 1) {
				foreach ($formArray as $value) {
					$o .= '<div>'. $form->getLabel($value) . '</div>'."\n"
					. '<div class="clearfix"></div>'. "\n"
					. '<div>' . $form->getInput($value). '</div>'."\n";
				}
			} else {
				foreach ($formArray as $value) {
					$o .= '<div class="control-group">'."\n"
					. '<div class="control-label">'. $form->getLabel($value) . '</div>'."\n"
					. '<div class="controls">' . $form->getInput($value). '</div>'."\n"
					. '</div>' . "\n";
				}
			}
		}
		return $o;
	}

	public function item($form, $item, $suffix = '') {

		$value = $o = '';
		if ($suffix != '') {
			$value = $suffix;
		} else {
			$value = $form->getInput($item);
		}
		$o .= '<div class="control-group">'."\n";
		$o .= '<div class="control-label">'. $form->getLabel($item) . '</div>'."\n"
		. '<div class="controls">' . $value.'</div>'."\n"
		. '</div>' . "\n";
		return $o;
	}

	public function quickIconButton( $link, $text = '', $icon = '', $color = '') {

		$o = '<div class="ph-cp-item">';
		$o .= ' <div class="ph-cp-item-icon">';
		$o .= '  <a class="ph-cp-item-icon-link" href="'.$link.'"><span style="background-color: '.$color.'20;"><i style="color: '.$color.';" class="phi '.$icon.' ph-cp-item-icon-link-large"></i></span></a>';
		$o .= ' </div>';

		$o .= ' <div class="ph-cp-item-title"><a class="ph-cp-item-title-link" href="'.$link.'"><span>'.$text.'</span></a></div>';
		$o .= '</div>';

		return $o;
	}



	public function getLinks($internalLinksOnly = 0) {
		$app	= Factory::getApplication();
		$option = $app->getInput()->get('option');
		$oT		= strtoupper($option);

		$links =  array();
		switch ($option) {

			case 'com_phocadownload':
				$links[]	= array('Phoca Download site', 'https://www.phoca.cz/phocadownload');
				$links[]	= array('Phoca Download documentation site', 'https://www.phoca.cz/documentation/category/17-phoca-download-component');
				$links[]	= array('Phoca Download download site', 'https://www.phoca.cz/download/category/68-phoca-download');
			break;

			case 'com_phocagallery':
				$links[]	= array('Phoca Gallery site', 'https://www.phoca.cz/phocagallery');
				$links[]	= array('Phoca Gallery documentation site', 'https://www.phoca.cz/documentation/category/2-phoca-gallery-component');
				$links[]	= array('Phoca Gallery download site', 'https://www.phoca.cz/download/category/66-phoca-gallery');
			break;

			case 'com_phocaemail':
				$links[]	= array('Phoca Email site', 'https://www.phoca.cz/phocaemail');
				$links[]	= array('Phoca Email documentation site', 'https://www.phoca.cz/documentation/category/60-phoca-email-component');
				$links[]	= array('Phoca Email download site', 'https://www.phoca.cz/download/category/47-phoca-email-component');
			break;

			case 'com_phocacommander':
				$links[]	= array('Phoca Commander site', 'https://www.phoca.cz/phocacommander');
				$links[]	= array('Phoca Commander documentation site', 'https://www.phoca.cz/documentation');
				$links[]	= array('Phoca Commander download site', 'https://www.phoca.cz/download');
			break;

		}

		$links[]	= array('Phoca News', 'https://www.phoca.cz/news');
		$links[]	= array('Phoca Forum', 'https://www.phoca.cz/forum');

		if ($internalLinksOnly == 1) {
		    return $links;
        }

		$components 	= array();
		$components[]	= array('Phoca Gallery','phocagallery', 'pg');
		$components[]	= array('Phoca Guestbook','phocaguestbook', 'pgb');
		$components[]	= array('Phoca Download','phocadownload', 'pd');
		$components[]	= array('Phoca Documentation','phocadocumentation', 'pdc');
		$components[]	= array('Phoca Favicon','phocafavicon', 'pfv');
		$components[]	= array('Phoca SEF','phocasef', 'psef');
		$components[]	= array('Phoca PDF','phocapdf', 'ppdf');
		$components[]	= array('Phoca Restaurant Menu','phocamenu', 'prm');
		$components[]	= array('Phoca Maps','phocamaps', 'pm');
		$components[]	= array('Phoca Font','phocafont', 'pf');
		$components[]	= array('Phoca Email','phocaemail', 'pe');
		$components[]	= array('Phoca Install','phocainstall', 'pi');
		$components[]	= array('Phoca Template','phocatemplate', 'pt');
		$components[]	= array('Phoca Panorama','phocapanorama', 'pp');
		$components[]	= array('Phoca Commander','phocacommander', 'pcm');
		$components[]	= array('Phoca Photo','phocaphoto', 'ph');
		$components[]	= array('Phoca Cart','phocacart', 'pc');

		$banners	= array();
		$banners[]	= array('Phoca Restaurant Menu','phocamenu', 'prm');
		$banners[]	= array('Phoca Cart','phocacart', 'pc');

		$o = '';
		$o .= '<p>&nbsp;</p>';
		$o .= '<h4 style="margin-bottom:5px;">'.Text::_($oT.'_USEFUL_LINKS'). '</h4>';
		$o .= '<ul>';
		foreach ($links as $k => $v) {
			$o .= '<li><a style="text-decoration:underline" href="'.$v[1].'" target="_blank">'.$v[0].'</a></li>';
		}
		$o .= '</ul>';

		$o .= '<div>';
		$o .= '<p>&nbsp;</p>';
		$o .= '<h4 style="margin-bottom:5px;">'.Text::_($oT.'_USEFUL_TIPS'). '</h4>';

		$m = mt_rand(0, 10);
		if ((int)$m > 0) {
			$o .= '<div>';
			$num = range(0,(count($components) - 1 ));
			shuffle($num);
			for ($i = 0; $i<3; $i++) {
				$numO = $num[$i];
				$o .= '<div style="float:left;width:33%;margin:0 auto;">';
				$o .= '<div><a style="text-decoration:underline;" href="https://www.phoca.cz/'.$components[$numO][1].'" target="_blank">'.HtmlHelper::_('image',  'media/'.$option.'/images/administrator/icon-box-'.$components[$numO][2].'.png', ''). '</a></div>';
				$o .= '<div style="margin-top:-10px;"><small><a style="text-decoration:underline;" href="https://www.phoca.cz/'.$components[$numO][1].'" target="_blank">'.$components[$numO][0].'</a></small></div>';
				$o .= '</div>';
			}
			$o .= '<div style="clear:both"></div>';
			$o .= '</div>';
		} else {
			$num = range(0,(count($banners) - 1 ));
			shuffle($num);
			$numO = $num[0];
			$o .= '<div><a href="https://www.phoca.cz/'.$banners[$numO][1].'" target="_blank">'.HtmlHelper::_('image',  'media/'.$option.'/images/administrator/b-'.$banners[$numO][2].'.png', ''). '</a></div>';

		}

		$o .= '<p>&nbsp;</p>';
		$o .= '<h4 style="margin-bottom:5px;">'.Text::_($oT.'_PLEASE_READ'). '</h4>';
		$o .= '<div><a style="text-decoration:underline" href="https://www.phoca.cz/phoca-needs-your-help/" target="_blank">'.Text::_($oT.'_PHOCA_NEEDS_YOUR_HELP'). '</a></div>';

		$o .= '</div>';
		return $o;
	}
*/
	// TABS
/*
	public function navigation($tabs, $activeTab = '') {

		if ($this->compatible) {
			return '';
		}

		$o = '<ul class="nav nav-tabs">';
		$i = 0;
		foreach($tabs as $k => $v) {
			$cA = 0;
			if ($activeTab != '') {
				if ($activeTab == $k) {
					$cA = 'class="active"';
				}
			} else {
				if ($i == 0) {
					$cA = 'class="active"';
				}
			}
			$o .= '<li '.$cA.'><a href="#'.$k.'" data-toggle="tab">'. $v.'</a></li>'."\n";
			$i++;
		}
		$o .= '</ul>';
		return $o;
	}
*/
/*
	public function startTabs($active = 'general') {
		if ($this->compatible) {
			return HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => $active));
		} else {
			return '<div class="tab-content">'. "\n";
		}
	}

	public function endTabs() {
		if ($this->compatible) {
			return HTMLHelper::_('uitab.endTabSet');
		} else {
			return '</div>';
		}
	}

	public function startTab($id, $name, $active = '') {
		if ($this->compatible) {
			return HTMLHelper::_('uitab.addTab', 'myTab', $id, $name);
		} else {
			return '<div class="tab-pane '.$active.'" id="'.$id.'">'."\n";
		}
	}

	public function endTab() {
		if ($this->compatible) {
			return HTMLHelper::_('uitab.endTab');
		} else {
			return '</div>';
		}
	}*/

}
?>
