<?php
/**
 * @package    Ossolution Property
 * @author     Dang Thuc Dam
 * @copyright  Copyright (C) 2025 joomdonation.com. All Rights Reserved.
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;

class JFormFieldMarketstatus extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'Marketstatus';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     */
    protected function getInput()
    {
        include_once JPATH_ROOT . '/components/com_osproperty/helpers/helper.php';
        $configClass = OSPHelper::loadConfig();

        // Get selected value
        $selectedValue = (isset($this->element['value']) && $this->element['value'] > 0)
            ? (int) $this->element['value']
            : (int) $this->value;

        $marketArr   = [];
        $marketArr[] = HTMLHelper::_('select.option', '0', Text::_('Select Market status'));

        $market_status = $configClass['market_status'] ?? '';
        if ($market_status !== '') {
            $market_status_array = explode(',', $market_status);

            if (in_array('1', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 1, Text::_('OS_SOLD'));
            }
            if (in_array('2', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 2, Text::_('OS_CURRENT'));
            }
            if (in_array('3', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 3, Text::_('OS_RENTED'));
            }
            if (in_array('4', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 4, Text::_('OS_OFF_MARKET'));
            }
            if (in_array('5', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 5, Text::_('OS_FOR_SALE'));
            }
            if (in_array('6', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 6, Text::_('OS_FOR_RENT'));
            }
            if (in_array('7', $market_status_array)) {
                $marketArr[] = HTMLHelper::_('select.option', 7, Text::_('OS_SALE_PENDING'));
            }
        }

        return HTMLHelper::_(
            'select.genericlist',
            $marketArr,
            $this->name,
            [
                'option.text.toHtml' => false,
                'option.value'       => 'value',
                'option.text'        => 'text',
                'list.attr'          => 'class="input-medium form-select"',
                'list.select'        => $selectedValue,
                'id'                 => $this->id,
            ]
        );
    }
}
