<?php
/*------------------------------------------------------------------------
# cpanel.html.php - Ossolution Property
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2025 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\Filesystem\Path;

class HTML_OspropertyCpanel
{
	static function cpanelHTML($option,$lists,$countries)
	{
		global $mainframe,$configClass,$languages,$bootstrapHelper;
		$db = Factory::getContainer()->get('db');
		$user = Factory::getApplication()->getIdentity();
		
		$rowFluidClass = $bootstrapHelper->getClassMapping('row-fluid');
		$span12Class = $bootstrapHelper->getClassMapping('span12');

		$versionObj = $lists['version'];
		$statistic = $lists['statistic'];

		$categoriesChart = isset($lists['categories_chart']) ? $lists['categories_chart'] : ['success' => false];
		$propertyTypesChart = isset($lists['property_types_chart']) ? $lists['property_types_chart'] : ['success' => false];

		$recentProperties = $statistic['recent_properties'];

		$document = Factory::getApplication()->getDocument();
		$wa = $document->getWebAssetManager();
		$wa->registerAndUseScript('com_osproperty.ajax',Uri::root().'media/com_osproperty/assets/js/ajax.js');
		$wa->registerAndUseScript('com_osproperty.dashboard.js',Uri::root().'administrator/components/com_osproperty/assets/js/dashboard.js');
		$document->addStyleSheet('https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css');
		$document->setTitle($configClass['general_bussiness_name']);
		//toolbar
		ToolBarHelper::title(Text::_('OS_CPANEL'),"home");
		//ToolBarHelper::cancel();
		ToolBarHelper::preferences('com_osproperty');
		$options = array(
				    'onActive' => 'function(title, description){
				        description.setStyle("display", "block");
				        title.addClass("open").removeClass("closed");
				    }',
				    'onBackground' => 'function(title, description){
				        description.setStyle("display", "none");
				        title.addClass("closed").removeClass("open");
				    }',
				    'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
				    'useCookie' => true, // this must not be a string. Don't use quotes.
				);
		//html
		?>
		<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
		<form>
		<div class="container-fluid px-3 py-2">
        <div class="row">
            <!-- Left Column -->
            <div class="col-lg-8">
				<?php
				if($versionObj['status'] == 2)
				{
				?>
				<div class="update-card-dashboard update-notification critical" id="dashboardUpdateCard">
                    <div class="update-content">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h6 class="mb-2" style="color:white;">
                                    <i class="bi bi-download me-2"></i>
                                    <?php echo Text::_('OS_UPDATE_AVAILABLE_HEADING'); ?>
                                </h6>
                                <p class="mb-2 small">
                                    <?php echo sprintf(Text::_('OS_UPDATE_VERSION'), $versionObj['version']);?>
                                </p>
                                <span class="version-badge">v<?php echo OSPHelper::getInstalledVersion();?> → v<?php echo $versionObj['version']; ?></span>
                            </div>
                            <button class="btn-close btn-close-white" onclick="hideDashboardUpdate();"></button>
                        </div>
                        <div class="update-actions">
                            <a class="btn-update me-2" href="index.php?option=com_installer&view=update">
                                <i class="bi bi-download me-1"></i><?php echo Text::_('OS_UPDATE_NOW');?>
							</a>
                            <a class="btn-update me-2" href="https://joomdonation.com/joomla-extensions/os-property-joomla-real-estate.html" target="_blank">
                                <i class="bi bi-list me-1"></i><?php echo Text::_('OS_VIEW_CHANGES'); ?>
							</a>
                        </div>
                    </div>
                </div>
				<?php } ?>
                <!-- System Info & Stats Row -->
                <div class="row mb-2">
                    <div class="col-md-6">
                        <div class="system-info-compact">
							<?php
							if($versionObj['status'] == 2)
							{
							?>
								<div class="update-indicator update-notification" id="systemUpdateIndicator">
									<i class="bi bi-exclamation"></i>
								</div>
							<?php } ?>
                            <h6 class="section-title-compact">
                                <i class="bi bi-info-circle"></i><?php echo Text::_('OS_SYSTEM_STATUS'); ?>
                            </h6>
                            <div class="row">
                                <div class="col-6">
                                    <div class="info-item">
                                        <span><?php echo Text::_('OS_DATABASE'); ?>:</span>
                                        <span class="status-badge status-success">✓ OK</span>
                                    </div>
									<div class="info-item">
                                        <span><?php echo Text::_('OS_GD_LIB'); ?>:</span>
										<?php
										if($lists['gd'] == 1){
										?>
                                    		<span class="status-badge status-success">✓ OK</span>
										<?php
										}else{
										?>
										     <span class="status-badge status-danger">Not OK</span>
										<?php } ?>
                                    </div>
                                </div>
                                <div class="col-6">
									<div class="info-item">
										<span><?php echo Text::_('OS_VERSION')?>:</span>
										<span class="fw-bold"><?php echo OSPHelper::getInstalledVersion();?></span>
									</div>
									<?php
									if($versionObj['status'] == 2)
									{
									?>
										<div class="info-item">
											<span>Updates:</span>
											<span class="status-badge status-update-available update-notification" id="updateStatusBadge">
												⚠ Available
											</span>
										</div>
									<?php } ?>
                                    <div class="info-item">
                                        <span>PHP:</span>
                                        <span class="fw-bold"><?php echo PHP_VERSION; ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="stats-compact">
                            <h6 class="section-title-compact">
                                <i class="bi bi-graph-up"></i><?php echo Text::_('OS_QUICK_STATS'); ?>
                            </h6>
                            <div class="row">
                                <div class="col-3">
                                    <div class="stat-item-compact">
                                        <div class="stat-number-compact"><?php echo $statistic['stats']['total_properties']; ?></div>
                                        <div class="stat-label-compact"><?php echo Text::_('OS_PROPERTIES');?></div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="stat-item-compact">
                                        <div class="stat-number-compact"><?php echo $statistic['stats']['total_agents']?></div>
                                        <div class="stat-label-compact"><?php echo Text::_('OS_USERS');?></div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="stat-item-compact">
                                        <div class="stat-number-compact"><?php echo $statistic['stats']['featured_properties']?></div>
                                        <div class="stat-label-compact"><?php echo Text::_('OS_FEATURED');?></div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="stat-item-compact">
                                        <div class="stat-number-compact"><?php echo $statistic['stats']['total_companies']?></div>
                                        <div class="stat-label-compact"><?php echo Text::_('OS_COMPANIES');?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Analytics Row -->
                <div class="row mb-4">
					<div class="col-lg-3 col-md-6 mb-3">
						<div class="chart-card text-center">
							<div class="h3 text-warning mb-2">
								<?php echo number_format($statistic['stats']['total_requests'],0,'.',','); ?>
							</div>
							<div class="text-muted"><?php echo Text::_('OS_TOTAL_REQUESTS');?></div>
						</div>
					</div>
					
					<div class="col-lg-3 col-md-6 mb-3">
						<div class="chart-card text-center">
							<div class="h3 text-success mb-2">
								<?php echo number_format($statistic['stats']['total_favorites'],0,'.',','); ?>
							</div>
							<div class="text-muted"><?php echo Text::_('OS_TOTAL_FAV');?></div>
						</div>
					</div>
					
					<div class="col-lg-3 col-md-6 mb-3">
						<div class="chart-card text-center">
							<div class="h3 text-info mb-2">
								<?php echo OSPHelper::generatePrice('',$statistic['statistic']['average_price']); ?>
							</div>
							<div class="text-muted"><?php echo Text::_('OS_AVERAGE_PRICE');?></div>
						</div>
					</div>
					
					<div class="col-lg-3 col-md-6 mb-3">
						<div class="chart-card text-center">
							<div class="h3 text-danger mb-2">
								<?php echo number_format($statistic['stats']['properties_in_month'],0,'.',','); ?>
							</div>
							<div class="text-muted"><?php echo Text::_('OS_PROPERTIES_POSTED_THIS_MONTH');?>s</div>
						</div>
					</div>
				</div>

                <!-- Charts Row -->
				<?php
				if((int) $lists['properties'] == 0 && (int) $lists['categories'] == 0)
				{
					?>
					<div class="row mb-2">
						<div class="col-md-7">
							<div class="chart-card-compact">
								<h6 class="section-title-compact">
									<i class="bi bi-bar-chart"></i><?php echo Text::_('OS_PROPERTIES_BY_CATEGORIES'); ?>
								</h6>
								<div class="chart-container-compact">
									<!-- Empty state thay thế cho canvas -->
									<div class="empty-chart-state">
										<div class="empty-icon">
											<i class="bi bi-bar-chart-fill"></i>
										</div>
										<h6 class="empty-title"><?php echo Text::_('OS_NO_CATEGORIES_DATA'); ?></h6>
										<p class="empty-description"><?php echo Text::_('OS_CREATE_CATEGORIES_AND_PROPERTIES_TO_SEE_DISTRIBUTION'); ?></p>
										<div class="empty-actions">
											<a href="<?php echo Route::_('index.php?option=com_osproperty&task=categories_add'); ?>" 
											   class="btn btn-primary btn-sm">
												<i class="bi bi-plus-circle"></i> <?php echo Text::_('OS_CREATE_NEW_CATEGORY'); ?>
											</a>
											<a href="<?php echo Route::_('index.php?option=com_osproperty&task=properties_add'); ?>" 
											   class="btn btn-success btn-sm">
												<i class="bi bi-house-add"></i> <?php echo Text::_('OS_NEW_PROPERTY')?>
											</a>
											<a href="<?php echo Route::_('index.php?option=com_osproperty&task=properties_prepareinstallsample'); ?>" 
											   class="btn btn-info btn-sm">
												<i class="bi bi-download"></i> <?php echo Text::_('OS_INSTALLSAMPLEDATA')?>
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-md-5">
							<div class="chart-card-compact">
								<h6 class="section-title-compact">
									<i class="bi bi-pie-chart"></i><?php echo Text::_('OS_PROPERTIES_BY_TYPE'); ?>
								</h6>
								<div class="chart-container-compact">
									<!-- Empty state thay thế cho canvas -->
									<div class="empty-chart-state">
										<div class="empty-icon">
											<i class="bi bi-pie-chart-fill"></i>
										</div>
										<h6 class="empty-title"><?php echo Text::_('OS_NO_PROPERTY_TYPES'); ?></h6>
										<p class="empty-description"><?php echo Text::_('OS_MANAGE_PROPERTY_TYPES_TO_SEE_DISTRIBUTION'); ?></p>
										<div class="empty-actions">
											<a href="<?php echo Route::_('index.php?option=com_osproperty&task=type_list'); ?>" 
											   class="btn btn-primary btn-sm">
												<i class="bi bi-plus-circle"></i> <?php echo Text::_('OS_MANAGE_PROPERTY_TYPES');?>
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
				else
				{
				?>
					<div class="row mb-2">
						<div class="col-md-7">
							<div class="chart-card-compact">
								<h6 class="section-title-compact">
									<i class="bi bi-bar-chart"></i><?php echo Text::_('OS_PROPERTIES_BY_CATEGORIES'); ?>
								</h6>
								<div class="chart-container-compact">
									<div id="categoriesChartContainer" style="height: 300px;">
										<canvas id="categoriesBarChart"></canvas>
									</div>
									<div id="chartLoading" class="text-center" style="display: none;">
										<div class="spinner-border text-primary" role="status">
											<span class="visually-hidden">Loading...</span>
										</div>
										<p class="mt-2 text-muted">Loading chart data...</p>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-5">
							<div class="chart-card-compact">
								<h6 class="section-title-compact">
									<i class="bi bi-pie-chart"></i><?php echo Text::_('OS_PROPERTIES_BY_TYPE'); ?>
								</h6>
								<div id="propertyTypesChartContainer" style="height: 300px;">
									<canvas id="propertyTypesPieChart"></canvas>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
                <!-- Control Panel -->
                <div class="control-panel-compact">
                    <h6 class="section-title-compact">
                        <i class="bi bi-grid-3x3-gap"></i><?php echo Text::_('OS_CONTROLPANEL');?>
                    </h6>
                    <div class="row g-2">
						<!-- Configuration Section -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-config">
									<a href="index.php?option=com_osproperty&task=configuration_list" title="<?php echo Text::_('OS_CONFIGURATION');?>"><i class="bi bi-gear"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=configuration_list" title="<?php echo Text::_('OS_CONFIGURATION');?>"><?php echo Text::_('OS_CONFIGURATION');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_SETTINGS');?></div>
							</div>
						</div>

						<!-- Categories -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=categories_list" title="<?php echo Text::_('OS_CATEGORIES');?>"><i class="bi bi-folder"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=categories_list" title="<?php echo Text::_('OS_MANAGE_CATEGORIES');?>"><?php echo Text::_('OS_CATEGORIES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_CATEGORIES');?></div>
							</div>
						</div>

						<!-- Property Types -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-property">
									<a href="index.php?option=com_osproperty&task=type_list" title="<?php echo Text::_('OS_MANAGE_PROPERTY_TYPES');?>"><i class="bi bi-house"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=type_list" title="<?php echo Text::_('OS_MANAGE_PROPERTY_TYPES');?>"><?php echo Text::_('OS_TYPES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_PROPERTY_TYPES');?></div>
							</div>
						</div>

						<!-- Amenities/Convenience -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-property">
									<a href="index.php?option=com_osproperty&task=amenities_list" title="<?php echo Text::_('OS_MANAGE_CONVENIENCE');?>"><i class="bi bi-star"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=amenities_list" title="<?php echo Text::_('OS_MANAGE_CONVENIENCE');?>"><?php echo Text::_('OS_CONVENIENCE');?></a></div>
								<div class="control-desc-compact"><?PHP echo Text::_('OS_AMENITIES');?></div>
							</div>
						</div>

						<!-- Properties -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-property">
									<a href="index.php?option=com_osproperty&task=properties_list" title="<?php echo Text::_('OS_MANAGE_PROPERTIES');?>"><i class="bi bi-building"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=properties_list" title="<?php echo Text::_('OS_MANAGE_PROPERTIES');?>"><?php echo Text::_('OS_PROPERTIES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_LISTINGS');?></div>
							</div>
						</div>

						<!-- Agents -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-user">
									<a href="index.php?option=com_osproperty&task=agent_list" title="<?php echo Text::_('OS_MANAGE_AGENTS');?>"><i class="bi bi-people"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=agent_list" title="<?php echo Text::_('OS_MANAGE_AGENTS');?>"><?php echo Text::_('OS_AGENTS');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_AGENTS');?></div>
							</div>
						</div>

						<!-- Companies -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-user">
									<a href="index.php?option=com_osproperty&task=companies_list" title="<?php echo Text::_('OS_MANAGE_COMPANIES');?>"><i class="bi bi-building"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=companies_list" title="<?php echo Text::_('OS_MANAGE_COMPANIES');?>"><?php echo Text::_('OS_COMPANIES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_COMPANIES');?></div>
							</div>
						</div>

						<!-- Field Groups -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=fieldgroup_list" title="<?php echo Text::_('OS_MANAGE_FIELD_GROUPS');?>"><i class="bi bi-collection"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=fieldgroup_list" title="<?php echo Text::_('OS_MANAGE_FIELD_GROUPS');?>"><?php echo Text::_('OS_FIELD_GROUPS');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_GROUPS');?></div>
							</div>
						</div>

						<!-- Extra Fields -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=extrafield_list" title="<?php echo Text::_('OS_MANAGE_EXTRA_FIELDS');?>"><i class="bi bi-input-cursor-text"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=extrafield_list" title="<?php echo Text::_('OS_MANAGE_EXTRA_FIELDS');?>"><?php echo Text::_('OS_EXTRA_FIELDS');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_EXTRA_FIELDS');?></div>
							</div>
						</div>

						<!-- States -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-property">
									<a href="index.php?option=com_osproperty&task=state_list" title="<?php echo Text::_('OS_MANAGE_STATES');?>"><i class="bi bi-map"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=state_list" title="<?php echo Text::_('OS_MANAGE_STATES');?>"><?php echo Text::_('OS_STATES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_STATE');?></div>
							</div>
						</div>

						<!-- Cities -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-property">
									<a href="index.php?option=com_osproperty&task=city_list" title="<?php echo Text::_('OS_MANAGE_CITY');?>"><i class="bi bi-geo-alt"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=city_list" title="<?php echo Text::_('OS_MANAGE_CITY');?>"><?php echo Text::_('OS_CITIES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_CITY');?></div>
							</div>
						</div>

						<!-- Email Forms -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=email_list" title="<?php echo Text::_('OS_MANAGE_EMAIL_TEMPLATES');?>"><i class="bi bi-envelope"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=email_list" title="<?php echo Text::_('OS_MANAGE_EMAIL_TEMPLATES');?>"><?php echo Text::_('OS_EMAIL_TEMPLATES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_EMAILS');?></div>
							</div>
						</div>

						<!-- Tags -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=tag_list" title="<?php echo Text::_('OS_MANAGE_TAGS');?>"><i class="bi bi-tags"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=tag_list" title="<?php echo Text::_('OS_MANAGE_TAGS');?>"><?php echo Text::_('OS_TAGS');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_TAGS');?></div>
							</div>
						</div>

						<!-- Themes -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=theme_list" title="<?php echo Text::_('OS_MANAGE_THEMES');?>"><i class="bi bi-palette"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=theme_list" title="<?php echo Text::_('OS_MANAGE_THEMES');?>"><?php echo Text::_('OS_THEMES');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_MANAGE_THEMES');?></div>
							</div>
						</div>

						<!-- XML Export -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-tool">
									<a href="index.php?option=com_osproperty&task=xml_default" title="<?php echo Text::_('OS_EXPORT_XML');?>"><i class="bi bi-filetype-xml"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=xml_default" title="<?php echo Text::_('OS_EXPORT_XML');?>"><?php echo Text::_('OS_EXPORT_XML');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_EXPORT_XML');?></div>
							</div>
						</div>

						<!-- XML Import -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-tool">
									<a href="index.php?option=com_osproperty&task=xml_defaultimport" title="<?php echo Text::_('OS_IMPORT_XML');?>"><i class="bi bi-file-earmark-arrow-up"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=xml_defaultimport" title="<?php echo Text::_('OS_IMPORT_XML');?>"><?php echo Text::_('OS_IMPORT_XML');?></a></div>
								<div class="control-desc-compact"><?php echo Text::_('OS_IMPORT_XML');?></div>
							</div>
						</div>

						<!-- Translation -->
						<div class="col-lg-2 col-md-3 col-4">
							<div class="control-card-compact">
								<div class="control-icon-compact icon-manage">
									<a href="index.php?option=com_osproperty&task=translation_list" title="<?php echo Text::_('OS_TRANSLATION_LIST');?>"><i class="bi bi-translate"></i></a>
								</div>
								<div class="control-title-compact"><a href="index.php?option=com_osproperty&task=translation_list" title="<?php echo Text::_('OS_TRANSLATION_LIST');?>"><?php echo Text::_('OS_TRANSLATION_LIST');?></a></div>
								<div class="control-desc-compact">Translation</div>
							</div>
						</div>
						<div class="col-lg-2 col-md-3 col-4">
                            <div class="control-card-compact">
                                <div class="control-icon-compact icon-tool">
                                    <a href="index.php?option=com_osproperty&task=configuration_help" title="<?php echo Text::_('JTOOLBAR_HELP');?>"><i class="bi bi-question-circle"></i></a>
                                </div>
                                <div class="control-title-compact"><a href="index.php?option=com_osproperty&task=configuration_help" title="<?php echo Text::_('JTOOLBAR_HELP');?>"><?php echo Text::_('JTOOLBAR_HELP');?></a></div>
                                <div class="control-desc-compact"><?php echo Text::_('OS_SUPPORT'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="col-lg-4">
                <!-- Top Properties -->
				<?php
				$top_properties = (array)$statistic['top_viewed'];
				if(count($top_properties) > 0)
				{
					?>
					<div class="top-properties-compact">
						<h6 class="section-title-compact">
							<i class="bi bi-trophy"></i><?php echo Text::_('OS_TOP_PROPERTIES'); ?>
						</h6>
						<?php
						foreach($top_properties as $property){
						?>
							<div class="property-item-compact">
								<?php
								$photo = OSPHelper::getPropertyPhoto($property->id);
								if($photo != "" && is_file(Path::clean(JPATH_ROOT . '/images/osproperty/properties/'.$property->id.'/thumb/'.$photo)))
								{
								?>
									<img src="<?php echo Uri::root();?>images/osproperty/properties/<?php echo $property->id;?>/thumb/<?php echo $photo;?>" alt="<?php echo $property->pro_name; ?>" class="property-image-compact">
								<?php
								}
								?>
								<div class="property-info-compact">
									<div class="property-title-compact"><?php echo $property->pro_name?></div>
									<div class="property-location-compact"><?php echo OSPHelper::generateAddress($property);?></div>
								</div>
								<div class="property-stats-compact">
									<div class="property-views-compact"><?php echo number_format($property->hits, 0, '.',',')?></div>
								</div>
							</div>
						<?php } ?>
					</div>
				<?php } ?>
                <!-- Activity Feed -->
				<?php
				if(count($recentProperties) > 0)
				{
				?>
					<div class="activity-feed-compact">
						<h6 class="section-title-compact">
							<i class="bi bi-activity"></i><?php echo Text::_('OS_RECENT_PROPERTIES'); ?>
						</h6>
						<?php
						foreach($recentProperties as $property){
						?>
						<div class="activity-item-compact">
							<div class="activity-icon-compact activity-new">
								<i class="bi bi-plus"></i>
							</div>
							<div class="activity-content-compact">
								<div class="activity-text-compact"><?php echo $property->pro_name;?></div>
								<div class="activity-time-compact"><?php echo OspropertyCpanel::getTimeAgo($property->created)?></div>
							</div>
						</div>
						<?php } ?>
					</div>
				<?php
				}
				?>

                <!-- Quick Actions -->
                <div class="chart-card-compact">
                    <h6 class="section-title-compact">
                        <i class="bi bi-globe"></i><?php echo Text::_('OS_LOCATION');?>
                    </h6>
                    <div class="row">
                        <div id="location_div" class="location-box"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

	<script>
		let propertyTypesChart = null;
        // Chart.js Configuration
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize categories chart
			<?php
			if($statistic['stats']['total_categories'] > 0 && $lists['properties'] > 0):
			?>
            initializeCategoriesChart();
			<?php
			endif;
			if($statistic['stats']['total_types'] > 0 && $lists['properties'] > 0):
			?>
			initializePropertyTypesChart();
			<?php
			endif;
			?>
			initLocation();
        });

		function initializePropertyTypesChart() {
            
			// Use server-side data
			const chartData = {
				labels: <?php echo json_encode($propertyTypesChart['labels']); ?>,
				values: <?php echo json_encode($propertyTypesChart['values']); ?>,
				colors: <?php echo json_encode($propertyTypesChart['colors']); ?>,
				hoverColors: <?php echo json_encode($propertyTypesChart['hoverColors']); ?>,
				total: <?php echo $propertyTypesChart['total']; ?>
			};
			createPropertyTypesPieChart(chartData);
        }

		function createPropertyTypesPieChart(data) {
			const ctx = document.getElementById('propertyTypesPieChart').getContext('2d');
			
			// Destroy existing chart if exists
			if (propertyTypesChart instanceof Chart) {
				propertyTypesChart.destroy();
			}
			
			propertyTypesChart = new Chart(ctx, {
				type: 'pie',
				data: {
					labels: data.labels,
					datasets: [{
						label: 'Properties',
						data: data.values,
						backgroundColor: data.colors,
						hoverBackgroundColor: data.hoverColors,
						borderColor: '#ffffff',
						borderWidth: 2,
						hoverBorderWidth: 3
					}]
				},
				options: {
					responsive: true,
					maintainAspectRatio: false,
					layout: {
						padding: {
							top: 10,
							bottom: 20,
							left: 10,
							right: 10
						}
					},
					plugins: {
						title: {
							display: true,
							text: '',
							font: {
								size: 16,
								weight: 'bold'
							},
							padding: {
								top: 10,
								bottom: 20
							}
						},
						legend: {
							display: true,
							position: 'bottom', // Đặt legend xuống dưới
							align: 'center',
							labels: {
								usePointStyle: true,
								pointStyle: 'circle',
								padding: 15,
								font: {
									size: 12,
									weight: '500'
								},
								boxWidth: 12,
								boxHeight: 12,
								generateLabels: function(chart) {
									const data = chart.data;
									if (data.labels.length && data.datasets.length) {
										const total = data.datasets[0].data.reduce((a, b) => a + b, 0);
										return data.labels.map((label, i) => {
											const dataset = data.datasets[0];
											const value = dataset.data[i];
											const percentage = total > 0 ? Math.round((value / total) * 100) : 0;
											
											return {
												text: `${label} (${percentage}%)`,
												fillStyle: dataset.backgroundColor[i],
												strokeStyle: dataset.backgroundColor[i],
												lineWidth: 0,
												pointStyle: 'circle',
												hidden: false,
												index: i
											};
										});
									}
									return [];
								}
							}
						},
						tooltip: {
							callbacks: {
								label: function(context) {
									const total = context.dataset.data.reduce((a, b) => a + b, 0);
									const percentage = ((context.parsed / total) * 100).toFixed(1);
									return context.label + ': ' + context.parsed + ' properties (' + percentage + '%)';
								}
							}
						}
					},
					animation: {
						animateRotate: true,
						animateScale: true,
						duration: 1500,
						easing: 'easeInOutQuart'
					},
					onHover: function(event, elements) {
						event.native.target.style.cursor = elements.length > 0 ? 'pointer' : 'default';
					}
				}
			});
		}


        
        function toggleChartSegment(index) {
            if (propertyTypesChart) {
                const meta = propertyTypesChart.getDatasetMeta(0);
                const segment = meta.data[index];
                segment.hidden = !segment.hidden;
                propertyTypesChart.update();
            }
        }

        function showChartError(message) {
            const chartContainer = document.getElementById('propertyTypesChartContainer');
            chartContainer.innerHTML = `
                <div class="alert alert-warning text-center">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    ${message}
                </div>
            `;
        }

        function initializeCategoriesChart() {
            
			// Use server-side data
			const chartData = {
				categories: <?php echo json_encode($categoriesChart['categories']); ?>,
				values: <?php echo json_encode($categoriesChart['values']); ?>,
				colors: <?php echo json_encode($categoriesChart['colors']); ?>
			};
			createCategoriesBarChart(chartData.categories, chartData.values, chartData.colors);            
        }

		function createCategoriesBarChart(categories, values, colors) {
            const ctx = document.getElementById('categoriesBarChart').getContext('2d');
            
            // Destroy existing chart if exists
            if (window.categoriesChart instanceof Chart) {
                window.categoriesChart.destroy();
            }
            
            window.categoriesChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: categories,
                    datasets: [{
                        label: 'Properties Count',
                        data: values,
                        backgroundColor: colors,
                        borderColor: colors.map(color => color.replace('0.8', '1')),
                        borderWidth: 1,
                        hoverBackgroundColor: colors.map(color => color.replace('0.8', '0.9')),
                        hoverBorderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        title: {
                            display: true,
                            text: 'Properties Distribution by Categories',
                            font: {
                                size: 14,
                                weight: 'bold'
                            }
                        },
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = ((context.parsed.y / total) * 100).toFixed(1);
                                    return context.parsed.y + ' properties (' + percentage + '%)';
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 1,
                                callback: function(value) {
                                    return Number.isInteger(value) ? value : '';
                                }
                            },
                            title: {
                                display: true,
                                text: 'Number of Properties',
                                font: {
                                    size: 12
                                }
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Categories',
                                font: {
                                    size: 12
                                }
                            },
                            ticks: {
                                maxRotation: 45,
                                minRotation: 0,
                                font: {
                                    size: 10
                                }
                            }
                        }
                    },
                    animation: {
                        duration: 1000,
                        easing: 'easeInOutQuart'
                    }
                }
            });
        }

        function showChartError(message) {
            const chartContainer = document.getElementById('categoriesChartContainer');
            chartContainer.innerHTML = `
                <div class="alert alert-warning text-center">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    ${message}
                </div>
            `;
        }

        // Add click handlers for control cards
        document.querySelectorAll('.control-card-compact').forEach(card => {
            card.addEventListener('click', function() {
                const title = this.querySelector('.control-title-compact').textContent;
                console.log(`Clicked: ${title}`);
                // Add your navigation logic here
            });
        });

        // Navigation active state
        document.querySelectorAll('.nav-link').forEach(link => {
			link.addEventListener('click', function(e) {
				// Chỉ preventDefault nếu là link giả
				if (this.getAttribute('href') === '#' || this.getAttribute('href') === 'javascript:void(0)') {
					e.preventDefault();
				}
				document.querySelectorAll('.nav-link').forEach(l => l.classList.remove('active'));
				this.classList.add('active');
			});
		});

        // Animate counters on page load
        function animateCounter(element, target, duration = 1500) {
            let start = 0;
            const increment = target / (duration / 16);
            
            function updateCounter() {
                start += increment;
                if (start < target) {
                    if (element.textContent.includes('K')) {
                        element.textContent = (start / 1000).toFixed(1) + 'K';
                    } else if (element.textContent.includes('M')) {
                        element.textContent = '$' + (start / 1000000).toFixed(1) + 'M';
                    } else {
                        element.textContent = Math.floor(start).toLocaleString();
                    }
                    requestAnimationFrame(updateCounter);
                } else {
                    if (element.textContent.includes('K')) {
                        element.textContent = (target / 1000).toFixed(1) + 'K';
                    } else if (element.textContent.includes('M')) {
                        element.textContent = '$' + (target / 1000000).toFixed(1) + 'M';
                    } else {
                        element.textContent = target.toLocaleString();
                    }
                }
            }
            updateCounter();
        }

        // Responsive handling
        function handleResize() {
            if (window.innerWidth < 768) {
                // Mobile optimizations
                document.querySelectorAll('.chart-container-compact').forEach(container => {
                    container.style.height = '250px';
                });
            } else {
                document.querySelectorAll('.chart-container-compact').forEach(container => {
                    container.style.height = '300px';
                });
            }
        }

        window.addEventListener('resize', handleResize);
        handleResize(); // Initial call


		function hideDashboardUpdate() {
			if (event) event.preventDefault();
            document.getElementById('dashboardUpdateCard').style.display = 'none';            
        }
    </script>
		
		
	<input type="hidden" name="option" value="" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="live_site" id="live_site" value="<?php echo Uri::root();?>" />
	</form>
	<?php
	}
}
?>
