// Animate numbers on page load
document.addEventListener('DOMContentLoaded', function() {
    const numberElements = document.querySelectorAll('.chart-card .h3');
    
    numberElements.forEach(element => {
        const finalNumber = element.textContent.replace(/[^0-9.-]+/g, '');
        if (finalNumber && !isNaN(finalNumber)) {
            animateNumber(element, 0, parseFloat(finalNumber), 1500);
        }
    });
});

function animateNumber(element, start, end, duration) {
    const startTime = performance.now();
    const originalText = element.textContent;
    
    function updateNumber(currentTime) {
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        
        const current = start + (end - start) * easeOutQuart(progress);
        
        if (originalText.includes('$')) {
            element.textContent = '$' + Math.floor(current).toLocaleString();
        } else {
            element.textContent = Math.floor(current).toLocaleString();
        }
        
        if (progress < 1) {
            requestAnimationFrame(updateNumber);
        }
    }
    
    requestAnimationFrame(updateNumber);
}

function easeOutQuart(t) {
    return 1 - (--t) * t * t * t;
}
