<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

defined('_JEXEC') or die;

/**
 * @property-read $OSMembershipModelStatistics $model
 */
class OSMembershipViewStatisticsHtml extends MPFViewHtml
{
	/**
	 * statistic data
	 *
	 * @var array
	 */
	protected $data;

	/**
	 * Prepare data necessary for the view before rendering
	 *
	 * @return  void
	 *
	 */
	protected function prepareView()
	{
		parent::prepareView();

		$this->data = $this->getModel()->getData();

		// Set page title
		ToolbarHelper::title(Text::_('OSM_STATISTICS'), 'bars');

		// Render submenus
		OSMembershipHelperHtml::renderSubmenu('statistics');
	}
}
