<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2010 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
?>
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                    <div class="osm-stat-number">
                        <div id="osm-total-revenue"><?php echo OSMembershipHelper::formatCurrency($this->totalRevenue, $this->config) . '+'; ?></div>
                    </div>
                    <div class="osm-state-label text-muted">
						<?php echo Text::_('OSM_TOTAL_REVENUE'); ?>
                    </div>
                </div>
                <div class="osm-dashboard-card-icon text-success">
                    <i class="fa fa-3x fa-dollar"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                    <div class="osm-stat-number">
                        <div id="osm-total-subscriptions"><?php echo $this->totalSubscriptions . '+'; ?></div>
                    </div>
                    <div class="osm-state-label text-muted">
						<?php echo Text::_('OSM_TOTAL_SUBSCRIPTIONS'); ?>
                    </div>
                </div>
                <div class="osm-dashboard-card-icon text-success">
                    <i class="fa fa-3x fa-file-contract"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                    <div class="osm-stat-number">
                        <div id="os-total-active-subscribers"><?php echo $this->totalActiveSubscriptions . '+'; ?></div>
                    </div>
                    <div class="osm-state-label text-muted">
						<?php echo Text::_('OSM_TOTAL_ACTIVE_SUBSCRIPTIONS'); ?>
                    </div>
                </div>
                <div class="osm-dashboard-card-icon text-success">
                    <i class="fa fa-3x fa-user-check"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                    <div class="osm-stat-number">
                        <div id="osm-total-refund-amount"><?php echo OSMembershipHelper::formatCurrency($this->totalRefundAmount, $this->config); ?></div>
                    </div>
                    <div class="osm-state-label text-muted">
						<?php echo Text::_('OSM_TOTAL_REFUND_AMOUNT'); ?>
                    </div>
                </div>
                <div class="osm-dashboard-card-icon text-success">
                    <i class="fa fa-3x fa-undo-alt"></i>
                </div>
            </div>
        </div>
    </div>
</div>