<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

/**
 * @property OSMembershipModelDashboard $model
 */
class OSMembershipViewDashboardHtml extends MPFViewHtml
{
	/**
	 * Total revenue
	 *
	 * @var float
	 */
	protected $totalRevenue = 0;

	/**
	 * Total number subscribers
	 *
	 * @var int
	 */
	protected $totalSubscriptions = 0;

	/**
	 * Total numbre subscriptions
	 *
	 * @var int
	 */
	protected $totalActiveSubscriptions = 0;

	/**
	 * Total refunded amount
	 *
	 * @var float
	 */
	protected $totalRefundAmount = 0;

	/**
	 * Store update result
	 *
	 * @var array
	 */
	protected $updateResult = [];

	/**
	 * Component config
	 *
	 * @var MPFConfig
	 */
	protected $config;

	/**
	 * Select list array
	 *
	 * @var array
	 */
	protected $lists;

	/**
	 * Latest subscriptions
	 *
	 * @var array
	 */
	protected $subscriptions = [];

	/**
	 * Daily revenue chart data
	 *
	 * @var array
	 */
	protected $dailyRevenueChartData = [];

	/**
	 * Monthly revenue chart data
	 *
	 * @var array
	 */
	protected $monthlyRevenueChartData = [];

	/**
	 * Revenue by payment method chart data
	 *
	 * @var array
	 */
	protected $revenueByPaymentMethodsChartData = [];

	/**
	 * Display the view
	 *
	 * @return void
	 */
	public function display()
	{
		$this->totalRevenue                     = $this->model->getTotalRevenue();
		$this->totalSubscriptions               = $this->model->getTotalSubscriptions();
		$this->totalActiveSubscriptions         = $this->model->getTotalActiveSubscriptions();
		$this->totalRefundAmount                = $this->model->getTotalRefundAmount();
		$this->subscriptions                    = $this->model->getLatestSubscriptions();
		$this->revenueByPaymentMethodsChartData = $this->model->getRevenueByPaymentMethodsChartData();

		$dailyRevenueChartData = $this->model->getDailyRevenueChartData();

		$this->dailyRevenueChartData = [
			'labels'   => $dailyRevenueChartData['labels'],
			'datasets' => [
				[
					'label'            => Text::_('OSM_TOTAL_REVENUE'),
					'data'             => $dailyRevenueChartData['total_revenue_dataset'],
					'borderColor'      => '#198754',
					'backgroundColor'  => '#198754',
					'tension'          => 0.3,
					'fill'             => false,
					'pointRadius'      => 4,
					'pointHoverRadius' => 6,
				]
			],
		];

		$hasRefundAmount = false;

		foreach ($dailyRevenueChartData['refund_amount_dataset'] as $refundAmount)
		{
			if ($refundAmount > 0)
			{
				$hasRefundAmount = true;
				break;
			}
		}

		if ($hasRefundAmount)
		{
			$this->dailyRevenueChartData['datasets'][] = [
				'label'            => Text::_('OSM_REFUND_AMOUNT'),
				'data'             => $dailyRevenueChartData['refund_amount_dataset'],
				'borderColor'      => '#FF6384',
				'backgroundColor'  => '#FF6384',
				'tension'          => 0.3,
				'fill'             => false,
				'pointRadius'      => 4,
				'pointHoverRadius' => 6,
			];
		}

		$monthlyRevenueChartData = $this->model->getMonthlyRevenueChartData();

		$this->monthlyRevenueChartData = [
			'labels'   => $monthlyRevenueChartData['labels'],
			'datasets' => [
				[
					'label'            => Text::_('OSM_TOTAL_REVENUE'),
					'data'             => $monthlyRevenueChartData['total_revenue_dataset'],
					'borderColor'      => '#198754',
					'backgroundColor'  => '#198754',
					'tension'          => 0.3,
					'fill'             => false,
					'pointRadius'      => 4,
					'pointHoverRadius' => 6,
				]
			],
		];

		$hasRefundAmount = false;

		foreach ($monthlyRevenueChartData['refund_amount_dataset'] as $refundAmount)
		{
			if ($refundAmount > 0)
			{
				$hasRefundAmount = true;
				break;
			}
		}

		if ($hasRefundAmount)
		{
			$this->monthlyRevenueChartData['datasets'][] = [
				'label'            => Text::_('OSM_REFUND_AMOUNT'),
				'data'             => $monthlyRevenueChartData['refund_amount_dataset'],
				'borderColor'      => '#FF6384',
				'backgroundColor'  => '#FF6384',
				'tension'          => 0.3,
				'fill'             => false,
				'pointRadius'      => 4,
				'pointHoverRadius' => 6,
			];
		}

		$this->config = OSMembershipHelper::getConfig();

		$state = $this->model->getState();

		// Filter Plans
		$options                       = [];
		$options[]                     = HTMLHelper::_('select.option', 0, Text::_('OSM_ALL_PLANS'), 'id', 'title');
		$options                       = array_merge($options, OSMembershipHelperDatabase::getAllPlans());
		$this->lists['filter_plan_id'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'filter_plan_id',
			'onchange="submit();" class="form-select d-inline-block w-30"',
			'id',
			'title',
			$state->get('filter_plan_id', 0)
		);

		// Filter Duration
		$options   = [];
		$options[] = HTMLHelper::_('select.option', '', Text::_('OSM_ALL_TIME'));
		$options[] = HTMLHelper::_('select.option', 'today', Text::_('OSM_TODAY'));
		$options[] = HTMLHelper::_('select.option', 'yesterday', Text::_('OSM_YESTERDAY'));
		$options[] = HTMLHelper::_('select.option', 'this_week', Text::_('OSM_THIS_WEEK'));
		$options[] = HTMLHelper::_('select.option', 'this_month', Text::_('OSM_THIS_MONTH'));
		$options[] = HTMLHelper::_('select.option', 'last_month', Text::_('OSM_LAST_MONTH'));
		$options[] = HTMLHelper::_('select.option', 'this_year', Text::_('OSM_THIS_YEAR'));
		$options[] = HTMLHelper::_('select.option', 'last_year', Text::_('OSM_LAST_YEAR'));

		$this->lists['filter_duration'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'filter_duration',
			'class="form-select d-inline-block w-30" onchange="submit();"',
			'value',
			'text',
			$state->get('filter_duration', ''),
		);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', '', Text::_('OSM_ALL_SUBSCRIPTIONS'));
		$options[] = HTMLHelper::_('select.option', 'subscribe', Text::_('OSM_NEW_SUBSCRIPTION'));
		$options[] = HTMLHelper::_('select.option', 'renew', Text::_('OSM_SUBSCRIPTION_RENEWAL'));
		$options[] = HTMLHelper::_('select.option', 'upgrade', Text::_('OSM_SUBSCRIPTION_UPGRADE'));

		$this->lists['filter_subscription_type'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'filter_subscription_type',
			'class="form-select d-inline-block w-30" onchange="submit();"',
			'value',
			'text',
			$state->get('filter_subscription_type', '')
		);

		// Render sub-menu in dashboard
		OSMembershipHelperHtml::renderSubmenu('dashboard');

		// Check update information
		$this->updateResult = $this->model->checkUpdate();

		if ($this->updateResult['status'] == 2)
		{
			Factory::getApplication()->enqueueMessage(
				Text::sprintf(
					'OSM_UPDATE_AVAILABLE',
					'index.php?option=com_installer&view=update',
					$this->updateResult['version']
				)
			);
		}

		parent::display();
	}
}
