<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class OSMembershipModelStatistics extends MPFModel
{
	/**
	 * Get statistic data
	 *
	 * @return array
	 */
	public function getData()
	{
		$data = [];

		$db    = $this->getDbo();
		$query = $db->getQuery(true)
			->select('COUNT(id) AS number_subscriptions, SUM(gross_amount) AS total_amount')
			->from('#__osmembership_subscribers');

		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('today');

		$query->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));

		$db->setQuery($query);
		$row = $db->loadObject();

		$data['today'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// Yesterday
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('yesterday');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['yesterday'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// This week
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('this_week');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['this_week'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// Last week
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('last_week');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['last_week'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// This month
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('this_month');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['this_month'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		$date              = Factory::getDate('now', Factory::getApplication()->get('offset'));
		$currentDayInMonth = $date->format('j');
		$numberDaysInMonth = $date->daysinmonth;

		$data['average_day_this_month'] = [
			'number_subscriptions' => $row->number_subscriptions / $currentDayInMonth,
			'total_amount'         => floatval($row->total_amount) / $currentDayInMonth,
		];

		$data['projection_this_month'] = [
			'number_subscriptions' => ($row->number_subscriptions * $numberDaysInMonth) / $currentDayInMonth,
			'total_amount'         => (floatval($row->total_amount) * $numberDaysInMonth) / $currentDayInMonth,
		];

		// Last month
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('last_month');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['last_month'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// This year
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('this_year');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['this_year'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// Last year
		[$fromDate, $toDate] = OSMembershipHelper::getDateDuration('last_year');

		$query->clear('where')
			->where('published IN (1,2)')
			->where('group_admin_id = 0')
			->where('created_date >= ' . $db->quote($fromDate))
			->where('created_date <=' . $db->quote($toDate));
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['last_year'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// Total subscription
		$query->clear()
			->select('COUNT(*) AS number_subscriptions, SUM(gross_amount) AS total_amount')
			->from('#__osmembership_subscribers')
			->where('group_admin_id = 0')
			->where('(published IN (1,2) OR (published = 0 AND payment_method LIKE "os_offline%"))');
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['total_subscriptions'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// Active subscriptions
		$query->clear()
			->select('COUNT(*) AS number_subscriptions, SUM(gross_amount) AS total_amount')
			->from('#__osmembership_subscribers')
			->where('group_admin_id = 0')
			->where('published = 1');
		$db->setQuery($query);
		$row = $db->loadObject();

		$data['active_subscriptions'] = [
			'number_subscriptions' => (int) $row->number_subscriptions,
			'total_amount'         => floatval($row->total_amount),
		];

		// Active subscribers
		$query->clear()
			->select('DISTINCT profile_id')
			->from('#__osmembership_subscribers')
			->where('group_admin_id = 0')
			->where('published = 1');
		$db->setQuery($query);
		$data['active_subscribers'] = [
			'number_subscriptions' => count($db->loadColumn()),
			'total_amount'         => 0,
		];

		return $data;
	}
}
