<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class JFormFieldOSMField extends ListField
{
	/**
	 * The form field type.
	 *
	 * @var string
	 */
	protected $type = 'osmfield';

	/**
	 * Method to get the list of options for the field.
	 *
	 * @return  array  The field option objects.
	 *
	 */
	protected function getOptions()
	{
		/* @var \Joomla\Database\DatabaseDriver $db */
		$db = Factory::getContainer()->get('db');

		$keyField = (string) $this->element['keyField'] ?: 'id';

		$query = $db->getQuery(true)
			->select($db->quoteName($keyField, 'value'))
			->select($db->quoteName('title', 'text'))
			->from('#__eb_fields')
			->where('published = 1')
			->order('title');
		$db->setQuery($query);

		$options = [];

		if ($keyField === 'name')
		{
			$options[] = HTMLHelper::_('select.option', '', Text::_('Select Field'));
		}
		else
		{
			$options[] = HTMLHelper::_('select.option', 0, Text::_('Select Field'));
		}

		return array_merge($options, $db->loadObjectList());
	}
}
