<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Joomla\CMS\HTML\HTMLHelper;

defined('_JEXEC') or die;

$listOrder     = $this->state->get('list.ordering');
$listDirection = $this->state->get('list.direction');

?>
<th class="hidden-phone center">
    <?php echo HTMLHelper::_(
        'grid.sort',
        'COM_OSDOWNLOADS_FIELD_CONFIRMED_LABEL',
        'email.confirmed',
        $listDirection,
        $listOrder
    ); ?>
</th>
<th scope="col" class="hidden-phone d-none d-md-table-cell center text-center">
    <?php echo HTMLHelper::_(
        'grid.sort',
        'COM_OSDOWNLOADS_FIELD_SYNCED_LABEL',
        'email.synced',
        $listDirection,
        $listOrder
    ); ?>
</th>
<th scope="col" class="center text-center">
    <?php echo HTMLHelper::_(
        'grid.sort',
        'COM_OSDOWNLOADS_FIELD_CUSTOM_FIELDS_LABEL',
        'has_custom_fields',
        $listDirection,
        $listOrder
    ); ?>
</th>
