<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Alledia\OSDownloads\Free\Installer\AbstractScript;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Table\Table;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

$installPath = __DIR__ . (is_dir(__DIR__ . '/admin') ? '/admin' : '');
$installPath .= '/library/Free/Installer/AbstractScript.php';

require_once $installPath;

// phpcs:enable PSR1.Files.SideEffects
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace
// phpcs:disable Squiz.Classes.ValidClassName.NotCamelCaps

class Com_OsdownloadsInstallerScript extends AbstractScript
{
    /**
     * @inheritDoc
     */
    protected function customPreFlight(string $type, InstallerAdapter $parent): bool
    {
        // Special case for previous minimum version due to database management changes
        if ($type == 'update') {
            $previousVariant = $this->previousManifest->variant;
            $previousVersion = $this->previousManifest->version;
            if ($previousVariant == 'FREE' && version_compare($previousVersion, '1.13.1', 'lt')) {
                $updateLink = Route::_('index.php?option=com_installer&view=update');

                $this->sendErrorMessage(
                    new Exception(
                        Text::sprintf('COM_OSDOWNLOADS_ERROR_UPDATE_FREE_INSTALLATION', $updateLink)
                    )
                );

                return false;
            }
        }

        return true;
    }

    /**
     * @inheritDoc
     */
    protected function customPostFlight($type, $parent): void
    {
        parent::customPostFlight($type, $parent);

        if ($type != 'uninstall') {
            $this->checkPlugins();
        }
    }

    /**
     * Ensure required plugins are enabled
     *
     * @return void
     */
    protected function checkPlugins()
    {
        $extension = Table::getInstance('Extension');

        $extension->load([
            'type'    => 'plugin',
            'element' => 'osdownloads',
            'folder'  => 'content',
        ]);

        $eid     = $extension->get('extension_id');
        $enabled = (bool)$extension->get('enabled');
        if ($eid) {
            if (!$enabled) {
                $extension->enabled = 1;
                $extension->store();
            }

        } else {
            $this->sendMessage(Text::_('COM_OSDOWNLOADS_ERROR_CONTENT_PLUGIN'), 'warning');
        }
    }
}
