<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2018-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\MailingList\AcyMailing;

// phpcs:disable PSR1.Files.SideEffects
use AcyMailing\Classes\ListClass;
use AcyMailing\Classes\UserClass;

defined('_JEXEC') or die();

// phpcs:enable PSR1.Files.SideEffects

class V10 extends AbstractVersion
{
    /**
     * @inheritDoc
     */
    public function getLists(): array
    {
        return (new ListClass())->getAll();
    }

    /**
     * @inheritDoc
     */
    public function subscribe(object $user, array $lists): bool
    {
        $success = false;
        if (empty($user->id) == false) {
            $lists = array_filter($lists);
            if ($lists == false) {
                $success = true;

            } else {
                $userClass = new UserClass();
                $userClass->subscribe($user->id, $lists);

                $subscriptions = array_map(
                    function (object $list) {
                        return $list->id;
                    },
                    $userClass->getUsersSubscriptionsByIds([$user->id])
                );

                $success = count(array_intersect($lists, $subscriptions)) > 0;
            }
        }

        return $success;
    }

    /**
     * @inheritDoc
     */
    public function getUser(string $email, int $confirmed, ?int $userId): object
    {
        $acyUser = new UserClass();

        $user = $acyUser->getOneByEmail($email);
        if ($user == false) {
            $user = (object)[
                'email'     => $email,
                'confirmed' => $confirmed,
            ];

            $acyUserId = $acyUser->save($user);
            $user      = $acyUser->getOneById($acyUserId);

        } else {
            $acyUser->save($user);
        }

        return $user;
    }
}
