<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2019-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\MailingList\AcyMailing;

// phpcs:disable PSR1.Files.SideEffects
use AcyMailing\Classes\ConfigurationClass;

defined('_JEXEC') or die();

class_alias(V6::class, V7::class);
class_alias(V6::class, V8::class);
class_alias(V6::class, V9::class);

// phpcs:enable PSR1.Files.SideEffects

abstract class AbstractVersion
{
    /**
     * @var static
     */
    protected static $instance = null;

    /**
     * @var \cpanelClass|\acymconfigurationClass
     */
    protected static $config = null;

    /**
     * @return ?AbstractVersion
     */
    public static function getInstance(): ?AbstractVersion
    {
        if (static::$config === null) {
            $version5  = JPATH_ADMINISTRATOR . '/components/com_acymailing/helpers/helper.php';
            $version6  = JPATH_ADMINISTRATOR . '/components/com_acym/helpers/helper.php';
            $version10 = JPATH_ADMINISTRATOR . '/components/com_acym/Core/init.php';

            if (is_file($version10)) {
                require_once $version10;

                static::$config = new ConfigurationClass();
                static::$config->load();

            } elseif (is_file($version5)) {
                require_once $version5;

                /** @var \cpanelClass $config */
                static::$config = acymailing_config();

            } elseif (is_file($version6)) {
                require_once $version6;

                /** @var \acymconfigurationClass $config */
                static::$config = acym_config();
            }

            if (static::$config) {
                $version = explode('.', static::$config->get('version'));
                $version = array_shift($version);
                if ($version) {
                    $versionClass = __NAMESPACE__ . '\\V' . $version;
                }
            }
        }

        if (static::$instance === null) {
            if (empty($versionClass) == false && class_exists($versionClass)) {
                static::$instance = new $versionClass();
            }
        }

        return static::$instance;
    }

    /**
     * @return object[]
     */
    abstract public function getLists(): array;

    /**
     * Get/Create user in AcyMailing user list
     *
     * @param string $email
     * @param int    $confirmed
     * @param ?int   $userId
     *
     * @return object
     */
    abstract public function getUser(string $email, int $confirmed, ?int $userId): object;

    /**
     * @param object $user
     * @param int[]  $lists
     *
     * @return bool
     */
    abstract public function subscribe(object $user, array $lists): bool;
}
