<?php

/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\Joomla\Model;

use Alledia\Framework\Factory;
use Alledia\OSDownloads\Free\Joomla\Component\Site as FreeComponentSite;
use Alledia\OSDownloads\Free\Joomla\Model\Item as FreeItem;
use Joomla\Database\DatabaseQuery;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

// phpcs:enable PSR1.Files.SideEffects

class Item extends FreeItem
{
    /**
     * @inheritDoc
     */
    public function getItemQuery(?int $documentId = null): DatabaseQuery
    {
        $db        = $this->getDbo();
        $query     = parent::getItemQuery($documentId);
        $date      = Factory::getDate();
        $component = FreeComponentSite::getInstance();

        $today = $date->toSql();

        $today = $db->quote($today);

        $query->where([
            "(ISNULL(doc.publish_up) OR doc.publish_up <= {$today})",
            "(ISNULL(doc.publish_down) OR doc.publish_down >= {$today})",
        ]);

        // Override the require_email data based on the require_email_only_guest param
        $requireEmailOnlyGuest = (bool)$component->params->get('require_email_only_guest', true);
        $requireEmailOverride  = 'doc.require_email';
        if ($requireEmailOnlyGuest && !Factory::getUser()->guest) {
            $requireEmailOverride = '0';
        }
        $query->select("{$requireEmailOverride} AS require_user_email");

        return $query;
    }

    /**
     * @inheritDoc
     */
    public function incrementDownloadCount(int $id)
    {
        parent::incrementDownloadCount($id);

        $user = Factory::getUser();
        $db   = $this->getDbo();

        $query = $db->getQuery(true)
            ->insert('#__osdownloads_download_log')
            ->set('document_id = ' . $id)
            ->set('download_on = NOW()')
            ->set('user_id = ' . $db->quote((int)$user->id));
        $db->setQuery($query);
        $db->execute();
    }
}
