<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\Helper;

use Alledia\OSDownloads\Factory;
use Alledia\OSDownloads\Free\Helper\Helper as FreeHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

// phpcs:enable PSR1.Files.SideEffects

class Helper extends FreeHelper
{
    /**
     * @inheritDoc
     * @throws \Exception
     */
    public static function displayAdminMessages()
    {
        parent::displayAdminMessages();

        if (empty(PluginHelper::getPlugin('content', 'osdownloads'))) {
            Factory::getApplication()->enqueueMessage(Text::_('COM_OSDOWNLOADS_ERROR_CONTENT_PLUGIN'), 'warning');
        }
    }

    /**
     * @inheritDoc
     */
    public static function addSubmenu(string $vName): void
    {
        parent::addSubmenu($vName);

        if (ComponentHelper::isEnabled('com_osdownloads')) {
            // Get the context defined in the URL
            $context = Factory::getApplication()->input->getCmd('context');

            if (empty($context)) {
                BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_fields/models');
                $model = BaseDatabaseModel::getInstance('Fields', 'FieldsModel');
                if (is_object($model)) {
                    $context = $model->getState('filter.context');
                }
            }

            if (ComponentHelper::isEnabled('com_fields')) {
                Sidebar::addEntry(
                    Text::_('COM_OSDOWNLOADS_FILE_FIELDS'),
                    'index.php?option=com_fields&view=fields&context=com_osdownloads.file',
                    'fields.fields' === $vName && 'com_osdownloads.file' === $context
                );

                Sidebar::addEntry(
                    Text::_('COM_OSDOWNLOADS_FILE_FIELD_GROUPS'),
                    'index.php?option=com_fields&view=groups&context=com_osdownloads.file',
                    'fields.groups' === $vName && 'com_osdownloads.file' === $context
                );

                Sidebar::addEntry(
                    Text::_('COM_OSDOWNLOADS_DOWNLOAD_FIELDS'),
                    'index.php?option=com_fields&view=fields&context=com_osdownloads.download',
                    'fields.fields' === $vName && 'com_osdownloads.download' === $context
                );

                Sidebar::addEntry(
                    Text::_('COM_OSDOWNLOADS_DOWNLOAD_FIELD_GROUPS'),
                    'index.php?option=com_fields&view=groups&context=com_osdownloads.download',
                    'fields.groups' === $vName && 'com_osdownloads.download' === $context
                );

            } else {
                Sidebar::addEntry(
                    sprintf(
                        '<div class="alert alert-info">%s</div>',
                        Text::_('COM_OSDOWNLOADS_WARN_CUSTOM_FIELDS_DISABLED')
                    )
                );
            }
        }
    }

    /**
     * @inheritDoc
     */
    public static function getContexts(): array
    {
        Factory::getLanguage()->load('com_osdownloads', JPATH_ADMINISTRATOR);

        return [
            'com_osdownloads.file' => Text::_('COM_OSDOWNLOADS_FILE'),
        ];
    }
}
