<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

require_once __DIR__ . '/AbstractFormFieldMailChimp.php';

// phpcs:enable PSR1.Files.SideEffects
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

class OsdownloadsFormFieldMailchimplist extends AbstractFormFieldMailChimp
{
    /**
     * @inheritdoc
     */
    protected $type = 'osdownloads.mailchimplist';

    /**
     * @var FormField
     */
    protected $category = null;

    /**
     * @inheritDoc
     */
    protected function getMailchimpOptions(): array
    {
        if ($this->mailchimpOptions === null) {
            $this->mailchimpOptions = [];

            try {
                $lists = $this->getMailchimpLists();
                if ($lists) {
                    foreach ($lists as $list) {
                        $this->mailchimpOptions[] = HTMLHelper::_('select.option', $list->id, $list->name);
                    }

                } else {
                    throw new Exception(Text::_('COM_OSDOWNLOADS_ML_MAILCHIMP_NO_LISTS'));
                }

            } catch (Throwable $error) {
                $this->setError($error);
            }
        }

        return $this->mailchimpOptions;
    }

    protected function getOptions()
    {
        $options = parent::getOptions();

        $this->checkUseGlobal('mailinglist.mailchimp.' . $this->fieldname, $options);

        return $options;
    }
}
