<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Alledia\OSDownloads\Pro\MailingList\AcyMailing;
use Joomla\CMS\HTML\HTMLHelper;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

require_once __DIR__ . '/AbstractFormFieldMailingList.php';

// phpcs:enable PSR1.Files.SideEffects
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

class OsdownloadsFormFieldAcymailinglist extends AbstractFormFieldMailingList
{
    /**
     * @inheritDoc
     */
    public function setup(SimpleXMLElement $element, $value, $group = null)
    {
        if (parent::setup($element, $value, $group)) {
            return $this->isMailingListEnabled('acymailing');
        }

        return false;
    }

    /**
     * @inheritDoc
     */
    protected function getInput()
    {
        if ($this->value) {
            if (count($this->value) > 1) {
                $this->value = array_filter($this->value);
            }
        }

        return parent::getInput();
    }

    /**
     * @inheritDoc
     */
    protected function getOptions()
    {
        $options = [];

        try {
            $lists = AcyMailing::getLists();

            foreach ($lists as $list) {
                $options[] = HTMLHelper::_('select.option', $list->id, $list->name);
            }

        } catch (Throwable $error) {
            $this->app->enqueueMessage($error->getMessage(), 'error');
        }

        $options = array_merge(parent::getOptions(), $options);
        $this->checkUseGlobal('mailinglist.acymailing.' . $this->fieldname, $options);

        return $options;
    }
}
