<?php
/*------------------------------------------------------------------------
# room.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

class HTML_OSappscheduleRoom{
	/**
	 * List Rooms
	 *
	 * @param unknown_type $property
	 * @param unknown_type $rows
	 * @param unknown_type $pageNav
	 */
	static function listRooms($property,$rows,$pageNav,$lists){
		global $mainframe,$configClass,$cClass;
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
        if($cClass['allow_room'] == 1) {
            JToolbarHelper::title($title . " > " . JText::_('OS_MANAGE_ROOMS'));
            JToolbarHelper::addNew('room_addnew');
            JToolbarHelper::editList('room_edit');
            JToolbarHelper::publish('room_publish');
            JToolbarHelper::unpublish('room_unpublish');
            JToolbarHelper::deleteList(JText::_('OS_ARE_YOU_SURE_TO_REMOVE_ITEM'),'room_remove');
        }else{
            JToolbarHelper::editList('room_edit');
            JToolbarHelper::title($title . " > " . JText::_('OS_GENERAL_MANAGE'));
        }
		JToolbarHelper::cancel('room_gotolistproperties');
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		?>
		<form method="POST" action="index.php?option=com_oscalendar&task=room_list&pid=<?php echo $property->id;?>" name="adminForm" id="adminForm" >
		<table  width="100%" class="adminlist table table-striped">
			<thead>
				<tr>
                    <?php
                    if($cClass['allow_room'] == 1) {
                    ?>
                        <th width="2%" style="text-align:center;">#</th>
                        <th width="3%" style="text-align:center;">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                        </th>
                        <th width="10%" style="text-align:center;">
                            <?php echo JText::_('OS_ROOM_IMAGE');?>
                        </th>
                    <?php } ?>
                    <?php
                    if($cClass['allow_room'] == 1) {
                    ?>
                        <th width="20%" style="text-align:center;">
                            <?php echo JHTML::_('grid.sort',   JText::_('OS_ROOM_NAME'), 'room_name', @$lists['order_Dir'], @$lists['order'] ,'room_list'); ?>
                        </th>
                    <?php } else {
                    ?>
                        <th width="20%" style="text-align:center;">
                            <?php echo JText::_('OS_PROPERTY'); ?>
                        </th>
                    <?php
                    }
                    ?>
					<th width="5%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_ADULT'), 'max_adult', @$lists['order_Dir'], @$lists['order'] ,'room_list'); ?>
					</th>
					<th width="5%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_CHILD'), 'max_child', @$lists['order_Dir'], @$lists['order'] ,'room_list'); ?>
					</th>
                    <?php
                    if($cClass['allow_room'] == 1) {
                    ?>
					<th width="15%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_NUMBER_ROOMS'), 'room_number', @$lists['order_Dir'], @$lists['order'] ,'room_list'); ?>
					</th>

					<th width="15%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',  JText::_('OS_ORDERING'), 'ordering', @$lists['order_Dir'], @$lists['order'],'room_list' ); ?>
						<?php echo JHTML::_('grid.order',  $rows ,"filesave.png","room_saveorder"); ?>
					</th>
					<th width="5%" style="text-align:center;">
						<?php echo JText::_('OS_PUBLISHED');?>
					</th>
					<th width="5%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   'ID', 'id', @$lists['order_Dir'], @$lists['order'] ,'room_list'); ?>
					</th>
                    <?php } ?>
					<th width="10%" style="text-align:center;">
						<?php echo JText::_('OS_PRICE');?>
					</th>	
					<th width="5%" style="text-align:center;">
						<?php echo JText::_('OS_AVAILABILITY');?>
					</th>								
				</tr>
			</thead>
            <?php
            if($cClass['allow_room'] == 1) {
            ?>
			<tfoot>
				<tr>
					<td width="100%" colspan="12" style="text-align:center;">
						<?php
							echo $pageNav->getListFooter();
						?>
					</td>
				</tr>
			</tfoot>
            <?php } ?>
			<tbody>
				<?php
				$db = JFactory::getDbo();
				$k = 0;
				for ($i=0, $n=count($rows); $i < $n; $i++) {
					$row 		= $rows[$i];
					$checked 	= JHtml::_('grid.id', $i, $row->id);
					$link 		= JRoute::_( 'index.php?option=com_oscalendar&pid='.$property->id.'&task=room_edit&cid[]='. $row->id );
					$published 	= JHTML::_('jgrid.published', $row->published, $i , 'room_');
					?>
					<tr class="<?php echo "row$k"; ?>">
                        <?php
                        if($cClass['allow_room'] == 1) {
                        ?>
                            <td align="center" style="text-align:center;"><?php echo $pageNav->getRowOffset( $i ); ?></td>
                            <td align="center" style="text-align:center;"><?php echo $checked; ?></td>
                            <td style="text-align:center;width:80px;">
                                <?php
                                if($row->room_image != ""){
                                    ?>
                                    <img src="<?php echo JURI::root()?>images/oscalendar/rooms/thumb/<?php echo $row->room_image?>" width="80"/>
                                    <?php
                                }else{
                                    ?>
                                    <img src="<?php echo JURI::root()?>components/com_osproperty/images/assets/nopropertyphoto.png" width="80"/>
                                    <?php
                                }
                                ?>
                            </td>
                        <?php } ?>
                        <?php
                        if($cClass['allow_room'] == 1) {
                            ?>
                            <td style="text-align:left;padding:10px;"><a href="<?php echo $link?>"><?php echo $row->room_name?></a></td>
						<?php } else {
                            ?>
                            <td style="text-align:left;padding:10px;"><a href="<?php echo $link?>"><?php echo $property->pro_name; ?></a></td>
                            <?php
                        }?>
						<td style="text-align:center;"><?php echo $row->max_adult?></td>
						<td style="text-align:center;"><?php echo $row->max_child?></td>
                        <?php
                        if($cClass['allow_room'] == 1) {
                        ?>
						    <td style="text-align:center;"><?php echo $row->room_number?></td>
                            <td align="center" class="order">
                                <?php
                                $ordering = "ordering";
                                ?>
                                <span><?php echo $pageNav->orderUpIcon($i,$row->ordering == 0 || $row->ordering == @$rows[$i-1]->ordering, 'room_orderup', 'JLIB_HTML_MOVE_UP', $ordering); ?></span>
                                <span><?php echo $pageNav->orderDownIcon($i, $n,  $row->ordering == 0 || $row->ordering == @$rows[$i+1]->ordering, 'room_orderdown', 'JLIB_HTML_MOVE_DOWN', $ordering); ?></span>
                                <input type="text" name="order[]"  value="<?php echo $row->ordering; ?>" class="text-area-order input-mini" style="text-align: center;width:40px;" />
                            </td>
                            <td style="text-align:center;"><?php echo $published?></td>
                            <td style="text-align:center;"><?php echo $row->id;?></td>
                        <?php } ?>
						<td style="text-align:center;">
							<a href="index.php?option=com_oscalendar&task=price_setup&rid=<?php echo $row->id?>&pid=<?php echo $property->id;?>" title="<?php echo JText::_('OS_SETUP_PRICE');?>">
								<img src="<?php echo JURI::root()?>components/com_oscalendar/style/images/price.png" width="30"/>
							</a>
						</td>
						<td style="text-align:center;">
							<a href="index.php?option=com_oscalendar&task=property_calendarmanage&rid=<?php echo $row->id?>&pid=<?php echo $property->id;?>" title="<?php echo JText::_('OS_MANAGE_AVAILABILITY_STATUS_FOR_THIS_ROOM');?>">
								<img src="<?php echo JURI::root()?>components/com_oscalendar/style/images/calendar.png" width="16"/>
							</a>
						</td>
					</tr>
				<?php
					$k = 1 - $k;	
				}
				?>
			</tbody>
		</table>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="room_list" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
		</form>
		<?php
	}
	
	/**
	 * Edit room
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	static function editRoom($property,$row,$lists,$translatable){
		global $mainframe,$configClass,$cClass,$languages;
		$db = JFactory::getDBO();
		if($row->id > 0){
			$edit = JText::_('OS_EDIT');
		}else{
			$edit = JText::_('OS_ADD');
		}
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
        if($cClass['allow_room'] == 1) {
            JToolbarHelper::title($title . " > " . JText::_('OS_ROOM') . " > " . JText::_($edit));
        }else{
            JToolbarHelper::title($title);
        }
		JToolBarHelper::save('room_save');
		JToolBarHelper::apply('room_apply');
		JToolBarHelper::cancel('room_gotoroomlist');
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<?php 
		if (($translatable) and ($cClass['allow_room'] == 1))
		{
		?>
			<ul class="nav nav-tabs">
				<li class="active"><a href="#general-page" data-toggle="tab"><?php echo JText::_('OS_GENERAL'); ?></a></li>
				<li><a href="#translation-page" data-toggle="tab"><?php echo JText::_('OS_TRANSLATION'); ?></a></li>									
			</ul>		
			<div class="tab-content">
				<div class="tab-pane active" id="general-page">			
		<?php	
		}
		?>
			<table width="100%" class="admintable">
                <?php
                if($cClass['allow_room'] == 1){
                ?>
				<tr>
					<td class="key">
						<?php echo JText::_('OS_ROOM_NAME')?>:
					</td>
					<td>
						<input type="text" name="room_name" id="room_name" class="input-large form-control" size="40" value="<?php echo $row->room_name;?>" />
					</td>
				</tr>
				<tr>
					<td class="key" valign="top">
						<?php echo JText::_('OS_PHOTO')?>
					</td>
					<td>
						<?php
						if($row->room_image){
							?>
							<a href="<?php echo JURI::root()?>images/oscalendar/rooms/<?php echo $row->room_image?>" class="modal">
								<img src="<?php echo JURI::root()?>images/oscalendar/rooms/thumb/<?php echo $row->room_image?>" class="img-polaroid" />
							</a>
							<BR>
							<input type="checkbox" name="remove_photo" id="remove_photo" value="0" onclick="javascript:changeValue('remove_photo')" /> &nbsp;<b><?php echo JText::_('OS_REMOVE_PHOTO');?></b><BR />
							<?php
						}
						?>
						<input type="file" name="photo" id="photo" size="40" onchange="javascript:checkUploadPhotoFiles('photo')"> (Only allow: *.jpg, *.jpeg)
					</td>
				</tr>
				<tr>
					<td class="key">
						<?php echo JText::_('OS_NUMBER_ROOM')?>:
					</td>
					<td>
						<input type="text" name="room_number" id="room_number" class="input-mini form-control" value="<?php echo $row->room_number;?>" />
					</td>
				</tr>
				<?php } ?>
				<tr>
					<td class="key">
						<?php echo JText::_('OS_MAX_ADULT')?>:
					</td>
					<td>
						<input type="text" name="max_adult" id="max_adult" class="input-mini form-control" value="<?php echo $row->max_adult;?>" />
					</td>
				</tr>
				<tr>
					<td class="key">
						<?php echo JText::_('OS_MAX_CHILD')?>:
					</td>
					<td>
						<input type="text" name="max_child" id="max_child" class="input-mini form-control" value="<?php echo $row->max_child;?>" />
					</td>
				</tr>
                <?php
                if($cClass['allow_room'] == 1){
                    ?>
                    <tr>
                        <td class="key">
                            <?php echo JText::_('OS_STATE')?>:
                        </td>
                        <td>
                            <?php echo $lists['state'];?>
                        </td>
                    </tr>
                    <tr>
                        <td class="key" valign="top">
                            <?php echo JText::_('OS_DESCRIPTION')?>:
                        </td>
                        <td>
                            <textarea name="room_desc" cols="50" rows="5" class="form-control"><?php echo $row->room_desc;?></textarea>
                        </td>
                    </tr>
                <?php } ?>
			</table>
		<?php
        if (($translatable) and ($cClass['allow_room'] == 1))
		{
		?>
		</div>
			<div class="tab-pane" id="translation-page">
				<ul class="nav nav-tabs">
					<?php
						$i = 0;
						foreach ($languages as $language) {						
							$sef = $language->sef;
							?>
							<li <?php echo $i == 0 ? 'class="active"' : ''; ?>><a href="#translation-page-<?php echo $sef; ?>" data-toggle="tab"><?php echo $language->title; ?>
								<img src="<?php echo JURI::root(); ?>media/com_osproperty/flags/<?php echo $sef.'.png'; ?>" /></a></li>
							<?php
							$i++;	
						}
					?>			
				</ul>		
				<div class="tab-content">			
					<?php	
						$i = 0;
						foreach ($languages as $language)
						{												
							$sef = $language->sef;
						?>
							<div class="tab-pane<?php echo $i == 0 ? ' active' : ''; ?>" id="translation-page-<?php echo $sef; ?>">													
								<table width="100%" class="admintable" style="background-color:white;">
									<tr>
										<td class="key"><?php echo JText::_('OS_ROOM_NAME'); ?></td>
										<td >
											<input type="text" name="room_name_<?php echo $sef; ?>" id="room_name_<?php echo $sef; ?>" size="40" value="<?php echo $row->{'room_name_'.$sef}?>" />
										</td>
									</tr>
									<tr>
										<td class="key" valign="top">
											<?php echo JText::_('OS_DESCRIPTION')?>
										</td>
										<td>
											<textarea name="room_desc_<?php echo $sef; ?>" cols="50" rows="5"><?php echo $row->{'room_desc_'.$sef};?></textarea>
										</td>
									</tr>
								</table>
							</div>										
						<?php				
							$i++;		
						}
					?>
				</div>	
		</div>
		<?php				
		}
		?>
		<input type="hidden" name="MAX_FILE_SIZE" value="90000000" />
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="id" value="<?php echo $row->id?>" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		</form>
		<?php
	}
}
?>