<?php
/*------------------------------------------------------------------------
# report.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

/**
 * Enter description here...
 *
 */
class OSappscheduleReport{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe;
		$mainframe = JFactory::getApplication();
		$cid = $mainframe->input->get( 'cid', array(0),'array');
		\Joomla\Utilities\ArrayHelper::toInteger($cid, array(0));		
		switch ($task){
			default:
			case "report_default":
				OSappscheduleReport::reportForm();
			break;
			case "report_export":
				OSappscheduleReport::export();
			break;
		}
	}
	
	/**
	 * Show the report criteria form
	 *
	 */
	static function reportForm(){
		global $mainframe,$configClass,$cClass;
		//include_once(JPATH_ADMINISTRATOR."/components/com_osproperty/classes/property.php");
		$db = JFactory::getDbo();
		//property types
		$pro_type = $mainframe->input->getInt('pro_type',0);
		$typeArr[] = JHTML::_('select.option','',JText::_('OS_ALL_PROPERTY_TYPES'));
		$db->setQuery("Select id as value,type_name as text from #__osrs_types where published = '1' order by type_name");
		$protypes = $db->loadObjectList();
		$typeArr   = array_merge($typeArr,$protypes);
		$lists['type'] = JHTML::_('select.genericlist',$typeArr,'pro_type','class="input-large form-control form-select"','value','text',$pro_type);
		include(JPATH_ADMINISTRATOR.'/components/com_osproperty/classes/property.php');
		$category_id = $mainframe->input->getInt('category_id',0);
		$lists['category'] = OspropertyProperties::listFilterCategories($category_id,'');
		
		$payment = $mainframe->input->getString('payment','');
		$db->setQuery("Select name as value, title as text from #__oscalendar_plugins where published = '1'");
		$plugins = $db->loadObjectList();
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','',JText::_('OS_ALL_PAYMENT_PLUGINS'));
		$optionArr = array_merge($optionArr,$plugins);
		$lists['plugins'] = JHTML::_('select.genericlist',$optionArr,'payment','class="input-medium form-control form-select"','value','text');
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','',JText::_('OS_ALL_STATUS'));
		$optionArr[] = JHTML::_('select.option','P',JText::_('OS_PENDING'));
		$optionArr[] = JHTML::_('select.option','S',JText::_('OS_COMPLETE'));
		$optionArr[] = JHTML::_('select.option','C',JText::_('OS_CANCEL'));
		$lists['status'] = JHTML::_('select.genericlist',$optionArr,'order_status','class="input-small form-control form-select"','value','text');
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','0',JText::_('OS_NO'));
		$optionArr[] = JHTML::_('select.option','1',JText::_('OS_YES'));
		$lists['details'] = JHTML::_('select.genericlist',$optionArr,'report_details','class="input-mini form-control form-select"','value','text');
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','b.order_date',JText::_('OS_ORDER_DATE'));
		$optionArr[] = JHTML::_('select.option','b.book_from',JText::_('OS_CALENDAR_CHECK_IN'));
		$optionArr[] = JHTML::_('select.option','b.book_to',JText::_('OS_CALENDAR_CHECK_OUT'));
		$optionArr[] = JHTML::_('select.option','b.order_status',JText::_('OS_CALENDAR_ORDER_STATUS'));
		$optionArr[] = JHTML::_('select.option','b.total',JText::_('OS_TOTAL_AMOUNT'));
		$optionArr[] = JHTML::_('select.option','a.pro_name',JText::_('OS_PROPERTY_TITLE'));
		$optionArr[] = JHTML::_('select.option','agent_name',JText::_('OS_AGENT_NAME'));
		$optionArr[] = JHTML::_('select.option','b.name',JText::_('OS_CUSTOMER_NAME'));
		$lists['sortby'] = JHTML::_('select.genericlist',$optionArr,'sortby','class="input-medium form-control form-select"','value','text');
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','desc',JText::_('OS_DESCENDING'));
		$optionArr[] = JHTML::_('select.option','asc',JText::_('OS_ASCENDING'));
		$lists['orderby'] = JHTML::_('select.genericlist',$optionArr,'orderby','class="input-medium form-control form-select"','value','text');
		
		HTML_OSappscheduleReport::exportReport($lists);
	}
	
	/**
	 * Export report
	 *
	 */
	static function export(){
		global $mainframe;
		$db = JFactory::getDbo();
		$category_id 		= $mainframe->input->getInt('category_id',0);
		$pro_type 			= $mainframe->input->getInt('pro_type',0);
		$payment			= $mainframe->input->getString('payment','');
		$order_status		= $mainframe->input->getString('order_status','');
		$report_details		= $mainframe->input->getInt('report_details',0);
		$pid				= $mainframe->input->getInt('pid',0);
		$agent_id			= $mainframe->input->get('agent_id',0);
		$book_from			= $mainframe->input->getString('book_from','');
		$book_to			= $mainframe->input->getString('book_to','');
		$sortby				= $mainframe->input->getString('sortby','desc');
		$orderby			= $mainframe->input->getString('orderby','a.order_date');
		//list record 
		$query = " SELECT a.*,d.room_name,b.nroom,b.id AS order_id, b.book_from,b.book_to, b.payment_method,b.room_fee, b.amount, b.deposit,b.tax, b.curr,b.name, b.email,b.phone, b.notes, b.order_status, b.order_date,b.pid,b.nAdults,b.nChilds,b.total,c.name as agent_name "
				." FROM #__osrs_properties as a "
				." INNER JOIN #__oscalendar_booking as b ON b.pid = a.id "
				." INNER JOIN #__osrs_agents AS c on c.id = a.agent_id"
				." INNER JOIN #__oscalendar_rooms as d ON b.rid = d.id "
				." WHERE 1=1";
		if($category_id > 0){
			$query .= " and a.id in (Select pid from #__osrs_property_categories where category_id = '$category_id') ";
		}
		if($pro_type > 0){
			$query .= " and pro_type = '$pro_type'";
		}
		if($pid > 0){
			$query .= " and b.pid = '$pid'";
		}
		if($agent_id > 0){
			$query .= " and a.agent_id = '$agent_id'";
		}
		if($payment != ""){
			$query .= " and b.payment_method like '$payment'";
		}
		if($order_status != ""){
			$query .= " and b.order_status like '$order_status'";
		}
		if($book_from != ""){
			$query .= " and b.order_date >= '$book_from'";
		}
		if($book_to != ""){
			$query .= " and b.order_date <= '$book_to'";
		}
		$query .= " ORDER BY $sortby $orderby";
		$db->setQuery($query);
		//echo $db->getQuery();
		$rows = $db->loadObjectList();
		
		$query = "Select * from #__oscalendar_fields where published = '1'";
		$db->setQuery($query);
		$fields = $db->loadObjectList();
		HTML_OSappscheduleReport::genericReport($rows,$fields);
	}
	
	static function getUserInput($agent_id = 0){
		// Initialize variables.
		$html = array();
		$link = 'index.php?option=com_osproperty&amp;task=agent_list&amp;&amp;tmpl=component&amp;field=agent_id';
		// Initialize some field attributes.
		$attr = ' class="inputbox"';
		// Load the modal behavior script.
		if(OSPHelper::isJoomla4())
		{
			OSPHelperJquery::colorbox('modal');
			OSPHelperJquery::colorbox('modal_user_id');

			// Build the script.
			$script = array();
			$script[] = '	function jSelectUser_agent_id(id, title) {';
			$script[] = '		var old_id = document.getElementById("agent_id").value;';
			$script[] = '		if (old_id != id) {';
			$script[] = '			document.getElementById("agent_id").value = id;';
			$script[] = '			document.getElementById("agent_id_name").value = title;';
			$script[] = '			' . $onchange;
			$script[] = '		}';
			$script[] = '		parent.jQuery.colorbox.close(); return false;';
			$script[] = '	}';
		}
		else
		{
			JHtml::_('behavior.modal');
			JHtml::_('behavior.modal', 'a.modal_user_id');

			// Build the script.
			$script = array();
			$script[] = '	function jSelectUser_agent_id(id, title) {';
			$script[] = '		var old_id = document.getElementById("agent_id").value;';
			$script[] = '		if (old_id != id) {';
			$script[] = '			document.getElementById("agent_id").value = id;';
			$script[] = '			document.getElementById("agent_id_name").value = title;';
			$script[] = '			' . $onchange;
			$script[] = '		}';
			$script[] = '		SqueezeBox.close();';
			$script[] = '	}';
		}
		

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		// Load the current username if available.
		include_once(JPATH_ADMINISTRATOR."/components/com_osproperty/tables/agent.php");
		$table = JTable::getInstance('Agent','OspropertyTable');
		
		if ($agent_id)
		{
			$table->load($agent_id);
		}
		else
		{
			$table->name = JText::_('OS_SELECT_AGENT');
		}

		// Create a dummy text field with the user name.
		$html[] = '<span class="input-append btn-group">';
		$html[] = '<input type="text" class="input-medium form-control" id="agent_id_name" value="'.htmlspecialchars($table->name, ENT_COMPAT, 'UTF-8') .'" disabled="disabled" size="35" /><a class="modal_user_id btn btn-primary" title="'.JText::_('JLIB_FORM_CHANGE_USER').'"  href="'.$link.'" rel="{handler: \'iframe\', size: {x: 800, y: 450}}"><i class="icon-file"></i> '.JText::_('JLIB_FORM_CHANGE_USER').'</a>';
		$html[] = '</span>';

		// Create the real field, hidden, that stored the user id.
		$html[] = '<input type="hidden" id="agent_id" name="agent_id" value="'.$agent_id.'" />';

		return implode("\n", $html);
	}
}
?>