<?php
/*------------------------------------------------------------------------
# report.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;


class HTML_OSappscheduleReport{
	/**
	 * Export Report
	 *
	 */
	static function exportReport($lists){
		global $mainframe,$configClass,$cClass,$bootstrapHelper;
		JToolBarHelper::title(JText::_('OS_REPORT_GENERATION'));
		JToolBarHelper::cancel('goto_index');
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		$rowFluidClass = $bootstrapHelper->getClassMapping('row-fluid');
		$span12Class = $bootstrapHelper->getClassMapping('span12');
		$span5Class = $bootstrapHelper->getClassMapping('span5');
		$span7Class = $bootstrapHelper->getClassMapping('span7');
		$span3Class = $bootstrapHelper->getClassMapping('span3');
		$span4Class = $bootstrapHelper->getClassMapping('span4');
		?>
		<form method="POST" action="index.php?option=com_oscalendar&tmpl=component" target="_blank" name="adminForm" id="adminForm">
		<div class="<?php echo $rowFluidClass; ?>">
			<div class="<?php echo $span12Class;?> btn btn-info" style="margin-left:0px;text-align:left;">
				<strong><?php echo strtoupper(JText::_('OS_PLEASE_SELECT_FILTER_PARAMETERS_FOR_YOUR_REPORT'));?></strong>
			</div>
		<div class="<?php echo $rowFluidClass; ?>">
				<div class="<?php echo $span3Class;?>" style="margin-left:0px;">
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_PROPERTY_TYPES')?></label>
						<div class="controls">
							<?php echo $lists['type'];?>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_CATEGORY')?></label>
						<div class="controls">
							<?php echo $lists['category'];?>
						</div>
					</div>
				</div>
				<div class="<?php echo $span5Class;?>" style="margin-left:0px;">
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_PROPERTY')?></label>
						<div class="controls">
							<?php
							echo OSappscheduleOrders::getPropertyInput();
							?>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_AGENT')?></label>
						<div class="controls">
							<?php
							echo OSappscheduleReport::getUserInput();
							?>
						</div>
					</div>
				</div>
				<div class="<?php echo $span4Class;?>" style="margin-left:0px;">
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_PAYMENT')?></label>
						<div class="controls">
							<?php
							echo $lists['plugins'];
							?>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_STATUS')?></label>
						<div class="controls">
							<?php
							echo $lists['status'];
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="<?php echo $rowFluidClass; ?>">
				<div class="<?php echo $span12Class;?>" style="margin-left:0px;text-align:left;">
					<?php echo JText::_('OS_FROM');?>: 
					<?php 
						echo JHTML::_('calendar','', 'book_from', 'book_from', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
					?>
					&nbsp;&nbsp;
					<?php echo JText::_('OS_TO');?>: 
					<?php 
						echo JHTML::_('calendar','', 'book_to', 'book_to', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
					?>
				</div>
			</div>
			<div class="clearfix"></div>
			<div style="height:10px;"></div>
			<div class="<?php echo $span12Class;?> btn btn-warning" style="margin-left:0px;text-align:left;">
				<strong><?php echo strtoupper(JText::_('OS_INCLUDE_PRICE_DETAILS'));?></strong>
				<div class="clearfix"></div>
				<div class="control-group">
					<div class="controls">
						<?php
						echo $lists['details'];
						?>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
			<div style="height:10px;"></div>
			<div class="<?php echo $span12Class;?> btn btn-danger" style="margin-left:0px;text-align:left;">
				<div class="<?php echo $span3Class;?>" style="margin-left:0px;">
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_SORT_BY')?></label>
						<div class="controls">
							<?php
							echo $lists['sortby'];
							?>
						</div>
					</div>
				</div>
				<div class="<?php echo $span3Class;?>" style="margin-left:0px;">
					<div class="control-group">
						<label class="control-label"><?php echo JText::_('OS_ORDER_BY')?></label>
						<div class="controls">
							<?php
							echo $lists['orderby'];
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
			<div style="height:10px;"></div>
			<div class="<?php echo $span12Class;?> btn" style="margin-left:0px;padding:10px;text-align:center;">
				<a href="javascript:exportReport();" class="btn btn-info">
					<i class="icon-download"></i>
					<?php echo JText::_('OS_GENERAL_REPORT');?>
				</a>
				<a href="javascript:showPrint();" class="btn btn-info">
					<i class="icon-print"></i>
					<?php echo JText::_('OS_PRINT_REPORT');?>
				</a>
			</div>
		</div>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="report_export" />
		<input type="hidden" name="print" id="print" value="0" />
		</form>
		<script language="javascript">
		function showPrint(){
			var form = document.adminForm;
			form.print.value = "1";
			form.submit();
		}
		function exportReport(){
			var form = document.adminForm;
			form.print.value = "0";
			form.submit();
		}
		</script>
		<?php
	}
	
	/**
	 * Export report
	 *
	 * @param unknown_type $rows
	 */
	static function genericReport($rows,$fields){
		global $mainframe,$configClass,$cClass;
		?>
		<div class="<?php echo $rowFluidClass; ?>">
			<div class="span12">
				<h1>
					<?php echo JText::_('OS_REPORT')?>
				</h1>
				<h2>
				<?php
				if($mainframe->input->getString('book_from','') != ""){
					echo JText::_('OS_FROM').": ";
					echo $mainframe->input->getString('book_from','');
				}
				if($mainframe->input->getString('book_to','') != ""){
					echo "   ";
					echo JText::_('OS_TO').": ";
					echo $mainframe->input->getString('book_to','');
				}
				?>
				</h2>
				<strong><?php echo JText::_('OS_REPORT_GENERATED');?>: <?php echo date($cClass['date_time_format'],time());?></strong>
				<BR /><BR />
                <?php
                if(count($rows) > 0) {
                    ?>
                    <table width="100%">
                        <tr>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;padding:5px;padding:5px;"
                                width="7%">
                                <?php echo JText::_('OS_TRANSACTION_DATE');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="6%">
                                <?php echo JText::_('OS_INTERNAL_REFERENCE_NUMBER');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="15%">
                                <?php echo JText::_('OS_CUSTOMER_NAME');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="20%">
                                <?php echo JText::_('OS_PROPERTY');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="10%">
                                <?php echo JText::_('OS_AGENT');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="7%">
                                <?php echo JText::_('OS_PAYMENT');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="7%">
                                <?php echo JText::_('OS_TRANSACTIONID');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="15%">
                                <?php echo JText::_('OS_CUSTOMER_CONTACT');?>
                            </td>
                            <?php if($cClass['allow_room'] == 1){ ?>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="10%">
                                <?php echo JText::_('OS_ROOM');?>
                            </td>
                            <?php } ?>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="10%">
                                <?php echo JText::_('OS_CALENDAR_CHECK_IN');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="10%">
                                <?php echo JText::_('OS_CALENDAR_CHECK_OUT');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="5%">
                                <?php echo JText::_('OS_NIGHTS');?>
                            </td>
                            <?php
                            if ($cClass['enable_tax'] == 1) {
                                ?>
                                <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                    width="12%">
                                    <?php echo JText::_('OS_SUBTOTAL');?>
                                </td>
                                <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                    width="12%">
                                    <?php echo JText::_('OS_TAX');?>
                                </td>
                            <?php
                            }
                            ?>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="12%">
                                <?php echo JText::_('OS_TOTAL');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="12%">
                                <?php echo JText::_('OS_DEPOSIT');?>
                            </td>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="7%">
                                <?php echo JText::_('OS_STATUS');?>
                            </td>
                        </tr>
                        <?php
                        $db = JFactory::getDbo();
                        $subtotal = 0;
                        $total = 0;
                        $tax = 0;
                        $deposit = 0;
                        for ($i = 0; $i < count($rows); $i++) {
                            $row = $rows[$i];
                            if ($i % 2 == 0) {
                                $bgcolor = "#E0E0E0";
                            } else {
                                $bgcolor = "#F0F0F0";
                            }

                            ?>
                            <tr>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo date($cClass['date_format'], strtotime($row->order_date));
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo str_pad($row->order_id, 5, "0", STR_PAD_LEFT);
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:left;">
                                    <?php
                                    echo $row->name;
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:left;">
                                    <?php
                                    if ($row->ref != "") {
                                        echo $row->ref . ", ";
                                    }
                                    echo $row->pro_name;
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:left;">
                                    <?php
                                    echo $row->agent_name;
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:left;">
                                    <?php
                                    $db->setQuery("Select title from #__oscalendar_plugins where name like '$row->payment_method'");
                                    echo $db->loadResult();
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo $row->transaction_id;
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:left;">
                                    <?php
                                    if ($row->phone != "") {
                                        echo JText::_('OS_CALENDAR_PHONE') . ": " . $row->phone . "<BR />";
                                    }
                                    if ($row->email != "") {
                                        echo JText::_('OS_CALENDAR_EMAIL_ADDRESS') . ": " . $row->email . "<BR />";
                                    }
                                    ?>
                                </td>
                                <?php if($cClass['allow_room'] == 1){ ?>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo $row->nroom;
                                    ?>
                                    -
                                    <?php
                                    echo $row->room_name;
                                    ?>
                                </td>
                                <?php } ?>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo date($cClass['date_format'], strtotime($row->book_from));
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo date($cClass['date_format'], strtotime($row->book_to));
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:center;">
                                    <?php
                                    echo OSCHelper::calNights(strtotime($row->book_from), strtotime($row->book_to));
                                    ?>
                                </td>
                                <?php
                                if ($cClass['enable_tax'] == 1) {
                                    ?>
                                    <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:right;">
                                        <?php
                                        echo OSCHelper::showMoneyWithoutCurrency($row->amount);
                                        $subtotal += round($row->amount, 2);
                                        ?>
                                    </td>
                                    <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:right;">
                                        <?php
                                        echo OSCHelper::showMoneyWithoutCurrency($row->tax);
                                        $tax += round($row->tax, 2);
                                        ?>
                                    </td>
                                <?php
                                }
                                ?>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:right;">
                                    <?php
                                    echo OSCHelper::showMoneyWithoutCurrency($row->total);
                                    $total += round($row->total, 2);
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:right;">
                                    <?php
                                    echo OSCHelper::showMoneyWithoutCurrency($row->deposit);
                                    $deposit += round($row->deposit, 2);
                                    ?>
                                </td>
                                <td style="background-color:<?php echo $bgcolor?>;height:25px;padding:5px;border-bottom:1px solid #000;border-right:1px solid #000;text-align:right;">
                                    <?php
                                    switch ($row->order_status) {
                                        case "P":
                                            echo JText::_('OS_PENDING');
                                            break;
                                        case "C":
                                            echo JText::_('OS_CANCEL');
                                            break;
                                        case "S":
                                            echo JText::_('OS_COMPLETE');
                                            break;
                                    }
                                    ?>
                                </td>
                            </tr>
                            <?php
                            if ($mainframe->input->getInt(report_details, 0) == 1) {
                                ?>
                                <tr>
                                    <td width="100%" colspan="16" style="text-align:center;">
                                        <?php
                                        $total1 = 0;
                                        $total2 = 0;
                                        $total3 = 0;
                                        ?>
                                        <table width="100%">
                                            <tr>
                                                <td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid back !important;border-right:1px solid black !important;"
                                                    width="60%">
                                                    <?php echo JText::_('OS_PRICE_BREAKDOWN');?>
                                                </td>
                                                <?php
                                                if ($cClass['enable_tax'] == 1) {
                                                    ?>
                                                    <td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid back !important;border-right:1px solid black !important;"
                                                        width="10%">
                                                        <?php echo JText::_('OS_RATE');?>
                                                    </td>
                                                    <td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid back !important;border-right:1px solid black !important;"
                                                        width="10%">
                                                        <?php echo JText::_('OS_CALENDAR_TAX');?>
                                                    </td>
                                                <?php } ?>
                                                <td style="color:white;background-color:#D42603;pading:7px;text-align:left;font-weight:bold;border-bottom:1px solid back !important;"
                                                    width="10%">
                                                    <?php echo JText::_('OS_INCL_TAX');?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;border-right:1px solid black !important;"
                                                    width="60%">

                                                </td>
                                                <?php
                                                if ($cClass['enable_tax'] == 1) {
                                                    ?>
                                                    <td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;border-right:1px solid black !important;"
                                                        width="10%">
                                                        <?php echo $row->curr;?>
                                                    </td>
                                                    <td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;border-right:1px solid black !important;"
                                                        width="10%">
                                                        <?php echo $row->curr;?>
                                                    </td>
                                                <?php } ?>
                                                <td style="color:white;background-color:#A22415;pading:7px;text-align:left;font-weight:bold;border-bottom:3px solid white !important;"
                                                    width="10%">
                                                    <?php echo $row->curr;?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="color:white;background-color:#ABABAB;pading:7px;text-align:left;font-weight:bold;"
                                                    width="100%" colspan="4">
                                                    <?php echo JText::_('OS_BOOKING_REFERENCE_NO')?>:
                                                    #<?php echo str_pad($row->order_id, 5, "0", STR_PAD_LEFT);;?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="color:gray;background-color:#fff;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                    width="60%">
                                                    <?php echo JText::_('OS_ROOM_FEE');?>
                                                </td>
                                                <?php
                                                if ($cClass['enable_tax'] == 1) {
                                                    ?>
                                                    <td style="color:gray;background-color:#fff;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                        width="10%">
                                                        <?php echo OSCHelper::showMoneyWithoutCurrency($row->room_fee);
                                                        $total1 += $row->room_fee;
                                                        ?>
                                                    </td>
                                                    <td style="color:gray;background-color:#fff;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                        width="10%">
                                                        <?php echo OSCHelper::showMoneyWithoutCurrency(round(($row->room_fee * $cClass['tax_payment']) / 100, 2));
                                                        $total2 += round(($row->room_fee * $cClass['tax_payment']) / 100, 2);
                                                        ?>
                                                    </td>
                                                <?php } ?>
                                                <td style="color:gray;background-color:#fff;pading:7px;text-align:left;"
                                                    width="10%">
                                                    <?php echo OSCHelper::showMoneyWithoutCurrency(round($row->room_fee + round(($row->room_fee * $cClass['tax_payment']) / 100, 2), 2));
                                                    $total3 += round($row->room_fee + round(($row->room_fee * $cClass['tax_payment']) / 100, 2), 2);
                                                    ?>
                                                </td>
                                            </tr>
                                            <?php
                                            if (count($fields) > 0) {
                                                $k = 0;
                                                for ($i = 0; $i < count($fields); $i++) {
                                                    $field = $fields[$i];
                                                    switch ($field->field_type) {
                                                        case "0":
                                                        case "1":
                                                            $db->setQuery("Select * from #__oscalendar_order_field_values where order_id = '$row->order_id' and field_id = '$field->id'");
                                                            $values = $db->loadObjectList();
                                                            if (count($values) > 0) {
                                                                if ($k % 2 == 0) {
                                                                    $bgcolor = "#efefef";
                                                                } else {
                                                                    $bgcolor = "#ffffff";
                                                                }
                                                                $k++;
                                                                $value = $values[0]->field_value;
                                                                ?>
                                                                <tr>
                                                                    <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                        width="60%">
                                                                        <?php echo $field->field_label;?>
                                                                        : <?php echo $value;?>
                                                                    </td>
                                                                    <?php
                                                                    if ($cClass['enable_tax'] == 1) {
                                                                        ?>
                                                                        <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                            width="10%">
                                                                            <?php echo OSCHelper::showMoneyWithoutCurrency(0);?>
                                                                        </td>
                                                                        <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                            width="10%">
                                                                            <?php echo OSCHelper::showMoneyWithoutCurrency(0);?>
                                                                        </td>
                                                                    <?php
                                                                    }
                                                                    ?>
                                                                    <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;"
                                                                        width="10%">
                                                                        <?php echo OSCHelper::showMoneyWithoutCurrency(0);?>
                                                                    </td>
                                                                </tr>
                                                            <?php
                                                            }
                                                            break;
                                                        case "2":
                                                            $query = "Select a.*,b.option_price from #__oscalendar_field_options as a inner join #__oscalendar_order_field_options as b on a.id = b.option_id where b.order_id = '$row->order_id' and b.field_id = '$field->id'";
                                                            $db->setQuery($query);
                                                            $values = $db->loadObjectList();
                                                            if (count($values) > 0) {
                                                                if ($k % 2 == 0) {
                                                                    $bgcolor = "#efefef";
                                                                } else {
                                                                    $bgcolor = "#ffffff";
                                                                }
                                                                $k++;
                                                                $value = $values[0];
                                                                ?>
                                                                <tr>
                                                                    <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                        width="60%">
                                                                        <?php echo $field->field_label;?>:
                                                                        <?php echo $value->field_option;?>
                                                                    </td>
                                                                    <?php
                                                                    if ($cClass['enable_tax'] == 1) {
                                                                        ?>
                                                                        <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                            width="10%">
                                                                            <?php echo OSCHelper::showMoneyWithoutCurrency($value->option_price);
                                                                            $total1 += $value->option_price;
                                                                            ?>
                                                                        </td>
                                                                        <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                            width="10%">
                                                                            <?php echo OSCHelper::showMoneyWithoutCurrency(round(($value->option_price * $cClass['tax_payment']) / 100, 2));
                                                                            $total2 += round(($value->option_price * $cClass['tax_payment']) / 100, 2);
                                                                            ?>
                                                                        </td>
                                                                    <?php } ?>
                                                                    <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;"
                                                                        width="10%">
                                                                        <?php echo OSCHelper::showMoneyWithoutCurrency(round($value->option_price + round(($value->option_price * $cClass['tax_payment']) / 100, 2), 2));
                                                                        $total3 += round($value->option_price + round(($value->option_price * $cClass['tax_payment']) / 100, 2), 2);
                                                                        ?>
                                                                    </td>
                                                                </tr>
                                                            <?php
                                                            }
                                                            break;
                                                        case "3":
                                                            $query = "Select a.*,b.option_price from #__oscalendar_field_options as a inner join #__oscalendar_order_field_options as b on a.id = b.option_id where b.order_id = '$row->order_id' and b.field_id = '$field->id'";
                                                            $db->setQuery($query);
                                                            $values = $db->loadObjectList();
                                                            if (count($values) > 0) {
                                                                if ($k % 2 == 0) {
                                                                    $bgcolor = "#efefef";
                                                                } else {
                                                                    $bgcolor = "#ffffff";
                                                                }
                                                                $k++;
                                                                $temp = array();
                                                                $fieldtotal = 0;
                                                                for ($j = 0; $j < count($values); $j++) {
                                                                    $value = $values[$j];
                                                                    $temp[] = $value->field_option;
                                                                    $fieldtotal += $value->option_price;
                                                                }
                                                                ?>
                                                                <tr>
                                                                    <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                        width="60%">
                                                                        <?php echo $field->field_label;?>:
                                                                        <?php echo implode(" + ", $temp);?>
                                                                    </td>
                                                                    <?php
                                                                    if ($cClass['enable_tax'] == 1) {
                                                                        ?>
                                                                        <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                            width="10%">
                                                                            <?php echo OSCHelper::showMoneyWithoutCurrency(round($fieldtotal, 2));
                                                                            $total1 += $fieldtotal;
                                                                            ?>
                                                                        </td>
                                                                        <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;border-right:1px solid black !important;"
                                                                            width="10%">
                                                                            <?php echo OSCHelper::showMoneyWithoutCurrency(round(($fieldtotal * $cClass['tax_payment']) / 100, 2));
                                                                            $total2 += round(($fieldtotal * $cClass['tax_payment']) / 100, 2);
                                                                            ?>
                                                                        </td>
                                                                    <?php } ?>
                                                                    <td style="color:gray;background-color:<?php echo $bgcolor?>;pading:7px;text-align:left;"
                                                                        width="10%">
                                                                        <?php echo OSCHelper::showMoneyWithoutCurrency(round($fieldtotal + round(($total * $cClass['tax_payment']) / 100, 2), 2));
                                                                        $total3 += round($fieldtotal + round(($fieldtotal * $cClass['tax_payment']) / 100, 2), 2);
                                                                        ?>
                                                                    </td>
                                                                </tr>
                                                            <?php
                                                            }
                                                            break;
                                                    }
                                                }
                                            }
                                            ?>
                                            <tr>
                                                <td style="color:white;background-color:#ABABAB;pading:7px;text-align:left;border-right:1px solid black !important;font-weight:bold;"
                                                    width="100%" colspan="5">
                                                    &nbsp;
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid black !important;font-weight:bold;"
                                                    width="60%">
                                                    <?php echo JText::_('OS_TOTAL_PRICE');?>
                                                </td>
                                                <?php
                                                if ($cClass['enable_tax'] == 1) {
                                                    ?>
                                                    <td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid black !important;font-weight:bold;"
                                                        width="10%">
                                                        <?php echo OSCHelper::showMoneyWithoutCurrency($total1);?>
                                                    </td>
                                                    <td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid black !important;font-weight:bold;"
                                                        width="10%">
                                                        <?php echo OSCHelper::showMoneyWithoutCurrency($total2);?>
                                                    </td>
                                                <?php } ?>
                                                <td style="color:gray;background-color:#efefef;pading:7px;text-align:left;border-right:1px solid black !important;font-weight:bold;"
                                                    width="10%">
                                                    <?php echo OSCHelper::showMoneyWithoutCurrency($total3);?>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            <?php
                            }
                        }
                        ?>
                        <tr>
                            <?php
                            if ($cClass['enable_tax'] == 1) {
                                $col = 12;
                            } else {
                                $col = 13;
                            }
                            ?>
                            <td style="height:30px;font-weight:bold;text-align:left;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;padding:5px;padding:5px;"
                                width="7%" colspan="<?php echo $col;?>">
                                <strong><?php echo JText::_('OS_TOTAL');?></strong>
                            </td>
                            <?php
                            if ($cClass['enable_tax'] == 1) {
                                ?>
                                <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                    width="12%">
                                    <?php echo OSCHelper::showMoney($subtotal, 1);?>
                                </td>
                                <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                    width="12%">
                                    <?php echo OSCHelper::showMoney($tax, 1);?>
                                </td>
                                <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                    width="12%">
                                    <?php echo OSCHelper::showMoney($total, 1);?>
                                </td>
                            <?php
                            }
                            ?>
                            <td style="height:30px;font-weight:bold;text-align:center;vertical-align:middle;border-right:1px solid #000;background-color:orange;padding:5px;"
                                width="12%" colspan="2">
                                <?php echo OSCHelper::showMoney($deposit, 1);?>
                            </td>
                        </tr>
                    </table>
                <?php
                }else{
                    ?>
                    <div class="alert">
                        No marching results
                    </div>
                    <?php
                }
                ?>
			</div>
		</div>
		<?php
		$print = $mainframe->input->getInt('print',0);
		if($print == 1){
		?>
		<script language="javascript">
			window.print();
		</script>
		<?php
		}
	}
}
?>